/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.spring;

import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.internal.util.FakeServletConfig;
import org.devefx.validator.internal.util.StartupUtil;
import org.devefx.validator.internal.util.WebContextThreadStack;
import org.devefx.validator.script.UrlProcessor;
import org.devefx.validator.spring.SpringContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.AbstractController;

public class ValidatorController
extends AbstractController
implements BeanNameAware,
BeanFactoryAware,
InitializingBean {
    private static final Log log = LogFactory.getLog(ValidatorController.class);
    private String name;
    private SpringContainer container;
    private ServletConfig servletConfig;
    private UrlProcessor processor;

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.container = new SpringContainer(beanFactory);
    }

    public void setupUrlMapping(SimpleUrlHandlerMapping urlHandlerMapping) {
        HashMap<String, ValidatorController> urlMap = new HashMap<String, ValidatorController>();
        for (String url : this.processor.getUrlMapping().keySet()) {
            if (url.endsWith("/")) {
                url = String.valueOf(url) + "**";
            }
            urlMap.put(url, this);
        }
        urlHandlerMapping.setUrlMap(urlMap);
    }

    public void afterPropertiesSet() throws Exception {
        ServletContext servletContext = this.getServletContext();
        Assert.notNull((Object)servletContext, (String)"The servlet context has not been set on the controller");
        this.servletConfig = new FakeServletConfig(this.name, this.getServletContext());
        try {
            StartupUtil.setupDefaultContainer(this.container, this.servletConfig);
        }
        catch (Exception e) {
            log.fatal((Object)"init failed", (Throwable)e);
        }
        this.processor = this.container.getBean(UrlProcessor.class);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            WebContextThreadStack.engageThread(this.servletConfig, request, response);
            this.processor.handle(request, response);
        }
        finally {
            WebContextThreadStack.disengageThread();
        }
        return null;
    }
}

