/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

public class ResourceUtils {
    private static ClassLoader defaultClassLoader;
    private static Charset charset;

    public static void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        ResourceUtils.defaultClassLoader = defaultClassLoader;
    }

    public static URL getResourceAsUrl(ClassLoader loader, String resource) throws IOException {
        URL url = null;
        if (loader != null) {
            url = loader.getResource(resource);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resource);
        }
        if (url == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return url;
    }

    public static URL getResourceAsUrl(String resource) throws IOException {
        return ResourceUtils.getResourceAsUrl(ResourceUtils.getClassLoader(), resource);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resource) throws IOException {
        InputStream in = null;
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        return ResourceUtils.getResourceAsStream(ResourceUtils.getClassLoader(), resource);
    }

    public static Reader getResourceAsReader(String resource) throws IOException {
        if (charset == null) {
            return new InputStreamReader(ResourceUtils.getResourceAsStream(resource));
        }
        return new InputStreamReader(ResourceUtils.getResourceAsStream(resource), charset);
    }

    public static Reader getResourceAsReader(ClassLoader loader, String resource) throws IOException {
        if (charset == null) {
            return new InputStreamReader(ResourceUtils.getResourceAsStream(loader, resource));
        }
        return new InputStreamReader(ResourceUtils.getResourceAsStream(loader, resource), charset);
    }

    public static String getResourceAsString(String resource) throws IOException {
        return ResourceUtils.getResourceAsString(ResourceUtils.getClassLoader(), resource);
    }

    public static String getResourceAsString(ClassLoader loader, String resource) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            bufferedReader = new BufferedReader(ResourceUtils.getResourceAsReader(loader, resource));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (builder.length() != 0) {
                    builder.append("\n");
                }
                builder.append(line);
            }
        }
        return builder.toString();
    }

    public static InputStream getUrlAsStream(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        return conn.getInputStream();
    }

    public static Reader getUrlAsReader(String urlString) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(ResourceUtils.getUrlAsStream(urlString)) : new InputStreamReader(ResourceUtils.getUrlAsStream(urlString), charset);
        return reader;
    }

    public static void close(Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ClassLoader getClassLoader() {
        if (defaultClassLoader != null) {
            return defaultClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static Charset getCharset() {
        return charset;
    }

    public static void setCharset(Charset charset) {
        ResourceUtils.charset = charset;
    }
}

