/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.util;

public final class ScriptUtil {
    private ScriptUtil() {
    }

    public static boolean isValidScriptName(String test) {
        return ScriptUtil.isSafeHierarchicalIdentifierInBrowser(test);
    }

    public static boolean isSafeHierarchicalIdentifierInBrowser(String test) {
        String[] segments;
        if (test.endsWith("/")) {
            return false;
        }
        String[] stringArray = segments = test.split("\\.");
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.equals("")) {
                return false;
            }
            if (!ScriptUtil.isSafeIdentifierInBrowser(segment)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isSafeIdentifierInBrowser(String test) {
        int i = 0;
        while (i < test.length()) {
            char ch = test.charAt(i);
            if ("<>&'\"".indexOf(ch) >= 0) {
                return false;
            }
            if (";?#%".indexOf(ch) >= 0) {
                return false;
            }
            if (!(ch >= ' ' && '~' >= ch || Character.isLetterOrDigit(ch))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

