/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final char DEFAULT_DELIMITER_CHAR = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String clean(String in) {
        String out = in;
        if (in != null && (out = in.trim()).equals(EMPTY_STRING)) {
            out = null;
        }
        return out;
    }

    public static String[] split(String line) {
        return StringUtils.split(line, ',');
    }

    public static String[] split(String line, char delimiter) {
        return StringUtils.split(line, delimiter, '\"');
    }

    public static String[] split(String line, char delimiter, char quoteChar) {
        return StringUtils.split(line, delimiter, quoteChar, quoteChar);
    }

    public static String[] split(String line, char delimiter, char beginQuoteChar, char endQuoteChar) {
        return StringUtils.split(line, delimiter, beginQuoteChar, endQuoteChar, false, true);
    }

    public static String[] split(String aLine, char delimiter, char beginQuoteChar, char endQuoteChar, boolean retainQuotes, boolean trimTokens) {
        String line = StringUtils.clean(aLine);
        if (line == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == beginQuoteChar) {
                if (inQuotes && line.length() > i + 1 && line.charAt(i + 1) == beginQuoteChar) {
                    sb.append(line.charAt(i + 1));
                    ++i;
                } else {
                    boolean bl = inQuotes = !inQuotes;
                    if (retainQuotes) {
                        sb.append(c);
                    }
                }
            } else if (c == endQuoteChar) {
                boolean bl = inQuotes = !inQuotes;
                if (retainQuotes) {
                    sb.append(c);
                }
            } else if (c == delimiter && !inQuotes) {
                String s = sb.toString();
                if (trimTokens) {
                    s = s.trim();
                }
                tokens.add(s);
                sb = new StringBuilder();
            } else {
                sb.append(c);
            }
            ++i;
        }
        String s = sb.toString();
        if (trimTokens) {
            s = s.trim();
        }
        tokens.add(s);
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (coll == null || coll.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, EMPTY_STRING, EMPTY_STRING);
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }
}

