/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.devefx.validator.util.Assert;

public class UriUtils {
    private static final String ALLOWED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_.!~*'()";

    public static String encodeUriComponent(String source, String encoding) throws UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        Assert.hasLength(encoding, "Encoding must not be empty");
        byte[] bytes = UriUtils.encodeBytes(source.getBytes(encoding));
        return new String(bytes, "US-ASCII");
    }

    private static byte[] encodeBytes(byte[] source) {
        Assert.notNull(source, "Source must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);
        byte[] byArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (ALLOWED_CHARS.indexOf(b) != -1) {
                bos.write(b);
            } else {
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            ++n2;
        }
        return bos.toByteArray();
    }
}

