/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.devefx.validator.util.ClassUtils;
import org.devefx.validator.util.MapUtils;

public class XmlWriter {
    private static int convertDepth = 15;
    private static String timestampPattern = "yyyy-MM-dd HH:mm:ss";
    private static String datePattern = "yyyy-MM-dd";
    private static boolean ignoreNull = true;

    public static void setConvertDepth(int convertDepth) {
        if (convertDepth < 2) {
            throw new IllegalArgumentException("convert depth can not less than 2.");
        }
        XmlWriter.convertDepth = convertDepth;
    }

    public static void setTimestampPattern(String timestampPattern) {
        if (timestampPattern == null || "".equals(timestampPattern.trim())) {
            throw new IllegalArgumentException("timestampPattern can not be blank.");
        }
        XmlWriter.timestampPattern = timestampPattern;
    }

    public static void setDatePattern(String datePattern) {
        if (datePattern == null || "".equals(datePattern.trim())) {
            throw new IllegalArgumentException("datePattern can not be blank.");
        }
        XmlWriter.datePattern = datePattern;
    }

    public static void setIgnoreNull(boolean ignoreNull) {
        XmlWriter.ignoreNull = ignoreNull;
    }

    public static String beanToXml(Object bean) {
        return XmlWriter.beanToXml(bean, convertDepth);
    }

    public static String beanToXml(Object bean, int depth) {
        if (bean == null) {
            return "</null>";
        }
        Class<?> beanClass = bean.getClass();
        String rootName = beanClass.getSimpleName();
        StringBuilder sb = new StringBuilder();
        XmlWriter.appendBegin(rootName, sb);
        if (bean instanceof Map) {
            XmlWriter.mapToXml((Map)bean, sb, depth);
        } else {
            XmlWriter.mapToXml(MapUtils.beanToMap(bean), sb, depth);
        }
        XmlWriter.appendEnd(rootName, sb);
        return sb.toString();
    }

    private static void mapToXml(Map<String, ?> map, StringBuilder sb, int depth) {
        if (map == null || depth-- < 0) {
            return;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (ignoreNull && value == null) continue;
            XmlWriter.appendBegin(key, sb);
            if (value != null) {
                if (value instanceof CharSequence || ClassUtils.isPrimitiveWrapper(value.getClass())) {
                    XmlWriter.escape(value.toString(), sb);
                } else if (value instanceof Date) {
                    if (value instanceof Timestamp) {
                        sb.append(new SimpleDateFormat(timestampPattern).format(value));
                    }
                    if (value instanceof Time) {
                        sb.append(value);
                    } else {
                        sb.append(new SimpleDateFormat(datePattern).format(value));
                    }
                } else if (value instanceof Map) {
                    XmlWriter.mapToXml((Map)value, sb, depth);
                } else {
                    XmlWriter.mapToXml(MapUtils.beanToMap(value), sb, depth);
                }
            }
            XmlWriter.appendEnd(key, sb);
        }
    }

    private static void escape(String s, StringBuilder sb) {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String str = Integer.toHexString(ch);
                        sb.append("\\u");
                        int k = 0;
                        while (k < 4 - str.length()) {
                            sb.append('0');
                            ++k;
                        }
                        sb.append(str.toUpperCase());
                        break;
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
    }

    private static void appendBegin(String s, StringBuilder sb) {
        sb.append("<").append(s).append(">");
    }

    private static void appendEnd(String s, StringBuilder sb) {
        sb.append("</").append(s).append(">");
    }
}

