/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.web.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.beans.Container;
import org.devefx.validator.internal.util.StartupUtil;
import org.devefx.validator.internal.util.WebContextThreadStack;
import org.devefx.validator.script.UrlProcessor;

public class ScriptSupportServlet
extends HttpServlet {
    private static final long serialVersionUID = 3093149631565854976L;
    private static final Log log = LogFactory.getLog(ScriptSupportServlet.class);
    protected Container container;
    protected ServletConfig servletConfig;
    protected UrlProcessor processor;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.container = StartupUtil.createAndSetupDefaultContainer(servletConfig);
            this.servletConfig = servletConfig;
        }
        catch (Exception ex) {
            log.fatal((Object)"init failed", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        this.processor = this.container.getBean(UrlProcessor.class);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebContextThreadStack.engageThread(this.servletConfig, request, response);
            this.processor.handle(request, response);
        }
        finally {
            WebContextThreadStack.disengageThread();
        }
    }
}

