/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.web.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.devefx.validator.web.view.AbstractView;

public abstract class AbstractNestedView
extends AbstractView {
    private Charset charset = Charset.forName("UTF-8");
    private Set<String> modelKeys;
    private boolean extractValueFromSingleKeyModel = false;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setModelKey(String modelKey) {
        this.modelKeys = Collections.singleton(modelKey);
    }

    public void setModelKeys(Set<String> modelKeys) {
        this.modelKeys = modelKeys;
    }

    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream stream = this.createTemporaryOutputStream();
        Object value = this.filterModel(model);
        this.writeContent(stream, value);
        this.writeToResponse(response, stream);
    }

    protected Object filterModel(Map<String, Object> model) {
        HashMap<String, Object> result = new HashMap<String, Object>(model.size());
        Set<String> renderedAttributes = this.modelKeys == null || this.modelKeys.isEmpty() ? model.keySet() : this.modelKeys;
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (!renderedAttributes.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return this.extractValueFromSingleKeyModel && result.size() == 1 ? result.values().iterator().next() : result;
    }

    protected abstract void writeContent(OutputStream var1, Object var2) throws IOException;
}

