/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.web.view;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.devefx.validator.http.HttpStatus;
import org.devefx.validator.util.BeanUtils;
import org.devefx.validator.util.ObjectUtils;
import org.devefx.validator.util.StringUtils;
import org.devefx.validator.util.UriUtils;
import org.devefx.validator.web.view.AbstractUrlBasedView;

public class RedirectView
extends AbstractUrlBasedView {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final Pattern URI_TEMPLATE_VARIABLE_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private boolean contextRelative = false;
    private boolean http10Compatible = true;
    private boolean exposeModelAttributes = true;
    private String encodingScheme;
    private HttpStatus statusCode;
    private boolean expandUriTemplateVariables = true;

    public RedirectView() {
    }

    public RedirectView(String url) {
        super(url);
    }

    public RedirectView(String url, boolean contextRelative) {
        super(url);
        this.contextRelative = contextRelative;
    }

    public RedirectView(String url, boolean contextRelative, boolean http10Compatible) {
        super(url);
        this.contextRelative = contextRelative;
        this.http10Compatible = http10Compatible;
    }

    public RedirectView(String url, boolean contextRelative, boolean http10Compatible, boolean exposeModelAttributes) {
        super(url);
        this.contextRelative = contextRelative;
        this.http10Compatible = http10Compatible;
        this.exposeModelAttributes = exposeModelAttributes;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public void setHttp10Compatible(boolean http10Compatible) {
        this.http10Compatible = http10Compatible;
    }

    public void setExposeModelAttributes(boolean exposeModelAttributes) {
        this.exposeModelAttributes = exposeModelAttributes;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public void setStatusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    public void setExpandUriTemplateVariables(boolean expandUriTemplateVariables) {
        this.expandUriTemplateVariables = expandUriTemplateVariables;
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String targetUrl = this.createTargetUrl(model, request);
        this.sendRedirect(request, response, targetUrl, this.http10Compatible);
    }

    protected final String createTargetUrl(Map<String, Object> model, HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuilder targetUrl = new StringBuilder();
        if (this.contextRelative && this.getUrl().startsWith("/")) {
            targetUrl.append(request.getContextPath());
        }
        targetUrl.append(this.getUrl());
        String enc = this.encodingScheme;
        if (enc == null) {
            enc = request.getCharacterEncoding();
        }
        if (enc == null) {
            enc = DEFAULT_CHARACTER_ENCODING;
        }
        if (this.expandUriTemplateVariables && StringUtils.hasText(targetUrl)) {
            Map<String, String> variables = Collections.emptyMap();
            targetUrl = this.replaceUriTemplateVariables(targetUrl.toString(), model, variables, enc);
        }
        if (this.exposeModelAttributes) {
            this.appendQueryProperties(targetUrl, model, enc);
        }
        return targetUrl.toString();
    }

    protected StringBuilder replaceUriTemplateVariables(String targetUrl, Map<String, Object> model, Map<String, String> currentUriVariables, String encodingScheme) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        Matcher matcher = URI_TEMPLATE_VARIABLE_PATTERN.matcher(targetUrl);
        int endLastMatch = 0;
        while (matcher.find()) {
            Object value;
            String name = matcher.group(1);
            Object object = value = model.containsKey(name) ? model.remove(name) : currentUriVariables.get(name);
            if (value == null) {
                throw new IllegalArgumentException("Model has no value for key '" + name + "'");
            }
            result.append(targetUrl.substring(endLastMatch, matcher.start()));
            result.append(UriUtils.encodeUriComponent(value.toString(), encodingScheme));
            endLastMatch = matcher.end();
        }
        result.append(targetUrl.substring(endLastMatch, targetUrl.length()));
        return result;
    }

    protected void appendQueryProperties(StringBuilder targetUrl, Map<String, Object> model, String encodingScheme) throws UnsupportedEncodingException {
        String fragment = null;
        int anchorIndex = targetUrl.indexOf("#");
        if (anchorIndex > -1) {
            fragment = targetUrl.substring(anchorIndex);
            targetUrl.delete(anchorIndex, targetUrl.length());
        }
        boolean first = targetUrl.toString().indexOf(63) < 0;
        for (Map.Entry<String, Object> entry : this.queryProperties(model).entrySet()) {
            Object rawValue = entry.getValue();
            Iterator<Object> valueIter = rawValue != null && rawValue.getClass().isArray() ? Arrays.asList(ObjectUtils.toObjectArray(rawValue)).iterator() : (rawValue instanceof Collection ? ((Collection)rawValue).iterator() : Collections.singleton(rawValue).iterator());
            while (valueIter.hasNext()) {
                Object value = valueIter.next();
                if (first) {
                    targetUrl.append('?');
                    first = false;
                } else {
                    targetUrl.append('&');
                }
                String encodedKey = this.urlEncode(entry.getKey(), encodingScheme);
                String encodedValue = value != null ? this.urlEncode(value.toString(), encodingScheme) : "";
                targetUrl.append(encodedKey).append('=').append(encodedValue);
            }
        }
        if (fragment != null) {
            targetUrl.append(fragment);
        }
    }

    protected Map<String, Object> queryProperties(Map<String, Object> model) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (!this.isEligibleProperty(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected boolean isEligibleProperty(String key, Object value) {
        if (value == null) {
            return false;
        }
        if (this.isEligibleValue(value)) {
            return true;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return false;
            }
            int i = 0;
            while (i < length) {
                Object element = Array.get(value, i);
                if (!this.isEligibleValue(element)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            if (coll.isEmpty()) {
                return false;
            }
            for (Object element : coll) {
                if (this.isEligibleValue(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isEligibleValue(Object value) {
        return value != null && BeanUtils.isSimpleValueType(value.getClass());
    }

    protected String urlEncode(String input, String encodingScheme) throws UnsupportedEncodingException {
        return input != null ? URLEncoder.encode(input, encodingScheme) : null;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String targetUrl, boolean http10Compatible) throws IOException {
        String encodedRedirectURL = response.encodeRedirectURL(targetUrl);
        if (http10Compatible) {
            if (this.statusCode != null) {
                response.setStatus(this.statusCode.value());
                response.setHeader("Location", encodedRedirectURL);
            } else {
                response.sendRedirect(encodedRedirectURL);
            }
        } else {
            HttpStatus statusCode = this.statusCode;
            if (statusCode == null) {
                statusCode = HttpStatus.SEE_OTHER;
            }
            response.setStatus(statusCode.value());
            response.setHeader("Location", encodedRedirectURL);
        }
    }
}

