/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.sshj;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.ftp.AbstractFtp;
import org.dromara.hutool.extra.ftp.FtpConfig;
import org.dromara.hutool.extra.ftp.FtpException;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.engine.sshj.SshjUtil;

public class SshjSftp
extends AbstractFtp {
    private SSHClient ssh;
    private SFTPClient sftp;

    public static SshjSftp of(String sshHost, String sshUser, String sshPass) {
        return SshjSftp.of(sshHost, 22, sshUser, sshPass);
    }

    public static SshjSftp of(String sshHost, int sshPort, String sshUser, String sshPass) {
        return SshjSftp.of(sshHost, sshPort, sshUser, sshPass, DEFAULT_CHARSET);
    }

    public static SshjSftp of(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        return new SshjSftp(new FtpConfig(Connector.of(sshHost, sshPort, sshUser, sshPass), charset));
    }

    public SshjSftp(FtpConfig config) {
        super(config);
        this.init();
    }

    public SshjSftp(SSHClient sshClient, Charset charset) {
        super(FtpConfig.of().setCharset(charset));
        this.ssh = sshClient;
        this.init();
    }

    public void init() {
        this.ssh = SshjUtil.openClient(this.ftpConfig.getConnector());
        try {
            this.ssh.setRemoteCharset(this.ftpConfig.getCharset());
            this.sftp = this.ssh.newSFTPClient();
        }
        catch (IOException e) {
            throw new FtpException("sftp \u521d\u59cb\u5316\u5931\u8d25.", e);
        }
    }

    @Override
    public AbstractFtp reconnectIfTimeout() {
        if (StrUtil.isBlank((CharSequence)this.ftpConfig.getConnector().getHost())) {
            throw new FtpException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (FtpException e) {
            this.close();
            this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        String exec = String.format("cd %s", directory);
        this.command(exec);
        String pwd = this.pwd();
        return pwd.equals(directory);
    }

    @Override
    public String pwd() {
        return this.command("pwd");
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            this.sftp.mkdir(dir);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return this.containsFile(dir);
    }

    @Override
    public List<String> ls(String path) {
        List infoList;
        try {
            infoList = this.sftp.ls(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        if (CollUtil.isNotEmpty((Collection)infoList)) {
            return CollUtil.map((Iterable)infoList, RemoteResourceInfo::getName);
        }
        return null;
    }

    @Override
    public boolean delFile(String path) {
        try {
            this.sftp.rm(path);
            return !this.containsFile(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean delDir(String dirPath) {
        try {
            this.sftp.rmdir(dirPath);
            return !this.containsFile(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean uploadFile(String destPath, File file) {
        try {
            this.sftp.put((LocalSourceFile)new FileSystemFile(file), destPath);
            return this.containsFile(destPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void download(String path, File outFile) {
        try {
            this.sftp.get(path, (LocalDestFile)new FileSystemFile(outFile));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        List<String> files = this.ls(sourcePath);
        if (files != null && !files.isEmpty()) {
            files.forEach(path -> this.download(sourcePath + "/" + path, destDir));
        }
    }

    @Override
    public InputStream getFileStream(String path) {
        RemoteFile remoteFile;
        try {
            remoteFile = this.sftp.open(path);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        RemoteFile remoteFile2 = remoteFile;
        remoteFile2.getClass();
        return new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile2, 16);
    }

    @Override
    public void close() {
        try {
            this.sftp.close();
            this.ssh.disconnect();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean containsFile(String fileDir) {
        try {
            this.sftp.lstat(fileDir);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String command(String exec) {
        String string;
        Session session = null;
        try {
            session = this.ssh.startSession();
            Session.Command command = session.exec(exec);
            InputStream inputStream = command.getInputStream();
            string = IoUtil.read((InputStream)inputStream, (Charset)DEFAULT_CHARSET);
        }
        catch (Exception e) {
            try {
                throw new FtpException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{session});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{session});
        return string;
    }
}

