/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.aliyun.utils;

import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.dromara.sms4j.aliyun.config.AlibabaConfig;
import org.dromara.sms4j.comm.utils.SmsDateUtils;

public class AliyunUtils {
    private static final String ALGORITHM = "HMAC-SHA1";

    public static String generateSendSmsRequestUrl(AlibabaConfig alibabaConfig, String message, String phone, String templateId) throws Exception {
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("SignatureMethod", ALGORITHM);
        paras.put("SignatureNonce", UUID.randomUUID().toString());
        paras.put("AccessKeyId", alibabaConfig.getAccessKeyId());
        paras.put("SignatureVersion", "1.0");
        paras.put("Timestamp", SmsDateUtils.utcGmt((Date)new Date()));
        paras.put("Format", "JSON");
        paras.put("Action", alibabaConfig.getAction());
        paras.put("Version", alibabaConfig.getVersion());
        paras.put("RegionId", alibabaConfig.getRegionId());
        Map<String, String> paramMap = AliyunUtils.generateParamMap(alibabaConfig, phone, message, templateId);
        TreeMap<String, String> sortParas = new TreeMap<String, String>(paras);
        sortParas.putAll(paramMap);
        Iterator it = sortParas.keySet().iterator();
        StringBuilder sortQueryStringTmp = new StringBuilder();
        while (it.hasNext()) {
            String key = (String)it.next();
            sortQueryStringTmp.append("&").append(AliyunUtils.specialUrlEncode(key)).append("=").append(AliyunUtils.specialUrlEncode((String)sortParas.get(key)));
        }
        String stringToSign = "POST&" + AliyunUtils.specialUrlEncode("/") + "&" + AliyunUtils.specialUrlEncode(sortQueryStringTmp.substring(1));
        String signature = AliyunUtils.sign(alibabaConfig.getAccessKeySecret() + "&", stringToSign);
        StringBuilder sortQueryString = new StringBuilder();
        for (String key : paras.keySet()) {
            sortQueryString.append("&").append(AliyunUtils.specialUrlEncode(key)).append("=").append(AliyunUtils.specialUrlEncode((String)paras.get(key)));
        }
        return "https://" + alibabaConfig.getRequestUrl() + "/?Signature=" + AliyunUtils.specialUrlEncode(signature) + sortQueryString;
    }

    private static String specialUrlEncode(String value) throws Exception {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private static String sign(String accessSecret, String stringToSign) {
        HMac hMac = new HMac(HmacAlgorithm.HmacSHA1, accessSecret.getBytes());
        return hMac.digestBase64(stringToSign, StandardCharsets.UTF_8, false);
    }

    public static Map<String, String> generateParamMap(AlibabaConfig alibabaConfig, String phone, String message, String templateId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("PhoneNumbers", phone);
        paramMap.put("SignName", alibabaConfig.getSignature());
        paramMap.put("TemplateParam", message);
        paramMap.put("TemplateCode", templateId);
        return paramMap;
    }

    public static String generateParamBody(AlibabaConfig alibabaConfig, String phone, String message, String templateId) throws Exception {
        Map<String, String> paramMap = AliyunUtils.generateParamMap(alibabaConfig, phone, message, templateId);
        StringBuilder sortQueryString = new StringBuilder();
        for (String key : paramMap.keySet()) {
            sortQueryString.append("&").append(AliyunUtils.specialUrlEncode(key)).append("=").append(AliyunUtils.specialUrlEncode(paramMap.get(key)));
        }
        return sortQueryString.substring(1);
    }
}

