/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.mas.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.mas.config.MasConfig;
import org.dromara.sms4j.mas.utils.MasUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasSmsImpl
extends AbstractSmsBlend<MasConfig> {
    private static final Logger log = LoggerFactory.getLogger(MasSmsImpl.class);
    private int retry = 0;

    public MasSmsImpl(MasConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public MasSmsImpl(MasConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "mas";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        return this.getSmsResponse(phone, message, ((MasConfig)this.getConfig()).getTemplateId());
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.getSmsResponse(phone, JSONUtil.toJsonStr(messages.values()), ((MasConfig)this.getConfig()).getTemplateId());
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        String messageStr = JSONUtil.toJsonStr(messages.values());
        return this.getSmsResponse(phone, messageStr, templateId);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.getSmsResponse(SmsUtils.addCodePrefixIfNot(phones), message, ((MasConfig)this.getConfig()).getTemplateId());
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        String messageStr = JSONUtil.toJsonStr(messages.values());
        return this.getSmsResponse(SmsUtils.addCodePrefixIfNot(phones), messageStr, templateId);
    }

    private SmsResponse getSmsResponse(String phone, String message, String templateId) {
        SmsResponse smsResponse;
        String base64Code;
        String requestUrl;
        try {
            MasConfig config = (MasConfig)this.getConfig();
            requestUrl = config.getRequestUrl() + config.getAction();
            base64Code = MasUtils.base64Code((MasConfig)this.getConfig(), phone, message, templateId);
        }
        catch (Exception e) {
            log.error("mas 10086 send message error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        log.debug("requestUrl {}", (Object)requestUrl);
        try {
            smsResponse = this.getResponse(this.http.postJson(requestUrl, null, base64Code));
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry >= ((MasConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, message, templateId);
    }

    private SmsResponse requestRetry(String phone, String message, String templateId) {
        this.http.safeSleep(((MasConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(phone, message, templateId);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        return SmsRespUtils.resp((Object)resJson, ("success".equals(resJson.getStr((Object)"rspcod")) && resJson.getBool((Object)"success") != false ? 1 : 0) != 0, (String)this.getConfigId());
    }
}

