/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;

public class DuringPredicate
extends AbstractTemporalPredicate {
    private final long startMinDev;
    private final long startMaxDev = Long.MAX_VALUE;
    private final long endMinDev;
    private final long endMaxDev = Long.MAX_VALUE;

    public DuringPredicate() {
        super(new Interval(1L, Long.MAX_VALUE));
        this.startMinDev = 1L;
        this.endMinDev = 1L;
    }

    public String toString() {
        return "during" + this.interval;
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long distStart = start1 - start2;
        long distEnd = end2 - end1;
        return distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev;
    }
}

