/*
 * Copyright (c) 2017 Kevin Herron
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.html.
 */

package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;

import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AuditEventType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class AuditEventNode extends BaseEventNode implements AuditEventType {
    public AuditEventNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName,
                          LocalizedText displayName, LocalizedText description, UInteger writeMask,
                          UInteger userWriteMask) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public AuditEventNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName,
                          LocalizedText displayName, LocalizedText description, UInteger writeMask,
                          UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    public PropertyNode getActionTimeStampNode() {
        Optional<VariableNode> propertyNode = getPropertyNode(AuditEventType.ACTION_TIME_STAMP);
        return (PropertyNode) propertyNode.orElse(null);
    }

    public DateTime getActionTimeStamp() {
        Optional<DateTime> propertyValue = getProperty(AuditEventType.ACTION_TIME_STAMP);
        return propertyValue.orElse(null);
    }

    public void setActionTimeStamp(DateTime value) {
        setProperty(AuditEventType.ACTION_TIME_STAMP, value);
    }

    public PropertyNode getStatusNode() {
        Optional<VariableNode> propertyNode = getPropertyNode(AuditEventType.STATUS);
        return (PropertyNode) propertyNode.orElse(null);
    }

    public Boolean getStatus() {
        Optional<Boolean> propertyValue = getProperty(AuditEventType.STATUS);
        return propertyValue.orElse(null);
    }

    public void setStatus(Boolean value) {
        setProperty(AuditEventType.STATUS, value);
    }

    public PropertyNode getServerIdNode() {
        Optional<VariableNode> propertyNode = getPropertyNode(AuditEventType.SERVER_ID);
        return (PropertyNode) propertyNode.orElse(null);
    }

    public String getServerId() {
        Optional<String> propertyValue = getProperty(AuditEventType.SERVER_ID);
        return propertyValue.orElse(null);
    }

    public void setServerId(String value) {
        setProperty(AuditEventType.SERVER_ID, value);
    }

    public PropertyNode getClientAuditEntryIdNode() {
        Optional<VariableNode> propertyNode = getPropertyNode(AuditEventType.CLIENT_AUDIT_ENTRY_ID);
        return (PropertyNode) propertyNode.orElse(null);
    }

    public String getClientAuditEntryId() {
        Optional<String> propertyValue = getProperty(AuditEventType.CLIENT_AUDIT_ENTRY_ID);
        return propertyValue.orElse(null);
    }

    public void setClientAuditEntryId(String value) {
        setProperty(AuditEventType.CLIENT_AUDIT_ENTRY_ID, value);
    }

    public PropertyNode getClientUserIdNode() {
        Optional<VariableNode> propertyNode = getPropertyNode(AuditEventType.CLIENT_USER_ID);
        return (PropertyNode) propertyNode.orElse(null);
    }

    public String getClientUserId() {
        Optional<String> propertyValue = getProperty(AuditEventType.CLIENT_USER_ID);
        return propertyValue.orElse(null);
    }

    public void setClientUserId(String value) {
        setProperty(AuditEventType.CLIENT_USER_ID, value);
    }
}
