/*
 * Copyright (c) 2017 Kevin Herron
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.html.
 */

package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class ObjectTypeManagerInitializer {
    public static void initialize(ObjectTypeManager manager) {
        manager.registerObjectType(
            NodeId.parse("ns=0;i=58"),
            BaseObjectNode.class,
            BaseObjectNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=61"),
            FolderNode.class,
            FolderNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=75"),
            DataTypeSystemNode.class,
            DataTypeSystemNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=76"),
            DataTypeEncodingNode.class,
            DataTypeEncodingNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=77"),
            ModellingRuleNode.class,
            ModellingRuleNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12522"),
            TrustListNode.class,
            TrustListNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12555"),
            CertificateGroupNode.class,
            CertificateGroupNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12556"),
            CertificateNode.class,
            CertificateNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12557"),
            ApplicationCertificateNode.class,
            ApplicationCertificateNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12558"),
            HttpsCertificateNode.class,
            HttpsCertificateNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12559"),
            RsaMinApplicationCertificateNode.class,
            RsaMinApplicationCertificateNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12560"),
            RsaSha256ApplicationCertificateNode.class,
            RsaSha256ApplicationCertificateNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12561"),
            TrustListUpdatedAuditEventNode.class,
            TrustListUpdatedAuditEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12581"),
            ServerConfigurationNode.class,
            ServerConfigurationNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=12620"),
            CertificateUpdatedAuditEventNode.class,
            CertificateUpdatedAuditEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=8927"),
            AuditConditionRespondEventNode.class,
            AuditConditionRespondEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=8944"),
            AuditConditionAcknowledgeEventNode.class,
            AuditConditionAcknowledgeEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=8961"),
            AuditConditionConfirmEventNode.class,
            AuditConditionConfirmEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=13225"),
            CertificateExpirationAlarmNode.class,
            CertificateExpirationAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=13353"),
            FileDirectoryNode.class,
            FileDirectoryNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=9318"),
            ExclusiveLimitStateMachineNode.class,
            ExclusiveLimitStateMachineNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=9341"),
            ExclusiveLimitAlarmNode.class,
            ExclusiveLimitAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=9482"),
            ExclusiveLevelAlarmNode.class,
            ExclusiveLevelAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=9623"),
            ExclusiveRateOfChangeAlarmNode.class,
            ExclusiveRateOfChangeAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=13813"),
            CertificateGroupFolderNode.class,
            CertificateGroupFolderNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=9764"),
            ExclusiveDeviationAlarmNode.class,
            ExclusiveDeviationAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=9906"),
            NonExclusiveLimitAlarmNode.class,
            NonExclusiveLimitAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=10060"),
            NonExclusiveLevelAlarmNode.class,
            NonExclusiveLevelAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2004"),
            ServerNode.class,
            ServerNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2013"),
            ServerCapabilitiesNode.class,
            ServerCapabilitiesNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2020"),
            ServerDiagnosticsNode.class,
            ServerDiagnosticsNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=10214"),
            NonExclusiveRateOfChangeAlarmNode.class,
            NonExclusiveRateOfChangeAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2026"),
            SessionsDiagnosticsSummaryNode.class,
            SessionsDiagnosticsSummaryNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2029"),
            SessionDiagnosticsObjectNode.class,
            SessionDiagnosticsObjectNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2033"),
            VendorServerInfoNode.class,
            VendorServerInfoNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2034"),
            ServerRedundancyNode.class,
            ServerRedundancyNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2036"),
            TransparentRedundancyNode.class,
            TransparentRedundancyNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2039"),
            NonTransparentRedundancyNode.class,
            NonTransparentRedundancyNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2041"),
            BaseEventNode.class,
            BaseEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2052"),
            AuditEventNode.class,
            AuditEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2058"),
            AuditSecurityEventNode.class,
            AuditSecurityEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2059"),
            AuditChannelEventNode.class,
            AuditChannelEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2060"),
            AuditOpenSecureChannelEventNode.class,
            AuditOpenSecureChannelEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2069"),
            AuditSessionEventNode.class,
            AuditSessionEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2071"),
            AuditCreateSessionEventNode.class,
            AuditCreateSessionEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2075"),
            AuditActivateSessionEventNode.class,
            AuditActivateSessionEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2078"),
            AuditCancelEventNode.class,
            AuditCancelEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2080"),
            AuditCertificateEventNode.class,
            AuditCertificateEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2082"),
            AuditCertificateDataMismatchEventNode.class,
            AuditCertificateDataMismatchEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2085"),
            AuditCertificateExpiredEventNode.class,
            AuditCertificateExpiredEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2086"),
            AuditCertificateInvalidEventNode.class,
            AuditCertificateInvalidEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2087"),
            AuditCertificateUntrustedEventNode.class,
            AuditCertificateUntrustedEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2088"),
            AuditCertificateRevokedEventNode.class,
            AuditCertificateRevokedEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2089"),
            AuditCertificateMismatchEventNode.class,
            AuditCertificateMismatchEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2090"),
            AuditNodeManagementEventNode.class,
            AuditNodeManagementEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2091"),
            AuditAddNodesEventNode.class,
            AuditAddNodesEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2093"),
            AuditDeleteNodesEventNode.class,
            AuditDeleteNodesEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2095"),
            AuditAddReferencesEventNode.class,
            AuditAddReferencesEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2097"),
            AuditDeleteReferencesEventNode.class,
            AuditDeleteReferencesEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2099"),
            AuditUpdateEventNode.class,
            AuditUpdateEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2100"),
            AuditWriteUpdateEventNode.class,
            AuditWriteUpdateEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2104"),
            AuditHistoryUpdateEventNode.class,
            AuditHistoryUpdateEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2127"),
            AuditUpdateMethodEventNode.class,
            AuditUpdateMethodEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2130"),
            SystemEventNode.class,
            SystemEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2131"),
            DeviceFailureEventNode.class,
            DeviceFailureEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2132"),
            BaseModelChangeEventNode.class,
            BaseModelChangeEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2133"),
            GeneralModelChangeEventNode.class,
            GeneralModelChangeEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=10368"),
            NonExclusiveDeviationAlarmNode.class,
            NonExclusiveDeviationAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2299"),
            StateMachineNode.class,
            StateMachineNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2307"),
            StateNode.class,
            StateNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2309"),
            InitialStateNode.class,
            InitialStateNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2310"),
            TransitionNode.class,
            TransitionNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2311"),
            TransitionEventNode.class,
            TransitionEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2315"),
            AuditUpdateStateEventNode.class,
            AuditUpdateStateEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2318"),
            HistoricalDataConfigurationNode.class,
            HistoricalDataConfigurationNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2330"),
            HistoryServerCapabilitiesNode.class,
            HistoryServerCapabilitiesNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=10523"),
            DiscreteAlarmNode.class,
            DiscreteAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2340"),
            AggregateFunctionNode.class,
            AggregateFunctionNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2378"),
            ProgramTransitionEventNode.class,
            ProgramTransitionEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2391"),
            ProgramStateMachineNode.class,
            ProgramStateMachineNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=10637"),
            OffNormalAlarmNode.class,
            OffNormalAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=10751"),
            TripAlarmNode.class,
            TripAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2738"),
            SemanticChangeEventNode.class,
            SemanticChangeEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2748"),
            AuditUrlMismatchEventNode.class,
            AuditUrlMismatchEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2771"),
            FiniteStateMachineNode.class,
            FiniteStateMachineNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2782"),
            ConditionNode.class,
            ConditionNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2787"),
            RefreshStartEventNode.class,
            RefreshStartEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2788"),
            RefreshEndEventNode.class,
            RefreshEndEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2789"),
            RefreshRequiredEventNode.class,
            RefreshRequiredEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2790"),
            AuditConditionEventNode.class,
            AuditConditionEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2803"),
            AuditConditionEnableEventNode.class,
            AuditConditionEnableEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2829"),
            AuditConditionCommentEventNode.class,
            AuditConditionCommentEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2830"),
            DialogConditionNode.class,
            DialogConditionNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2881"),
            AcknowledgeableConditionNode.class,
            AcknowledgeableConditionNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11093"),
            AuditConditionShelvingEventNode.class,
            AuditConditionShelvingEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2915"),
            AlarmConditionNode.class,
            AlarmConditionNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2929"),
            ShelvedStateMachineNode.class,
            ShelvedStateMachineNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2955"),
            LimitAlarmNode.class,
            LimitAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11163"),
            BaseConditionClassNode.class,
            BaseConditionClassNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11164"),
            ProcessConditionClassNode.class,
            ProcessConditionClassNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11165"),
            MaintenanceConditionClassNode.class,
            MaintenanceConditionClassNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11166"),
            SystemConditionClassNode.class,
            SystemConditionClassNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11187"),
            AggregateConfigurationNode.class,
            AggregateConfigurationNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=2999"),
            AuditHistoryEventUpdateEventNode.class,
            AuditHistoryEventUpdateEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=3006"),
            AuditHistoryValueUpdateEventNode.class,
            AuditHistoryValueUpdateEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=3012"),
            AuditHistoryDeleteEventNode.class,
            AuditHistoryDeleteEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=3014"),
            AuditHistoryRawModifyDeleteEventNode.class,
            AuditHistoryRawModifyDeleteEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=3019"),
            AuditHistoryAtTimeDeleteEventNode.class,
            AuditHistoryAtTimeDeleteEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=3022"),
            AuditHistoryEventDeleteEventNode.class,
            AuditHistoryEventDeleteEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=3035"),
            EventQueueOverflowEventNode.class,
            EventQueueOverflowEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11436"),
            ProgressEventNode.class,
            ProgressEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11446"),
            SystemStatusChangeEventNode.class,
            SystemStatusChangeEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11564"),
            OperationLimitsNode.class,
            OperationLimitsNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11575"),
            FileNode.class,
            FileNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11595"),
            AddressSpaceFileNode.class,
            AddressSpaceFileNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11616"),
            NamespaceMetadataNode.class,
            NamespaceMetadataNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11645"),
            NamespacesNode.class,
            NamespacesNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11753"),
            SystemOffNormalAlarmNode.class,
            SystemOffNormalAlarmNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11856"),
            AuditProgramTransitionEventNode.class,
            AuditProgramTransitionEventNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=11945"),
            NonTransparentNetworkRedundancyNode.class,
            NonTransparentNetworkRedundancyNode::new
        );
        manager.registerObjectType(
            NodeId.parse("ns=0;i=3806"),
            ProgramTransitionAuditEventNode.class,
            ProgramTransitionAuditEventNode::new
        );
    }
}
