/*
 * Copyright (c) 2017 Kevin Herron
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.html.
 */

package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class VariableTypeManagerInitializer {
    public static void initialize(VariableTypeManager manager) {
        manager.registerVariableType(
            NodeId.parse("ns=0;i=62"),
            BaseVariableNode.class,
            BaseVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=63"),
            BaseDataVariableNode.class,
            BaseDataVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=68"),
            PropertyNode.class,
            PropertyNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=69"),
            DataTypeDescriptionNode.class,
            DataTypeDescriptionNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=72"),
            DataTypeDictionaryNode.class,
            DataTypeDictionaryNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=8995"),
            TwoStateVariableNode.class,
            TwoStateVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=9002"),
            ConditionVariableNode.class,
            ConditionVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2137"),
            ServerVendorCapabilityNode.class,
            ServerVendorCapabilityNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2138"),
            ServerStatusNode.class,
            ServerStatusNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2150"),
            ServerDiagnosticsSummaryNode.class,
            ServerDiagnosticsSummaryNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2164"),
            SamplingIntervalDiagnosticsArrayNode.class,
            SamplingIntervalDiagnosticsArrayNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2165"),
            SamplingIntervalDiagnosticsNode.class,
            SamplingIntervalDiagnosticsNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2171"),
            SubscriptionDiagnosticsArrayNode.class,
            SubscriptionDiagnosticsArrayNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2172"),
            SubscriptionDiagnosticsNode.class,
            SubscriptionDiagnosticsNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2196"),
            SessionDiagnosticsArrayNode.class,
            SessionDiagnosticsArrayNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2197"),
            SessionDiagnosticsVariableNode.class,
            SessionDiagnosticsVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2243"),
            SessionSecurityDiagnosticsArrayNode.class,
            SessionSecurityDiagnosticsArrayNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2244"),
            SessionSecurityDiagnosticsNode.class,
            SessionSecurityDiagnosticsNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2365"),
            DataItemNode.class,
            DataItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2368"),
            AnalogItemNode.class,
            AnalogItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2372"),
            DiscreteItemNode.class,
            DiscreteItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2373"),
            TwoStateDiscreteNode.class,
            TwoStateDiscreteNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2376"),
            MultiStateDiscreteNode.class,
            MultiStateDiscreteNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2380"),
            ProgramDiagnosticNode.class,
            ProgramDiagnosticNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2755"),
            StateVariableNode.class,
            StateVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2760"),
            FiniteStateVariableNode.class,
            FiniteStateVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2762"),
            TransitionVariableNode.class,
            TransitionVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=2767"),
            FiniteTransitionVariableNode.class,
            FiniteTransitionVariableNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=11238"),
            MultiStateValueDiscreteNode.class,
            MultiStateValueDiscreteNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=3051"),
            BuildInfoNode.class,
            BuildInfoNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=11487"),
            OptionSetNode.class,
            OptionSetNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=12021"),
            ArrayItemNode.class,
            ArrayItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=12029"),
            YArrayItemNode.class,
            YArrayItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=12038"),
            XYArrayItemNode.class,
            XYArrayItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=12047"),
            ImageItemNode.class,
            ImageItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=12057"),
            CubeItemNode.class,
            CubeItemNode::new
        );
        manager.registerVariableType(
            NodeId.parse("ns=0;i=12068"),
            NDimensionArrayItemNode.class,
            NDimensionArrayItemNode::new
        );
    }
}
