/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.FolderNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.OperationLimitsNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ServerCapabilitiesType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;

public class ServerCapabilitiesNode
extends BaseObjectNode
implements ServerCapabilitiesType {
    public ServerCapabilitiesNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public ServerCapabilitiesNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyNode getServerProfileArrayNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.SERVER_PROFILE_ARRAY);
        return propertyNode.orElse(null);
    }

    @Override
    public String[] getServerProfileArray() {
        Optional<String[]> propertyValue = this.getProperty(ServerCapabilitiesType.SERVER_PROFILE_ARRAY);
        return propertyValue.orElse(null);
    }

    @Override
    public void setServerProfileArray(String[] value) {
        this.setProperty(ServerCapabilitiesType.SERVER_PROFILE_ARRAY, value);
    }

    @Override
    public PropertyNode getLocaleIdArrayNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.LOCALE_ID_ARRAY);
        return propertyNode.orElse(null);
    }

    @Override
    public String[] getLocaleIdArray() {
        Optional<String[]> propertyValue = this.getProperty(ServerCapabilitiesType.LOCALE_ID_ARRAY);
        return propertyValue.orElse(null);
    }

    @Override
    public void setLocaleIdArray(String[] value) {
        this.setProperty(ServerCapabilitiesType.LOCALE_ID_ARRAY, value);
    }

    @Override
    public PropertyNode getMinSupportedSampleRateNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.MIN_SUPPORTED_SAMPLE_RATE);
        return propertyNode.orElse(null);
    }

    @Override
    public Double getMinSupportedSampleRate() {
        Optional<Double> propertyValue = this.getProperty(ServerCapabilitiesType.MIN_SUPPORTED_SAMPLE_RATE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMinSupportedSampleRate(Double value) {
        this.setProperty(ServerCapabilitiesType.MIN_SUPPORTED_SAMPLE_RATE, value);
    }

    @Override
    public PropertyNode getMaxBrowseContinuationPointsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.MAX_BROWSE_CONTINUATION_POINTS);
        return propertyNode.orElse(null);
    }

    @Override
    public UShort getMaxBrowseContinuationPoints() {
        Optional<UShort> propertyValue = this.getProperty(ServerCapabilitiesType.MAX_BROWSE_CONTINUATION_POINTS);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxBrowseContinuationPoints(UShort value) {
        this.setProperty(ServerCapabilitiesType.MAX_BROWSE_CONTINUATION_POINTS, value);
    }

    @Override
    public PropertyNode getMaxQueryContinuationPointsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.MAX_QUERY_CONTINUATION_POINTS);
        return propertyNode.orElse(null);
    }

    @Override
    public UShort getMaxQueryContinuationPoints() {
        Optional<UShort> propertyValue = this.getProperty(ServerCapabilitiesType.MAX_QUERY_CONTINUATION_POINTS);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxQueryContinuationPoints(UShort value) {
        this.setProperty(ServerCapabilitiesType.MAX_QUERY_CONTINUATION_POINTS, value);
    }

    @Override
    public PropertyNode getMaxHistoryContinuationPointsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.MAX_HISTORY_CONTINUATION_POINTS);
        return propertyNode.orElse(null);
    }

    @Override
    public UShort getMaxHistoryContinuationPoints() {
        Optional<UShort> propertyValue = this.getProperty(ServerCapabilitiesType.MAX_HISTORY_CONTINUATION_POINTS);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxHistoryContinuationPoints(UShort value) {
        this.setProperty(ServerCapabilitiesType.MAX_HISTORY_CONTINUATION_POINTS, value);
    }

    @Override
    public PropertyNode getSoftwareCertificatesNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.SOFTWARE_CERTIFICATES);
        return propertyNode.orElse(null);
    }

    @Override
    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        Optional<SignedSoftwareCertificate[]> propertyValue = this.getProperty(ServerCapabilitiesType.SOFTWARE_CERTIFICATES);
        return propertyValue.orElse(null);
    }

    @Override
    public void setSoftwareCertificates(SignedSoftwareCertificate[] value) {
        this.setProperty(ServerCapabilitiesType.SOFTWARE_CERTIFICATES, value);
    }

    @Override
    public PropertyNode getMaxArrayLengthNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.MAX_ARRAY_LENGTH);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxArrayLength() {
        Optional<UInteger> propertyValue = this.getProperty(ServerCapabilitiesType.MAX_ARRAY_LENGTH);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxArrayLength(UInteger value) {
        this.setProperty(ServerCapabilitiesType.MAX_ARRAY_LENGTH, value);
    }

    @Override
    public PropertyNode getMaxStringLengthNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.MAX_STRING_LENGTH);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxStringLength() {
        Optional<UInteger> propertyValue = this.getProperty(ServerCapabilitiesType.MAX_STRING_LENGTH);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxStringLength(UInteger value) {
        this.setProperty(ServerCapabilitiesType.MAX_STRING_LENGTH, value);
    }

    @Override
    public PropertyNode getMaxByteStringLengthNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerCapabilitiesType.MAX_BYTE_STRING_LENGTH);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxByteStringLength() {
        Optional<UInteger> propertyValue = this.getProperty(ServerCapabilitiesType.MAX_BYTE_STRING_LENGTH);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxByteStringLength(UInteger value) {
        this.setProperty(ServerCapabilitiesType.MAX_BYTE_STRING_LENGTH, value);
    }

    @Override
    public OperationLimitsNode getOperationLimitsNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "OperationLimits");
        return component.map(node -> (OperationLimitsNode)node).orElse(null);
    }

    @Override
    public FolderNode getModellingRulesNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ModellingRules");
        return component.map(node -> (FolderNode)node).orElse(null);
    }

    @Override
    public FolderNode getAggregateFunctionsNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "AggregateFunctions");
        return component.map(node -> (FolderNode)node).orElse(null);
    }
}

