/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.ee;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.ee.shared.SystemCapability;
import org.eclipse.tycho.p2.target.ee.CustomEEResolutionHints;
import org.eclipse.tycho.p2.target.ee.ExecutionEnvironmentResolutionHandler;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;

class CustomEEResolutionHandler
extends ExecutionEnvironmentResolutionHandler {
    private ExecutionEnvironmentConfiguration eeConfiguration;

    public CustomEEResolutionHandler(ExecutionEnvironmentConfiguration eeConfiguration) {
        super(new CustomEEResolutionHints(eeConfiguration.getProfileName()));
        this.eeConfiguration = eeConfiguration;
    }

    @Override
    public void readFullSpecification(Collection<IInstallableUnit> targetPlatformContent) {
        IInstallableUnit specificationUnit = this.findSpecificationUnit(targetPlatformContent, this.getResolutionHints());
        List<SystemCapability> systemCapabilities = this.readCapabilities(specificationUnit);
        this.eeConfiguration.setFullSpecificationForCustomProfile(systemCapabilities);
    }

    private IInstallableUnit findSpecificationUnit(Collection<IInstallableUnit> targetPlatformContent, ExecutionEnvironmentResolutionHints profileUnitFilter) {
        for (IInstallableUnit unit : targetPlatformContent) {
            if (!profileUnitFilter.isEESpecificationUnit(unit)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Could not find specification for custom execution environment profile '" + this.eeConfiguration.getProfileName() + "' in the target platform");
    }

    private List<SystemCapability> readCapabilities(IInstallableUnit specificationUnit) {
        ArrayList<SystemCapability> result = new ArrayList<SystemCapability>();
        for (IProvidedCapability capability : specificationUnit.getProvidedCapabilities()) {
            String namespace = capability.getNamespace();
            String name = capability.getName();
            String version = capability.getVersion().toString();
            if ("osgi.ee".equals(namespace)) {
                result.add(new SystemCapability(SystemCapability.Type.OSGI_EE, name, version));
                continue;
            }
            if (!"java.package".equals(namespace)) continue;
            result.add(new SystemCapability(SystemCapability.Type.JAVA_PACKAGE, name, version));
        }
        return result;
    }
}

