/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.OptionalDouble;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;

public class OptionalDoubleTypeDeserializer
extends AbstractValueTypeDeserializer<OptionalDouble> {
    public OptionalDoubleTypeDeserializer(JsonBindingModel model) {
        super(OptionalDouble.class, model);
    }

    @Override
    public OptionalDouble deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonParser.Event next = ((JsonbParser)parser).moveToValue();
        if (next == JsonParser.Event.VALUE_NULL) {
            return OptionalDouble.empty();
        }
        String value = parser.getString();
        return this.deserialize(value, (Unmarshaller)ctx, rtType);
    }

    @Override
    protected OptionalDouble deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        try {
            return OptionalDouble.of(Double.parseDouble(jsonValue));
        }
        catch (NumberFormatException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, OptionalDouble.class));
        }
    }
}

