/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class CopyingXContentParser
extends FilterXContentParserWrapper {
    private final XContentBuilder builder;

    public CopyingXContentParser(XContentParser delegate) throws IOException {
        super(delegate);
        this.builder = XContentBuilder.builder(delegate.contentType().xContent());
        switch (delegate.currentToken()) {
            case START_OBJECT: {
                this.builder.startObject();
                break;
            }
            case START_ARRAY: {
                this.builder.startArray();
                break;
            }
            default: {
                throw new IllegalArgumentException("can only copy parsers pointed to START_OBJECT or START_ARRAY but found: " + delegate.currentToken());
            }
        }
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        XContentParser.Token next = this.delegate().nextToken();
        this.builder.copyCurrentEvent(this.delegate());
        return next;
    }

    public XContentBuilder getBuilder() {
        return this.builder;
    }
}

