/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import org.elasticsearch.transport.netty4.Netty4OpenChannelsHandler;
import org.elasticsearch.transport.netty4.Netty4SizeHeaderFrameDecoder;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4Transport
extends TcpTransport<Channel> {
    public static final Setting<Integer> WORKER_COUNT;
    public static final Setting<ByteSizeValue> NETTY_MAX_CUMULATION_BUFFER_CAPACITY;
    public static final Setting<Integer> NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX;
    public static final Setting<Integer> NETTY_BOSS_COUNT;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected final RecvByteBufAllocator recvByteBufAllocator;
    protected final int workerCount;
    protected final ByteSizeValue receivePredictorMin;
    protected final ByteSizeValue receivePredictorMax;
    volatile Netty4OpenChannelsHandler serverOpenChannels;
    protected volatile Bootstrap bootstrap;
    protected final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();

    public Netty4Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("netty", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        this.workerCount = (Integer)WORKER_COUNT.get(settings);
        this.maxCumulationBufferCapacity = (ByteSizeValue)NETTY_MAX_CUMULATION_BUFFER_CAPACITY.get(settings);
        this.maxCompositeBufferComponents = (Integer)NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.receivePredictorMin = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    TransportServiceAdapter transportServiceAdapter() {
        return this.transportServiceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            this.bootstrap = this.createBootstrap();
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                Netty4OpenChannelsHandler openChannels;
                this.serverOpenChannels = openChannels = new Netty4OpenChannelsHandler(this.logger);
                for (Map.Entry entry : this.buildProfileSettings().entrySet()) {
                    Settings settings = Settings.builder().put(this.createFallbackSettings()).put((Settings)entry.getValue()).build();
                    this.createServerBootstrap((String)entry.getKey(), settings);
                    this.bindServer((String)entry.getKey(), settings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        if (((Boolean)TCP_BLOCKING_CLIENT.get(this.settings)).booleanValue()) {
            bootstrap.group((EventLoopGroup)new OioEventLoopGroup(1, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_worker")));
            bootstrap.channel(OioSocketChannel.class);
        } else {
            bootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_boss")));
            bootstrap.channel(NioSocketChannel.class);
        }
        bootstrap.handler(this.getClientChannelInitializer());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(this.defaultConnectionProfile.getConnectTimeout().millis()));
        bootstrap.option(ChannelOption.TCP_NODELAY, TCP_NO_DELAY.get(this.settings));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, TCP_KEEP_ALIVE.get(this.settings));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        bootstrap.validate();
        return bootstrap;
    }

    private Settings createFallbackSettings() {
        ByteSizeValue fallbackTcpBufferSize;
        List fallbackPublishHost;
        Settings.Builder fallbackSettingsBuilder = Settings.builder();
        List fallbackBindHost = (List)TransportSettings.BIND_HOST.get(this.settings);
        if (!fallbackBindHost.isEmpty()) {
            fallbackSettingsBuilder.putArray("bind_host", fallbackBindHost);
        }
        if (!(fallbackPublishHost = (List)TransportSettings.PUBLISH_HOST.get(this.settings)).isEmpty()) {
            fallbackSettingsBuilder.putArray("publish_host", fallbackPublishHost);
        }
        boolean fallbackTcpNoDelay = this.settings.getAsBoolean("transport.netty.tcp_no_delay", (Boolean)NetworkService.TcpSettings.TCP_NO_DELAY.get(this.settings));
        fallbackSettingsBuilder.put("tcp_no_delay", fallbackTcpNoDelay);
        boolean fallbackTcpKeepAlive = this.settings.getAsBoolean("transport.netty.tcp_keep_alive", (Boolean)NetworkService.TcpSettings.TCP_KEEP_ALIVE.get(this.settings));
        fallbackSettingsBuilder.put("tcp_keep_alive", fallbackTcpKeepAlive);
        boolean fallbackReuseAddress = this.settings.getAsBoolean("transport.netty.reuse_address", (Boolean)NetworkService.TcpSettings.TCP_REUSE_ADDRESS.get(this.settings));
        fallbackSettingsBuilder.put("reuse_address", fallbackReuseAddress);
        ByteSizeValue fallbackTcpSendBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_send_buffer_size", (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings));
        if (fallbackTcpSendBufferSize.getBytes() >= 0L) {
            fallbackSettingsBuilder.put(new Object[]{"tcp_send_buffer_size", fallbackTcpSendBufferSize});
        }
        if ((fallbackTcpBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_receive_buffer_size", (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings))).getBytes() >= 0L) {
            fallbackSettingsBuilder.put(new Object[]{"tcp_receive_buffer_size", fallbackTcpBufferSize});
        }
        return fallbackSettingsBuilder.build();
    }

    private void createServerBootstrap(String name, Settings settings) {
        ByteSizeValue tcpReceiveBufferSize;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", new Object[]{name, this.workerCount, settings.get("port"), settings.get("bind_host"), settings.get("publish_host"), this.compress, this.defaultConnectionProfile.getConnectTimeout(), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.RECOVERY), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.BULK), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.REG), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.STATE), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.PING), this.receivePredictorMin, this.receivePredictorMax});
        }
        ThreadFactory workerFactory = EsExecutors.daemonThreadFactory((Settings)this.settings, (String[])new String[]{"transport_server_worker", name});
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        if (((Boolean)TCP_BLOCKING_SERVER.get(settings)).booleanValue()) {
            serverBootstrap.group((EventLoopGroup)new OioEventLoopGroup(this.workerCount, workerFactory));
            serverBootstrap.channel(OioServerSocketChannel.class);
        } else {
            serverBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, workerFactory));
            serverBootstrap.channel(NioServerSocketChannel.class);
        }
        serverBootstrap.childHandler(this.getServerChannelInitializer(name, settings));
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, TCP_NO_DELAY.get(settings));
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, TCP_KEEP_ALIVE.get(settings));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.getDefault(settings);
        if (tcpSendBufferSize != null && tcpSendBufferSize.getBytes() > 0L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.getDefault(settings)) != null && tcpReceiveBufferSize.getBytes() > 0L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TCP_REUSE_ADDRESS.get(settings);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name, Settings settings) {
        return new ServerChannelInitializer(name, settings);
    }

    protected ChannelHandler getClientChannelInitializer() {
        return new ClientChannelInitializer();
    }

    protected final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable unwrapped = ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{ElasticsearchException.class});
        Throwable t = unwrapped != null ? unwrapped : cause;
        this.onException(ctx.channel(), t instanceof Exception ? (Exception)t : new ElasticsearchException(t));
    }

    public long serverOpen() {
        Netty4OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TcpTransport.NodeChannels connectToChannels(DiscoveryNode node, ConnectionProfile profile) {
        Object[] channels = new Channel[profile.getNumConnections()];
        TcpTransport.NodeChannels nodeChannels = new TcpTransport.NodeChannels((TcpTransport)this, node, channels, profile);
        boolean success = false;
        try {
            TimeValue connectTimeout;
            Bootstrap bootstrap;
            TimeValue defaultConnectTimeout = this.defaultConnectionProfile.getConnectTimeout();
            if (profile.getConnectTimeout() != null && !profile.getConnectTimeout().equals((Object)defaultConnectTimeout)) {
                bootstrap = this.bootstrap.clone(this.bootstrap.config().group());
                bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(profile.getConnectTimeout().millis()));
                connectTimeout = profile.getConnectTimeout();
            } else {
                connectTimeout = defaultConnectTimeout;
                bootstrap = this.bootstrap;
            }
            ArrayList<ChannelFuture> connections = new ArrayList<ChannelFuture>(channels.length);
            InetSocketAddress address = ((InetSocketTransportAddress)node.getAddress()).address();
            for (int i = 0; i < channels.length; ++i) {
                connections.add(bootstrap.connect((SocketAddress)address));
            }
            Iterator iterator = connections.iterator();
            try {
                for (int i = 0; i < channels.length; ++i) {
                    assert (iterator.hasNext());
                    ChannelFuture future = (ChannelFuture)iterator.next();
                    future.awaitUninterruptibly((long)((double)connectTimeout.millis() * 1.5));
                    if (!future.isSuccess()) {
                        throw new ConnectTransportException(node, "connect_timeout[" + connectTimeout + "]", future.cause());
                    }
                    channels[i] = future.channel();
                    channels[i].closeFuture().addListener((GenericFutureListener)new ChannelCloseListener(node));
                }
                assert (!iterator.hasNext()) : "not all created connection have been consumed";
            }
            catch (RuntimeException e) {
                for (ChannelFuture future : Collections.unmodifiableList(connections)) {
                    FutureUtils.cancel((java.util.concurrent.Future)future);
                    if (future.channel() == null || !future.channel().isOpen()) continue;
                    try {
                        future.channel().close();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                }
                throw e;
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    nodeChannels.close();
                }
                catch (IOException e) {
                    this.logger.trace("exception while closing channels", (Throwable)e);
                }
            }
        }
        return nodeChannels;
    }

    protected void sendMessage(Channel channel, BytesReference reference, Runnable sendListener) {
        ChannelFuture future = channel.writeAndFlush((Object)Netty4Utils.toByteBuf(reference));
        future.addListener(f -> sendListener.run());
    }

    protected void closeChannels(List<Channel> channels) throws IOException {
        Netty4Utils.closeChannels(channels);
    }

    protected InetSocketAddress getLocalAddress(Channel channel) {
        return (InetSocketAddress)channel.localAddress();
    }

    protected Channel bind(String name, InetSocketAddress address) {
        return this.serverBootstraps.get(name).bind((SocketAddress)address).syncUninterruptibly().channel();
    }

    TcpTransport.ScheduledPing getPing() {
        return this.scheduledPing;
    }

    protected boolean isOpen(Channel channel) {
        return channel.isOpen();
    }

    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasables.close((Releasable[])new Releasable[]{this.serverOpenChannels, () -> {
            ArrayList<Tuple> serverBootstrapCloseFutures = new ArrayList<Tuple>(this.serverBootstraps.size());
            for (Map.Entry<String, ServerBootstrap> entry : this.serverBootstraps.entrySet()) {
                serverBootstrapCloseFutures.add(Tuple.tuple((Object)entry.getKey(), (Object)entry.getValue().config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS)));
            }
            for (Tuple future : serverBootstrapCloseFutures) {
                ((Future)future.v2()).awaitUninterruptibly();
                if (((Future)future.v2()).isSuccess()) continue;
                this.logger.debug(() -> new ParameterizedMessage("Error closing server bootstrap for profile [{}]", future.v1()), ((Future)future.v2()).cause());
            }
            this.serverBootstraps.clear();
            if (this.bootstrap != null) {
                this.bootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
                this.bootstrap = null;
            }
        }});
    }

    static {
        Netty4Utils.setup();
        WORKER_COUNT = new Setting("transport.netty.worker_count", s -> Integer.toString(EsExecutors.boundedNumberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"transport.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_MAX_CUMULATION_BUFFER_CAPACITY = Setting.byteSizeSetting((String)"transport.netty.max_cumulation_buffer_capacity", (ByteSizeValue)new ByteSizeValue(-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = Setting.intSetting((String)"transport.netty.max_composite_buffer_components", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", (ByteSizeValue)new ByteSizeValue(64L, ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_BOSS_COUNT = Setting.intSetting((String)"transport.netty.boss_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;
        protected final Settings settings;

        protected ServerChannelInitializer(String name, Settings settings) {
            this.name = name;
            this.settings = settings;
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("open_channels", (ChannelHandler)Netty4Transport.this.serverOpenChannels);
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, this.name));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Netty4Utils.maybeDie(cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, ".client"));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Netty4Utils.maybeDie(cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    private class ChannelCloseListener
    implements ChannelFutureListener {
        private final DiscoveryNode node;

        private ChannelCloseListener(DiscoveryNode node) {
            this.node = node;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            Netty4Transport.this.onChannelClosed(future.channel());
            TcpTransport.NodeChannels nodeChannels = (TcpTransport.NodeChannels)Netty4Transport.this.connectedNodes.get(this.node);
            if (nodeChannels != null && nodeChannels.hasChannel((Object)future.channel())) {
                Netty4Transport.this.threadPool.generic().execute(() -> Netty4Transport.this.disconnectFromNode(this.node, future.channel(), "channel closed event"));
            }
        }
    }
}

