/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.tasks.Task;

public class ActionTestUtils {
    private ActionTestUtils() {
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> Response executeBlocking(TransportAction<Request, Response> action, Request request) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        action.execute(request, (ActionListener)future);
        return (Response)((ActionResponse)future.actionGet());
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void execute(TransportAction<Request, Response> action, Task task, Request request, ActionListener<Response> listener) {
        action.execute(task, request, listener);
    }

    public static <T> ActionListener<T> assertNoFailureListener(CheckedConsumer<T, Exception> consumer) {
        return ActionListener.wrap(consumer, e -> {
            throw new AssertionError(e);
        });
    }
}

