/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.test.ESTestCase;

public final class DataStreamTestHelper {
    private static final Settings.Builder SETTINGS = ESTestCase.settings(Version.CURRENT).put("index.hidden", true);
    private static final int NUMBER_OF_SHARDS = 1;
    private static final int NUMBER_OF_REPLICAS = 1;

    public static IndexMetadata.Builder createFirstBackingIndex(String dataStreamName) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, 1, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createFirstBackingIndex(String dataStreamName, long epochMillis) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, 1, epochMillis);
    }

    public static IndexMetadata.Builder createBackingIndex(String dataStreamName, int generation) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, generation, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createBackingIndex(String dataStreamName, int generation, long epochMillis) {
        return IndexMetadata.builder((String)DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation, (long)epochMillis)).settings(SETTINGS).numberOfShards(1).numberOfReplicas(1);
    }

    public static IndexMetadata.Builder getIndexMetadataBuilderForIndex(Index index) {
        return IndexMetadata.builder((String)index.getName()).settings(Settings.builder().put(SETTINGS.build()).put("index.uuid", index.getUUID())).numberOfShards(1).numberOfReplicas(1);
    }

    public static DataStream.TimestampField createTimestampField(String fieldName) {
        return new DataStream.TimestampField(fieldName);
    }

    public static String generateMapping(String timestampFieldName) {
        return "{\n      \"properties\": {\n        \"" + timestampFieldName + "\": {\n          \"type\": \"date\"\n        }\n      }\n    }";
    }

    public static String generateMapping(String timestampFieldName, String type) {
        return "{\n      \"_data_stream_timestamp\": {\n        \"enabled\": true\n      },      \"properties\": {\n        \"" + timestampFieldName + "\": {\n          \"type\": \"" + type + "\"\n        }\n      }\n    }";
    }

    public static List<Index> randomIndexInstances() {
        int numIndices = ESTestCase.randomIntBetween(0, 128);
        ArrayList<Index> indices = new ArrayList<Index>(numIndices);
        for (int i = 0; i < numIndices; ++i) {
            indices.add(new Index(ESTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        }
        return indices;
    }

    public static DataStream randomInstance() {
        List<Index> indices = DataStreamTestHelper.randomIndexInstances();
        long generation = (long)indices.size() + ESTestCase.randomLongBetween(1L, 128L);
        String dataStreamName = ESTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT);
        indices.add(new Index(DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        HashMap<String, String> metadata = null;
        if (ESTestCase.randomBoolean()) {
            metadata = new HashMap<String, String>();
            metadata.put("key", "value");
        }
        return new DataStream(dataStreamName, DataStreamTestHelper.createTimestampField("@timestamp"), indices, generation, metadata, ESTestCase.randomBoolean(), ESTestCase.randomBoolean());
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames) {
        return DataStreamTestHelper.getClusterStateWithDataStreams(dataStreams, indexNames, 1);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames, int replicas) {
        Metadata.Builder builder = Metadata.builder();
        ArrayList allIndices = new ArrayList();
        for (Tuple<String, Integer> dsTuple : dataStreams) {
            ArrayList<IndexMetadata> backingIndices = new ArrayList<IndexMetadata>();
            for (int backingIndexNumber = 1; backingIndexNumber <= (Integer)dsTuple.v2(); ++backingIndexNumber) {
                backingIndices.add(DataStreamTestHelper.createIndexMetadata(DataStream.getDefaultBackingIndexName((String)((String)dsTuple.v1()), (long)backingIndexNumber), true, replicas));
            }
            allIndices.addAll(backingIndices);
            DataStream ds = new DataStream((String)dsTuple.v1(), DataStreamTestHelper.createTimestampField("@timestamp"), backingIndices.stream().map(IndexMetadata::getIndex).collect(Collectors.toList()), (long)((Integer)dsTuple.v2()).intValue(), null);
            builder.put(ds);
        }
        for (String indexName : indexNames) {
            allIndices.add(DataStreamTestHelper.createIndexMetadata(indexName, false, replicas));
        }
        for (IndexMetadata index : allIndices) {
            builder.put(index, false);
        }
        return ClusterState.builder((ClusterName)new ClusterName("_name")).metadata(builder).build();
    }

    private static IndexMetadata createIndexMetadata(String name, boolean hidden, int replicas) {
        Settings.Builder b = Settings.builder().put("index.version.created", Version.CURRENT).put("index.hidden", hidden);
        return IndexMetadata.builder((String)name).settings(b).numberOfShards(1).numberOfReplicas(replicas).build();
    }

    public static String backingIndexPattern(String dataStreamName, long generation) {
        return String.format(Locale.ROOT, "\\.ds-%s-(\\d{4}\\.\\d{2}\\.\\d{2}-)?%06d", dataStreamName, generation);
    }
}

