/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.mockfile.FilterFileStore;
import org.apache.lucene.mockfile.FilterFileSystemProvider;
import org.apache.lucene.mockfile.FilterPath;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.io.PathUtilsForTesting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.fs.FsService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.InternalSettingsPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class DiskUsageIntegTestCase
extends ESIntegTestCase {
    protected static TestFileSystemProvider fileSystemProvider;
    private FileSystem defaultFileSystem;

    @Before
    public void installFilesystemProvider() {
        DiskUsageIntegTestCase.assertNull((Object)this.defaultFileSystem);
        this.defaultFileSystem = PathUtils.getDefaultFileSystem();
        DiskUsageIntegTestCase.assertNull((Object)((Object)fileSystemProvider));
        fileSystemProvider = new TestFileSystemProvider(this.defaultFileSystem, DiskUsageIntegTestCase.createTempDir());
        PathUtilsForTesting.installMock(fileSystemProvider.getFileSystem(null));
    }

    @After
    public void removeFilesystemProvider() {
        fileSystemProvider = null;
        DiskUsageIntegTestCase.assertNotNull((Object)this.defaultFileSystem);
        PathUtilsForTesting.installMock(this.defaultFileSystem);
        this.defaultFileSystem = null;
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return List.of(InternalSettingsPlugin.class);
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal) {
        Path dataPath = fileSystemProvider.getRootDir().resolve("node-" + nodeOrdinal);
        try {
            Files.createDirectories(dataPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssertionError("unexpected", e);
        }
        fileSystemProvider.addTrackedPath(dataPath);
        return Settings.builder().put(super.nodeSettings(nodeOrdinal)).put(Environment.PATH_DATA_SETTING.getKey(), dataPath).put(FsService.ALWAYS_REFRESH_SETTING.getKey(), true).build();
    }

    public TestFileStore getTestFileStore(String nodeName) {
        return fileSystemProvider.getTestFileStore(DiskUsageIntegTestCase.internalCluster().getInstance(Environment.class, nodeName).dataFiles()[0]);
    }

    private static class TestFileSystemProvider
    extends FilterFileSystemProvider {
        private final Map<Path, TestFileStore> trackedPaths = ConcurrentCollections.newConcurrentMap();
        private final Path rootDir;

        TestFileSystemProvider(FileSystem delegateInstance, Path rootDir) {
            super("diskthreshold://", delegateInstance);
            this.rootDir = new FilterPath(rootDir, this.fileSystem);
        }

        Path getRootDir() {
            return this.rootDir;
        }

        void addTrackedPath(Path path) {
            FileStore fileStore;
            Assert.assertTrue((String)(path + " starts with " + this.rootDir), (boolean)path.startsWith(this.rootDir));
            try {
                fileStore = super.getFileStore(path);
            }
            catch (IOException e) {
                throw new AssertionError("unexpected", e);
            }
            Assert.assertNull((Object)((Object)this.trackedPaths.put(path, new TestFileStore(fileStore, this.getScheme(), path))));
        }

        public FileStore getFileStore(Path path) {
            return this.getTestFileStore(path);
        }

        TestFileStore getTestFileStore(Path path) {
            TestFileStore fileStore;
            if (path.endsWith(path.getFileSystem().getPath("nodes", "0"))) {
                path = path.getParent().getParent();
            }
            if ((fileStore = this.trackedPaths.get(path)) != null) {
                return fileStore;
            }
            Assert.assertTrue((String)(path + " not tracked and not on Linux"), (boolean)Constants.LINUX);
            Set containingPaths = this.trackedPaths.keySet().stream().filter(path::startsWith).collect(Collectors.toSet());
            Assert.assertThat((String)(path + " not contained in a unique tracked path"), containingPaths, (Matcher)Matchers.hasSize((int)1));
            return this.trackedPaths.get(containingPaths.iterator().next());
        }

        void clearTrackedPaths() throws IOException {
            for (Path path : this.trackedPaths.keySet()) {
                IOUtils.rm((Path[])new Path[]{path});
            }
            this.trackedPaths.clear();
        }
    }

    protected static class TestFileStore
    extends FilterFileStore {
        private final Path path;
        private volatile long totalSpace = -1L;

        TestFileStore(FileStore delegate, String scheme, Path path) {
            super(delegate, scheme);
            this.path = path;
        }

        public String name() {
            return "fake";
        }

        public long getTotalSpace() throws IOException {
            long totalSpace = this.totalSpace;
            if (totalSpace == -1L) {
                return super.getTotalSpace();
            }
            return totalSpace;
        }

        public void setTotalSpace(long totalSpace) {
            Assert.assertThat((Object)totalSpace, (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)-1L), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
            this.totalSpace = totalSpace;
        }

        public long getUsableSpace() throws IOException {
            long totalSpace = this.totalSpace;
            if (totalSpace == -1L) {
                return super.getUsableSpace();
            }
            return Math.max(0L, totalSpace - TestFileStore.getTotalFileSize(this.path));
        }

        public long getUnallocatedSpace() throws IOException {
            long totalSpace = this.totalSpace;
            if (totalSpace == -1L) {
                return super.getUnallocatedSpace();
            }
            return Math.max(0L, totalSpace - TestFileStore.getTotalFileSize(this.path));
        }

        private static long getTotalFileSize(Path path) throws IOException {
            long l;
            block13: {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        return Files.size(path);
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        return 0L;
                    }
                }
                if (path.getFileName().toString().equals("_state") || path.getFileName().toString().equals("translog")) {
                    return 0L;
                }
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                try {
                    long total = 0L;
                    for (Path subpath : directoryStream) {
                        total += TestFileStore.getTotalFileSize(subpath);
                    }
                    l = total;
                    if (directoryStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (directoryStream != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException | NoSuchFileException | NotDirectoryException e) {
                        return 0L;
                    }
                }
                directoryStream.close();
            }
            return l;
        }
    }
}

