/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.EmptyClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.gateway.TestGatewayAllocator;

public abstract class ESAllocationTestCase
extends ESTestCase {
    private static final ClusterSettings EMPTY_CLUSTER_SETTINGS = new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
    public static final SnapshotsInfoService SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES = () -> new SnapshotShardSizeInfo(ImmutableOpenMap.of()){

        public Long getShardSize(ShardRouting shardRouting) {
            assert (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "Expecting a recovery source of type [SNAPSHOT] but got [" + shardRouting.recoverySource().getType() + ']';
            throw new UnsupportedOperationException();
        }
    };
    protected static Set<DiscoveryNodeRole> MASTER_DATA_ROLES = Collections.unmodifiableSet(new HashSet<DiscoveryNodeRole>(Arrays.asList(DiscoveryNodeRole.MASTER_ROLE, DiscoveryNodeRole.DATA_ROLE)));

    public static MockAllocationService createAllocationService() {
        return ESAllocationTestCase.createAllocationService(Settings.Builder.EMPTY_SETTINGS);
    }

    public static MockAllocationService createAllocationService(Settings settings) {
        return ESAllocationTestCase.createAllocationService(settings, ESAllocationTestCase.random());
    }

    public static MockAllocationService createAllocationService(Settings settings, Random random) {
        return ESAllocationTestCase.createAllocationService(settings, EMPTY_CLUSTER_SETTINGS, random);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterSettings clusterSettings, Random random) {
        return new MockAllocationService(ESAllocationTestCase.randomAllocationDeciders(settings, clusterSettings, random), new TestGatewayAllocator(), (ShardsAllocator)new BalancedShardsAllocator(settings), (ClusterInfoService)EmptyClusterInfoService.INSTANCE, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterInfoService clusterInfoService) {
        return new MockAllocationService(ESAllocationTestCase.randomAllocationDeciders(settings, EMPTY_CLUSTER_SETTINGS, ESAllocationTestCase.random()), new TestGatewayAllocator(), (ShardsAllocator)new BalancedShardsAllocator(settings), clusterInfoService, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator gatewayAllocator) {
        return ESAllocationTestCase.createAllocationService(settings, gatewayAllocator, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, SnapshotsInfoService snapshotsInfoService) {
        return ESAllocationTestCase.createAllocationService(settings, new TestGatewayAllocator(), snapshotsInfoService);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator gatewayAllocator, SnapshotsInfoService snapshotsInfoService) {
        return new MockAllocationService(ESAllocationTestCase.randomAllocationDeciders(settings, EMPTY_CLUSTER_SETTINGS, ESAllocationTestCase.random()), gatewayAllocator, (ShardsAllocator)new BalancedShardsAllocator(settings), (ClusterInfoService)EmptyClusterInfoService.INSTANCE, snapshotsInfoService);
    }

    public static AllocationDeciders randomAllocationDeciders(Settings settings, ClusterSettings clusterSettings, Random random) {
        ArrayList deciders = new ArrayList(ClusterModule.createAllocationDeciders((Settings)settings, (ClusterSettings)clusterSettings, Collections.emptyList()));
        Collections.shuffle(deciders, random);
        return new AllocationDeciders(deciders);
    }

    protected static DiscoveryNode newNode(String nodeId) {
        return ESAllocationTestCase.newNode(nodeId, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeName, String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeName, nodeId, ESAllocationTestCase.buildNewFakeTransportAddress(), attributes, MASTER_DATA_ROLES, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeId, ESAllocationTestCase.buildNewFakeTransportAddress(), attributes, MASTER_DATA_ROLES, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Set<DiscoveryNodeRole> roles) {
        return new DiscoveryNode(nodeId, ESAllocationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), roles, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Version version) {
        return new DiscoveryNode(nodeId, ESAllocationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), MASTER_DATA_ROLES, version);
    }

    protected static ClusterState startRandomInitializingShard(ClusterState clusterState, AllocationService strategy) {
        List initializingShards = clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
        if (initializingShards.isEmpty()) {
            return clusterState;
        }
        return ESAllocationTestCase.startShardsAndReroute(strategy, clusterState, (ShardRouting)ESAllocationTestCase.randomFrom(initializingShards));
    }

    protected static AllocationDeciders yesAllocationDeciders() {
        return new AllocationDeciders(Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.YES), new SameShardAllocationDecider(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))}));
    }

    protected static AllocationDeciders noAllocationDeciders() {
        return new AllocationDeciders(Collections.singleton(new TestAllocateDecision(Decision.NO)));
    }

    protected static AllocationDeciders throttleAllocationDeciders() {
        return new AllocationDeciders(Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.THROTTLE), new SameShardAllocationDecider(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))}));
    }

    protected ClusterState applyStartedShardsUntilNoChange(ClusterState clusterState, AllocationService service) {
        ClusterState lastClusterState;
        do {
            lastClusterState = clusterState;
            this.logger.debug("ClusterState: {}", (Object)clusterState.getRoutingNodes());
        } while (!lastClusterState.equals(clusterState = ESAllocationTestCase.startInitializingShardsAndReroute(service, clusterState)));
        return clusterState;
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, clusterState, clusterState.routingTable().shardsWithState(ShardRoutingState.INITIALIZING));
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState, RoutingNode routingNode) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, clusterState, routingNode.shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}));
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState, String index) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, clusterState, clusterState.routingTable().index(index).shardsWithState(ShardRoutingState.INITIALIZING));
    }

    public static ClusterState startShardsAndReroute(AllocationService allocationService, ClusterState clusterState, ShardRouting ... initializingShards) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, clusterState, Arrays.asList(initializingShards));
    }

    public static ClusterState startShardsAndReroute(AllocationService allocationService, ClusterState clusterState, List<ShardRouting> initializingShards) {
        return allocationService.reroute(allocationService.applyStartedShards(clusterState, initializingShards), "reroute after starting");
    }

    protected static class MockAllocationService
    extends AllocationService {
        private volatile long nanoTimeOverride = -1L;

        public MockAllocationService(AllocationDeciders allocationDeciders, GatewayAllocator gatewayAllocator, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService) {
            super(allocationDeciders, gatewayAllocator, shardsAllocator, clusterInfoService, snapshotsInfoService);
        }

        public void setNanoTimeOverride(long nanoTime) {
            this.nanoTimeOverride = nanoTime;
        }

        protected long currentNanoTime() {
            return this.nanoTimeOverride == -1L ? super.currentNanoTime() : this.nanoTimeOverride;
        }
    }

    public static class TestAllocateDecision
    extends AllocationDecider {
        private final Decision decision;

        public TestAllocateDecision(Decision decision) {
            this.decision = decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
            return this.decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
            return this.decision;
        }
    }

    protected static class DelayedShardsMockGatewayAllocator
    extends GatewayAllocator {
        public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        }

        public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        }

        public void beforeAllocation(RoutingAllocation allocation) {
        }

        public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
        }

        public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
            if (shardRouting.primary() || shardRouting.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED) {
                return;
            }
            if (shardRouting.unassignedInfo().isDelayed()) {
                unassignedAllocationHandler.removeAndIgnore(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, allocation.changes());
            }
        }
    }
}

