/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ESAllocationTestCase;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.CoordinationStateTestCluster;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.DeterministicTaskQueue;
import org.elasticsearch.cluster.coordination.ElectionSchedulerFactory;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.FollowersChecker;
import org.elasticsearch.cluster.coordination.InMemoryPersistedState;
import org.elasticsearch.cluster.coordination.LeaderChecker;
import org.elasticsearch.cluster.coordination.LinearizabilityChecker;
import org.elasticsearch.cluster.coordination.MockSinglePrioritizingExecutor;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.FakeThreadPoolMasterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.MockGatewayMetaState;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.node.Node;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.disruption.DisruptableMockTransport;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class AbstractCoordinatorTestCase
extends ESTestCase {
    protected final List<NodeEnvironment> nodeEnvironments = new ArrayList<NodeEnvironment>();
    protected final Set<Cluster.MockPersistedState> openPersistedStates = new HashSet<Cluster.MockPersistedState>();
    protected final AtomicInteger nextNodeIndex = new AtomicInteger();
    public static final long DEFAULT_CLUSTER_STATE_UPDATE_DELAY = 700L;
    private static final int ELECTION_RETRIES = 10;
    public static final long DEFAULT_ELECTION_DELAY = AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)PeerFinder.DISCOVERY_FIND_PEERS_INTERVAL_SETTING) * 2L + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)ElectionSchedulerFactory.ELECTION_INITIAL_TIMEOUT_SETTING) * 10L + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)ElectionSchedulerFactory.ELECTION_BACK_OFF_TIME_SETTING) * 10L * 9L / 2L + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)ElectionSchedulerFactory.ELECTION_DURATION_SETTING) * 10L + 400L + 700L;
    public static final long DEFAULT_STABILISATION_TIME = (AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)LeaderChecker.LEADER_CHECK_INTERVAL_SETTING) + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)LeaderChecker.LEADER_CHECK_TIMEOUT_SETTING)) * (long)AbstractCoordinatorTestCase.defaultInt((Setting<Integer>)LeaderChecker.LEADER_CHECK_RETRY_COUNT_SETTING) + DEFAULT_ELECTION_DELAY + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)Coordinator.PUBLISH_TIMEOUT_SETTING) + DEFAULT_ELECTION_DELAY + (AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)FollowersChecker.FOLLOWER_CHECK_INTERVAL_SETTING) + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)FollowersChecker.FOLLOWER_CHECK_TIMEOUT_SETTING)) * (long)AbstractCoordinatorTestCase.defaultInt((Setting<Integer>)FollowersChecker.FOLLOWER_CHECK_RETRY_COUNT_SETTING) + 700L;
    public static final String NODE_ID_LOG_CONTEXT_KEY = "nodeId";
    private final LinearizabilityChecker.SequentialSpec spec = new LinearizabilityChecker.KeyedSpec(){

        @Override
        public Object getKey(Object value) {
            return ((Tuple)value).v1();
        }

        @Override
        public Object getValue(Object value) {
            return ((Tuple)value).v2();
        }

        @Override
        public Object initialState() {
            return 0L;
        }

        @Override
        public Optional<Object> nextState(Object currentState, Object input, Object output) {
            if (input == null) {
                if (output == null || currentState.equals(output)) {
                    return Optional.of(currentState);
                }
                return Optional.empty();
            }
            if (output == null || currentState.equals(output)) {
                return Optional.of(input);
            }
            return Optional.empty();
        }
    };

    @Before
    public void resetNodeIndexBeforeEachTest() {
        this.nextNodeIndex.set(0);
    }

    @After
    public void closeNodeEnvironmentsAfterEachTest() {
        for (NodeEnvironment nodeEnvironment : this.nodeEnvironments) {
            nodeEnvironment.close();
        }
        this.nodeEnvironments.clear();
    }

    @After
    public void assertAllPersistedStatesClosed() {
        AbstractCoordinatorTestCase.assertThat(this.openPersistedStates, (Matcher)Matchers.empty());
    }

    @Before
    public void resetPortCounterBeforeEachTest() {
        AbstractCoordinatorTestCase.resetPortCounter();
    }

    public void testRepeatableTests() throws Exception {
        Callable<Long> test = () -> {
            this.resetNodeIndexBeforeEachTest();
            try (Cluster cluster = new Cluster(AbstractCoordinatorTestCase.randomIntBetween(1, 5));){
                cluster.runRandomly();
                long afterRunRandomly = this.value(cluster.getAnyNode().getLastAppliedClusterState());
                cluster.stabilise();
                long afterStabilisation = this.value(cluster.getAnyNode().getLastAppliedClusterState());
                Long l = afterRunRandomly ^ afterStabilisation;
                return l;
            }
        };
        long seed = AbstractCoordinatorTestCase.randomLong();
        this.logger.info("First run with seed [{}]", (Object)seed);
        long result1 = (Long)RandomizedContext.current().runWithPrivateRandomness(seed, test);
        this.logger.info("Second run with seed [{}]", (Object)seed);
        long result2 = (Long)RandomizedContext.current().runWithPrivateRandomness(seed, test);
        AbstractCoordinatorTestCase.assertEquals((long)result1, (long)result2);
    }

    protected static long defaultMillis(Setting<TimeValue> setting) {
        return ((TimeValue)setting.get(Settings.EMPTY)).millis() + 100L;
    }

    protected static int defaultInt(Setting<Integer> setting) {
        return (Integer)setting.get(Settings.EMPTY);
    }

    protected TransportInterceptor getTransportInterceptor(DiscoveryNode localNode, ThreadPool threadPool) {
        return TransportService.NOOP_TRANSPORT_INTERCEPTOR;
    }

    protected ElectionStrategy getElectionStrategy() {
        return ElectionStrategy.DEFAULT_INSTANCE;
    }

    protected static String getNodeIdForLogContext(DiscoveryNode node) {
        return "{" + node.getId() + "}{" + node.getEphemeralId() + "}";
    }

    public static Runnable onNodeLog(DiscoveryNode node, final Runnable runnable) {
        final String nodeId = AbstractCoordinatorTestCase.getNodeIdForLogContext(node);
        return new Runnable(){

            @Override
            public void run() {
                try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)AbstractCoordinatorTestCase.NODE_ID_LOG_CONTEXT_KEY, (String)nodeId);){
                    runnable.run();
                }
            }

            public String toString() {
                return nodeId + ": " + runnable.toString();
            }
        };
    }

    protected DiscoveryNode createDiscoveryNode(int nodeIndex, boolean masterEligible) {
        TransportAddress address = AbstractCoordinatorTestCase.buildNewFakeTransportAddress();
        return new DiscoveryNode("", "node" + nodeIndex, UUIDs.randomBase64UUID((Random)AbstractCoordinatorTestCase.random()), address.address().getHostString(), address.getAddress(), address, Collections.emptyMap(), (Set)(masterEligible ? DiscoveryNodeRole.BUILT_IN_ROLES : Collections.emptySet()), Version.CURRENT);
    }

    public ClusterState setValue(ClusterState clusterState, int key, long value) {
        return ClusterState.builder((ClusterState)clusterState).metadata(Metadata.builder((Metadata)clusterState.metadata()).persistentSettings(Settings.builder().put(clusterState.metadata().persistentSettings()).put("value_" + key, value).build()).build()).build();
    }

    public long value(ClusterState clusterState) {
        return this.value(clusterState, 0);
    }

    public long value(ClusterState clusterState, int key) {
        return clusterState.metadata().persistentSettings().getAsLong("value_" + key, Long.valueOf(0L));
    }

    public void assertStateEquals(ClusterState clusterState1, ClusterState clusterState2) {
        AbstractCoordinatorTestCase.assertEquals((long)clusterState1.version(), (long)clusterState2.version());
        AbstractCoordinatorTestCase.assertEquals((long)clusterState1.term(), (long)clusterState2.term());
        AbstractCoordinatorTestCase.assertEquals(this.keySet(clusterState1), this.keySet(clusterState2));
        for (int key : this.keySet(clusterState1)) {
            AbstractCoordinatorTestCase.assertEquals((long)this.value(clusterState1, key), (long)this.value(clusterState2, key));
        }
    }

    public Set<Integer> keySet(ClusterState clusterState) {
        return clusterState.metadata().persistentSettings().keySet().stream().filter(s -> s.startsWith("value_")).map(s -> Integer.valueOf(s.substring("value_".length()))).collect(Collectors.toSet());
    }

    public void testRegisterSpecConsistency() {
        AbstractCoordinatorTestCase.assertThat((Object)this.spec.initialState(), (Matcher)Matchers.equalTo((Object)0L));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, 42, 7), (Matcher)Matchers.equalTo(Optional.of(42)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, 42, null), (Matcher)Matchers.equalTo(Optional.of(42)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, null, 7), (Matcher)Matchers.equalTo(Optional.of(7)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, null, null), (Matcher)Matchers.equalTo(Optional.of(7)));
        AbstractCoordinatorTestCase.assertThat(this.spec.nextState(7, null, 42), (Matcher)Matchers.equalTo(Optional.empty()));
    }

    class Cluster
    implements Releasable {
        static final long EXTREME_DELAY_VARIABILITY = 10000L;
        static final long DEFAULT_DELAY_VARIABILITY = 100L;
        final List<ClusterNode> clusterNodes;
        final DeterministicTaskQueue deterministicTaskQueue = new DeterministicTaskQueue(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), "deterministic-task-queue").build(), LuceneTestCase.random());
        private boolean disruptStorage;
        final CoordinationMetadata.VotingConfiguration initialConfiguration;
        private final Set<String> disconnectedNodes = new HashSet<String>();
        private final Set<String> blackholedNodes = new HashSet<String>();
        private final Set<Tuple<String, String>> blackholedConnections = new HashSet<Tuple<String, String>>();
        private final Map<Long, ClusterState> committedStatesByVersion = new HashMap<Long, ClusterState>();
        private final LinearizabilityChecker linearizabilityChecker = new LinearizabilityChecker();
        private final LinearizabilityChecker.History history = new LinearizabilityChecker.History();
        private final BigArrays bigArrays;
        private final NodeHealthService nodeHealthService;
        private final Function<DiscoveryNode, MockPersistedState> defaultPersistedStateSupplier = x$0 -> new MockPersistedState((DiscoveryNode)x$0);
        @Nullable
        private List<TransportAddress> seedHostsList;
        private final DisruptableMockTransport.ConnectionStatus preferredUnknownNodeConnectionStatus = ESTestCase.randomFrom(DisruptableMockTransport.ConnectionStatus.DISCONNECTED, DisruptableMockTransport.ConnectionStatus.BLACK_HOLE);

        Cluster(int initialNodeCount) {
            this(initialNodeCount, true, Settings.EMPTY);
        }

        Cluster(int initialNodeCount, boolean allNodesMasterEligible, Settings nodeSettings) {
            this(initialNodeCount, allNodesMasterEligible, nodeSettings, () -> new StatusInfo(StatusInfo.Status.HEALTHY, "healthy-info"));
        }

        Cluster(int initialNodeCount, boolean allNodesMasterEligible, Settings nodeSettings, NodeHealthService nodeHealthService) {
            this.nodeHealthService = nodeHealthService;
            this.bigArrays = LuceneTestCase.usually() ? BigArrays.NON_RECYCLING_INSTANCE : new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)new NoneCircuitBreakerService());
            this.deterministicTaskQueue.setExecutionDelayVariabilityMillis(100L);
            Assert.assertThat((Object)initialNodeCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            HashSet<String> masterEligibleNodeIds = new HashSet<String>(initialNodeCount);
            this.clusterNodes = new ArrayList<ClusterNode>(initialNodeCount);
            for (int i = 0; i < initialNodeCount; ++i) {
                ClusterNode clusterNode = new ClusterNode(AbstractCoordinatorTestCase.this.nextNodeIndex.getAndIncrement(), allNodesMasterEligible || i == 0 || ESTestCase.randomBoolean(), nodeSettings, nodeHealthService);
                this.clusterNodes.add(clusterNode);
                if (!clusterNode.getLocalNode().isMasterNode()) continue;
                masterEligibleNodeIds.add(clusterNode.getId());
            }
            this.initialConfiguration = new CoordinationMetadata.VotingConfiguration(new HashSet(ESTestCase.randomSubsetOf(ESTestCase.randomIntBetween(1, masterEligibleNodeIds.size()), masterEligibleNodeIds)));
            AbstractCoordinatorTestCase.this.logger.info("--> creating cluster of {} nodes (master-eligible nodes: {}) with initial configuration {}", (Object)initialNodeCount, masterEligibleNodeIds, (Object)this.initialConfiguration);
        }

        void addNodesAndStabilise(int newNodesCount) {
            this.addNodes(newNodesCount);
            this.stabilise(AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)PeerFinder.DISCOVERY_FIND_PEERS_INTERVAL_SETTING) + 100L + (long)(newNodesCount * 2) * 700L);
        }

        List<ClusterNode> addNodes(int newNodesCount) {
            AbstractCoordinatorTestCase.this.logger.info("--> adding {} nodes", (Object)newNodesCount);
            ArrayList<ClusterNode> addedNodes = new ArrayList<ClusterNode>();
            for (int i = 0; i < newNodesCount; ++i) {
                ClusterNode clusterNode = new ClusterNode(AbstractCoordinatorTestCase.this.nextNodeIndex.getAndIncrement(), true, Settings.EMPTY, this.nodeHealthService);
                addedNodes.add(clusterNode);
            }
            this.clusterNodes.addAll(addedNodes);
            return addedNodes;
        }

        int size() {
            return this.clusterNodes.size();
        }

        void runRandomly() {
            this.runRandomly(true, true, 10000L);
        }

        void runRandomly(boolean allowReboots, boolean coolDown, long delayVariability) {
            Assert.assertThat((String)"may reconnect disconnected nodes, probably unexpected", this.disconnectedNodes, (Matcher)Matchers.empty());
            Assert.assertThat((String)"may reconnect blackholed nodes, probably unexpected", this.blackholedNodes, (Matcher)Matchers.empty());
            ArrayList<Runnable> cleanupActions = new ArrayList<Runnable>();
            cleanupActions.add(this.disconnectedNodes::clear);
            cleanupActions.add(this.blackholedNodes::clear);
            cleanupActions.add(() -> {
                this.disruptStorage = false;
            });
            int randomSteps = ESTestCase.scaledRandomIntBetween(10, 10000);
            int keyRange = randomSteps / 50;
            AbstractCoordinatorTestCase.this.logger.info("--> start of safety phase of at least [{}] steps with delay variability of [{}ms]", (Object)randomSteps, (Object)delayVariability);
            this.deterministicTaskQueue.setExecutionDelayVariabilityMillis(delayVariability);
            this.disruptStorage = true;
            int step = 0;
            long finishTime = -1L;
            while (finishTime == -1L || this.deterministicTaskQueue.getCurrentTimeMillis() <= finishTime) {
                int thisStep = ++step;
                if (randomSteps <= step && finishTime == -1L) {
                    if (coolDown) {
                        this.disconnectedNodes.clear();
                        this.blackholedNodes.clear();
                        this.deterministicTaskQueue.setExecutionDelayVariabilityMillis(100L);
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] reducing delay variability and running until [{}ms]", (Object)step, (Object)finishTime);
                    } else {
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] running until [{}ms] with delay variability of [{}ms]", (Object)step, (Object)finishTime, (Object)this.deterministicTaskQueue.getExecutionDelayVariabilityMillis());
                    }
                    finishTime = this.deterministicTaskQueue.getLatestDeferredExecutionTime();
                }
                try {
                    int key;
                    ClusterNode clusterNode;
                    if (finishTime == -1L && ESTestCase.randomBoolean() && ESTestCase.randomBoolean() && ESTestCase.randomBoolean()) {
                        clusterNode = this.getAnyNodePreferringLeaders();
                        key = ESTestCase.randomIntBetween(0, keyRange);
                        int newValue = ESTestCase.randomInt();
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] proposing new value [{}] to [{}]", (Object)thisStep, (Object)newValue, (Object)clusterNode.getId());
                            clusterNode.submitValue(key, newValue);
                        }).run();
                    } else if (finishTime == -1L && ESTestCase.randomBoolean() && ESTestCase.randomBoolean() && ESTestCase.randomBoolean()) {
                        clusterNode = this.getAnyNodePreferringLeaders();
                        key = ESTestCase.randomIntBetween(0, keyRange);
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] reading value from [{}]", (Object)thisStep, (Object)clusterNode.getId());
                            clusterNode.readValue(key);
                        }).run();
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNodePreferringLeaders();
                        boolean autoShrinkVotingConfiguration = ESTestCase.randomBoolean();
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] setting auto-shrink configuration to {} on {}", (Object)thisStep, (Object)autoShrinkVotingConfiguration, (Object)clusterNode.getId());
                            clusterNode.submitSetAutoShrinkVotingConfiguration(autoShrinkVotingConfiguration);
                        }).run();
                    } else if (allowReboots && LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] rebooting [{}]", (Object)thisStep, (Object)clusterNode.getId());
                        clusterNode.close();
                        this.clusterNodes.forEach(cn -> this.deterministicTaskQueue.scheduleNow(cn.onNode(new Runnable(){
                            final /* synthetic */ ClusterNode val$cn;
                            final /* synthetic */ ClusterNode val$clusterNode;
                            {
                                this.val$cn = clusterNode;
                                this.val$clusterNode = clusterNode2;
                            }

                            @Override
                            public void run() {
                                this.val$cn.transportService.disconnectFromNode(this.val$clusterNode.getLocalNode());
                            }

                            public String toString() {
                                return "disconnect from " + this.val$clusterNode.getLocalNode() + " after shutdown";
                            }
                        })));
                        this.clusterNodes.replaceAll(cn -> cn == clusterNode ? cn.restartedNode() : cn);
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        clusterNode.onNode(() -> {
                            AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] forcing {} to become candidate", (Object)thisStep, (Object)clusterNode.getId());
                            Object object = clusterNode.coordinator.mutex;
                            synchronized (object) {
                                clusterNode.coordinator.becomeCandidate("runRandomly");
                            }
                        }).run();
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        switch (ESTestCase.randomInt(2)) {
                            case 0: {
                                if (!clusterNode.heal()) break;
                                AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] healing {}", (Object)step, (Object)clusterNode.getId());
                                break;
                            }
                            case 1: {
                                if (finishTime != -1L || !clusterNode.disconnect()) break;
                                AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] disconnecting {}", (Object)step, (Object)clusterNode.getId());
                                break;
                            }
                            case 2: {
                                if (finishTime != -1L || !clusterNode.blackhole()) break;
                                AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] blackholing {}", (Object)step, (Object)clusterNode.getId());
                            }
                        }
                    } else if (LuceneTestCase.rarely()) {
                        clusterNode = this.getAnyNode();
                        AbstractCoordinatorTestCase.this.logger.debug("----> [runRandomly {}] applying initial configuration on {}", (Object)step, (Object)clusterNode.getId());
                        clusterNode.applyInitialConfiguration();
                    } else if (this.deterministicTaskQueue.hasDeferredTasks() && ESTestCase.randomBoolean()) {
                        this.deterministicTaskQueue.advanceTime();
                    } else if (this.deterministicTaskQueue.hasRunnableTasks()) {
                        this.deterministicTaskQueue.runRandomTask();
                    }
                }
                catch (UncheckedIOException | CoordinationStateRejectedException throwable) {
                    // empty catch block
                }
                this.assertConsistentStates();
            }
            AbstractCoordinatorTestCase.this.logger.debug("running {} cleanup actions", (Object)cleanupActions.size());
            cleanupActions.forEach(Runnable::run);
            AbstractCoordinatorTestCase.this.logger.debug("finished running cleanup actions");
        }

        private void assertConsistentStates() {
            for (ClusterNode clusterNode : this.clusterNodes) {
                clusterNode.coordinator.invariant();
            }
            this.updateCommittedStates();
        }

        private void updateCommittedStates() {
            for (ClusterNode clusterNode : this.clusterNodes) {
                ClusterState applierState = clusterNode.coordinator.getApplierState();
                ClusterState storedState = this.committedStatesByVersion.get(applierState.getVersion());
                if (storedState == null) {
                    this.committedStatesByVersion.put(applierState.getVersion(), applierState);
                    continue;
                }
                Assert.assertEquals((String)("expected " + applierState + " but got " + storedState), (long)AbstractCoordinatorTestCase.this.value(applierState), (long)AbstractCoordinatorTestCase.this.value(storedState));
            }
        }

        void stabilise() {
            this.stabilise(DEFAULT_STABILISATION_TIME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stabilise(long stabilisationDurationMillis) {
            Assert.assertThat((String)"stabilisation requires default delay variability (and proper cleanup of raised variability)", (Object)this.deterministicTaskQueue.getExecutionDelayVariabilityMillis(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(100L)));
            Assert.assertFalse((String)"stabilisation requires stable storage", (boolean)this.disruptStorage);
            this.bootstrapIfNecessary();
            this.runFor(stabilisationDurationMillis, "stabilising");
            ClusterNode leader = this.getAnyLeader();
            long leaderTerm = leader.coordinator.getCurrentTerm();
            int pendingTaskCount = leader.masterService.getFakeMasterServicePendingTaskCount();
            this.runFor((long)(pendingTaskCount + 1) * 700L, "draining task queue");
            Matcher isEqualToLeaderVersion = Matchers.equalTo((Object)leader.coordinator.getLastAcceptedState().getVersion());
            String leaderId = leader.getId();
            Assert.assertTrue((String)(leaderId + " has been bootstrapped"), (boolean)leader.coordinator.isInitialConfigurationSet());
            Assert.assertTrue((String)(leaderId + " exists in its last-applied state"), (boolean)leader.getLastAppliedClusterState().getNodes().nodeExists(leaderId));
            Assert.assertThat((String)(leaderId + " has no NO_MASTER_BLOCK"), (Object)leader.getLastAppliedClusterState().blocks().hasGlobalBlockWithId(2), (Matcher)Matchers.equalTo((Object)false));
            Assert.assertThat((String)(leaderId + " has no STATE_NOT_RECOVERED_BLOCK"), (Object)leader.getLastAppliedClusterState().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK), (Matcher)Matchers.equalTo((Object)false));
            Assert.assertThat((String)(leaderId + " has applied its state "), (Object)leader.getLastAppliedClusterState().getVersion(), (Matcher)isEqualToLeaderVersion);
            for (ClusterNode clusterNode : this.clusterNodes) {
                String nodeId = clusterNode.getId();
                Assert.assertFalse((String)(nodeId + " should not have an active publication"), (boolean)clusterNode.coordinator.publicationInProgress());
                if (clusterNode == leader) {
                    Assert.assertThat((String)(nodeId + " is still the leader"), (Object)clusterNode.coordinator.getMode(), (Matcher)Matchers.is((Object)Coordinator.Mode.LEADER));
                    Assert.assertThat((String)(nodeId + " did not change term"), (Object)clusterNode.coordinator.getCurrentTerm(), (Matcher)Matchers.is((Object)leaderTerm));
                    continue;
                }
                if (this.isConnectedPair(leader, clusterNode)) {
                    Assert.assertThat((String)(nodeId + " is a follower of " + leaderId), (Object)clusterNode.coordinator.getMode(), (Matcher)Matchers.is((Object)Coordinator.Mode.FOLLOWER));
                    Assert.assertThat((String)(nodeId + " has the same term as " + leaderId), (Object)clusterNode.coordinator.getCurrentTerm(), (Matcher)Matchers.is((Object)leaderTerm));
                    Assert.assertFalse((String)(nodeId + " is not a missing vote for  " + leaderId), (boolean)leader.coordinator.missingJoinVoteFrom(clusterNode.getLocalNode()));
                    Assert.assertThat((String)(nodeId + " has the same accepted state as " + leaderId), (Object)clusterNode.coordinator.getLastAcceptedState().getVersion(), (Matcher)isEqualToLeaderVersion);
                    if (clusterNode.getClusterStateApplyResponse() == ClusterStateApplyResponse.SUCCEED) {
                        Assert.assertThat((String)(nodeId + " has the same applied state as " + leaderId), (Object)clusterNode.getLastAppliedClusterState().getVersion(), (Matcher)isEqualToLeaderVersion);
                        Assert.assertTrue((String)(nodeId + " is in its own latest applied state"), (boolean)clusterNode.getLastAppliedClusterState().getNodes().nodeExists(nodeId));
                    }
                    Assert.assertTrue((String)(nodeId + " is in the latest applied state on " + leaderId), (boolean)leader.getLastAppliedClusterState().getNodes().nodeExists(nodeId));
                    Assert.assertTrue((String)(nodeId + " has been bootstrapped"), (boolean)clusterNode.coordinator.isInitialConfigurationSet());
                    Assert.assertThat((String)(nodeId + " has correct master"), (Object)clusterNode.getLastAppliedClusterState().nodes().getMasterNode(), (Matcher)Matchers.equalTo((Object)leader.getLocalNode()));
                    Assert.assertThat((String)(nodeId + " has no NO_MASTER_BLOCK"), (Object)clusterNode.getLastAppliedClusterState().blocks().hasGlobalBlockWithId(2), (Matcher)Matchers.equalTo((Object)false));
                    Assert.assertThat((String)(nodeId + " has no STATE_NOT_RECOVERED_BLOCK"), (Object)clusterNode.getLastAppliedClusterState().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK), (Matcher)Matchers.equalTo((Object)false));
                    continue;
                }
                Assert.assertThat((String)(nodeId + " is not following " + leaderId), (Object)clusterNode.coordinator.getMode(), (Matcher)Matchers.is((Object)Coordinator.Mode.CANDIDATE));
                Assert.assertThat((String)(nodeId + " has no master"), (Object)clusterNode.getLastAppliedClusterState().nodes().getMasterNode(), (Matcher)Matchers.nullValue());
                Assert.assertThat((String)(nodeId + " has NO_MASTER_BLOCK"), (Object)clusterNode.getLastAppliedClusterState().blocks().hasGlobalBlockWithId(2), (Matcher)Matchers.equalTo((Object)true));
                Assert.assertFalse((String)(nodeId + " is not in the applied state on " + leaderId), (boolean)leader.getLastAppliedClusterState().getNodes().nodeExists(nodeId));
            }
            Set connectedNodeIds = this.clusterNodes.stream().filter(n -> this.isConnectedPair(leader, (ClusterNode)n)).map(ClusterNode::getId).collect(Collectors.toSet());
            Assert.assertThat((Object)leader.getLastAppliedClusterState().getNodes().getSize(), (Matcher)Matchers.equalTo((Object)connectedNodeIds.size()));
            ClusterState lastAcceptedState = leader.coordinator.getLastAcceptedState();
            CoordinationMetadata.VotingConfiguration lastCommittedConfiguration = lastAcceptedState.getLastCommittedConfiguration();
            Assert.assertTrue((String)(connectedNodeIds + " should be a quorum of " + lastCommittedConfiguration), (boolean)lastCommittedConfiguration.hasQuorum(connectedNodeIds));
            Assert.assertThat((String)("leader " + leader.getLocalNode() + " should be part of voting configuration " + lastCommittedConfiguration), (Object)lastCommittedConfiguration.getNodeIds(), (Matcher)Matchers.hasItem((Object)leader.getLocalNode().getId()));
            Assert.assertThat((String)"no reconfiguration is in progress", (Object)lastAcceptedState.getLastCommittedConfiguration(), (Matcher)Matchers.equalTo((Object)lastAcceptedState.getLastAcceptedConfiguration()));
            Assert.assertThat((String)"current configuration is already optimal", (Object)leader.improveConfiguration(lastAcceptedState), (Matcher)Matchers.sameInstance((Object)lastAcceptedState));
            AbstractCoordinatorTestCase.this.logger.info("checking linearizability of history with size {}: {}", (Object)this.history.size(), (Object)this.history);
            AtomicBoolean abort = new AtomicBoolean();
            ScheduledThreadPoolExecutor scheduler = Scheduler.initScheduler((Settings)Settings.EMPTY);
            try {
                if (this.history.size() > 300) {
                    scheduler.schedule(() -> abort.set(true), 10L, TimeUnit.SECONDS);
                }
                boolean linearizable = this.linearizabilityChecker.isLinearizable(AbstractCoordinatorTestCase.this.spec, this.history, i -> null, abort::get);
                if (!abort.get()) {
                    Assert.assertTrue((String)("history not linearizable: " + this.history), (boolean)linearizable);
                }
            }
            finally {
                ThreadPool.terminate((ExecutorService)scheduler, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            AbstractCoordinatorTestCase.this.logger.info("linearizability check completed");
        }

        void bootstrapIfNecessary() {
            if (this.clusterNodes.stream().allMatch(rec$ -> ((ClusterNode)rec$).isNotUsefullyBootstrapped())) {
                Assert.assertThat((String)"setting initial configuration may fail with disconnected nodes", this.disconnectedNodes, (Matcher)Matchers.empty());
                Assert.assertThat((String)"setting initial configuration may fail with blackholed nodes", this.blackholedNodes, (Matcher)Matchers.empty());
                this.runFor(AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)TransportSettings.CONNECT_TIMEOUT) + AbstractCoordinatorTestCase.defaultMillis((Setting<TimeValue>)PeerFinder.DISCOVERY_FIND_PEERS_INTERVAL_SETTING) * 2L, "discovery prior to setting initial configuration");
                ClusterNode bootstrapNode = this.getAnyBootstrappableNode();
                bootstrapNode.applyInitialConfiguration();
            } else {
                AbstractCoordinatorTestCase.this.logger.info("setting initial configuration not required");
            }
        }

        void runFor(long runDurationMillis, String description) {
            long endTime = this.deterministicTaskQueue.getCurrentTimeMillis() + runDurationMillis;
            AbstractCoordinatorTestCase.this.logger.info("--> runFor({}ms) running until [{}ms]: {}", (Object)runDurationMillis, (Object)endTime, (Object)description);
            while (this.deterministicTaskQueue.getCurrentTimeMillis() < endTime) {
                while (this.deterministicTaskQueue.hasRunnableTasks()) {
                    try {
                        this.deterministicTaskQueue.runRandomTask();
                    }
                    catch (CoordinationStateRejectedException e) {
                        AbstractCoordinatorTestCase.this.logger.debug("ignoring benign exception thrown when stabilising", (Throwable)e);
                    }
                    for (ClusterNode clusterNode : this.clusterNodes) {
                        clusterNode.coordinator.invariant();
                    }
                    this.updateCommittedStates();
                }
                if (!this.deterministicTaskQueue.hasDeferredTasks()) {
                    assert (this.clusterNodes.size() == 1) : this.clusterNodes.size();
                    break;
                }
                this.deterministicTaskQueue.advanceTime();
            }
            AbstractCoordinatorTestCase.this.logger.info("--> runFor({}ms) completed run until [{}ms]: {}", (Object)runDurationMillis, (Object)endTime, (Object)description);
        }

        private boolean isConnectedPair(ClusterNode n1, ClusterNode n2) {
            return n1 == n2 || this.getConnectionStatus(n1.getLocalNode(), n2.getLocalNode()) == DisruptableMockTransport.ConnectionStatus.CONNECTED && this.getConnectionStatus(n2.getLocalNode(), n1.getLocalNode()) == DisruptableMockTransport.ConnectionStatus.CONNECTED && n1.nodeHealthService.getHealth().getStatus() == StatusInfo.Status.HEALTHY && n2.nodeHealthService.getHealth().getStatus() == StatusInfo.Status.HEALTHY;
        }

        ClusterNode getAnyLeader() {
            List allLeaders = this.clusterNodes.stream().filter(ClusterNode::isLeader).collect(Collectors.toList());
            Assert.assertThat((String)"leaders", allLeaders, (Matcher)Matchers.not((Matcher)Matchers.empty()));
            return (ClusterNode)ESTestCase.randomFrom(allLeaders);
        }

        private DisruptableMockTransport.ConnectionStatus getConnectionStatus(DiscoveryNode sender, DiscoveryNode destination) {
            DisruptableMockTransport.ConnectionStatus connectionStatus = this.blackholedNodes.contains(sender.getId()) || this.blackholedNodes.contains(destination.getId()) ? DisruptableMockTransport.ConnectionStatus.BLACK_HOLE : (this.disconnectedNodes.contains(sender.getId()) || this.disconnectedNodes.contains(destination.getId()) ? DisruptableMockTransport.ConnectionStatus.DISCONNECTED : (this.blackholedConnections.contains(Tuple.tuple((Object)sender.getId(), (Object)destination.getId())) ? DisruptableMockTransport.ConnectionStatus.BLACK_HOLE_REQUESTS_ONLY : (this.nodeExists(sender) && this.nodeExists(destination) ? DisruptableMockTransport.ConnectionStatus.CONNECTED : (LuceneTestCase.usually() ? this.preferredUnknownNodeConnectionStatus : ESTestCase.randomFrom(DisruptableMockTransport.ConnectionStatus.DISCONNECTED, DisruptableMockTransport.ConnectionStatus.BLACK_HOLE)))));
            return connectionStatus;
        }

        boolean nodeExists(DiscoveryNode node) {
            return this.clusterNodes.stream().anyMatch(cn -> cn.getLocalNode().equals((Object)node));
        }

        ClusterNode getAnyBootstrappableNode() {
            return (ClusterNode)ESTestCase.randomFrom(this.clusterNodes.stream().filter(n -> n.getLocalNode().isMasterNode()).filter(n -> this.initialConfiguration.getNodeIds().contains(n.getLocalNode().getId())).collect(Collectors.toList()));
        }

        ClusterNode getAnyNode() {
            return this.getAnyNodeExcept(new ClusterNode[0]);
        }

        ClusterNode getAnyNodeExcept(ClusterNode ... clusterNodes) {
            List<ClusterNode> filteredNodes = this.getAllNodesExcept(clusterNodes);
            assert (!filteredNodes.isEmpty());
            return ESTestCase.randomFrom(filteredNodes);
        }

        List<ClusterNode> getAllNodesExcept(ClusterNode ... clusterNodes) {
            Set forbiddenIds = Arrays.stream(clusterNodes).map(ClusterNode::getId).collect(Collectors.toSet());
            List<ClusterNode> acceptableNodes = this.clusterNodes.stream().filter(n -> !forbiddenIds.contains(n.getId())).collect(Collectors.toList());
            return acceptableNodes;
        }

        ClusterNode getAnyNodePreferringLeaders() {
            for (int i = 0; i < 3; ++i) {
                ClusterNode clusterNode = this.getAnyNode();
                if (clusterNode.coordinator.getMode() != Coordinator.Mode.LEADER) continue;
                return clusterNode;
            }
            return this.getAnyNode();
        }

        void setEmptySeedHostsList() {
            this.seedHostsList = Collections.emptyList();
        }

        void blackholeConnectionsFrom(ClusterNode sender, ClusterNode destination) {
            this.blackholedConnections.add((Tuple<String, String>)Tuple.tuple((Object)sender.getId(), (Object)destination.getId()));
        }

        void clearBlackholedConnections() {
            this.blackholedConnections.clear();
        }

        public void close() {
            this.clusterNodes.forEach(ClusterNode::close);
        }

        private List<TransportAddress> provideSeedHosts(SeedHostsProvider.HostsResolver ignored) {
            return this.seedHostsList != null ? this.seedHostsList : this.clusterNodes.stream().map(ClusterNode::getLocalNode).map(DiscoveryNode::getAddress).collect(Collectors.toList());
        }

        class ClusterNode {
            private final Logger logger = LogManager.getLogger(ClusterNode.class);
            private final int nodeIndex;
            Coordinator coordinator;
            private final DiscoveryNode localNode;
            final MockPersistedState persistedState;
            final Settings nodeSettings;
            private AckedFakeThreadPoolMasterService masterService;
            private DisruptableClusterApplierService clusterApplierService;
            private ClusterService clusterService;
            TransportService transportService;
            private DisruptableMockTransport mockTransport;
            private NodeHealthService nodeHealthService;
            List<BiConsumer<DiscoveryNode, ClusterState>> extraJoinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();

            ClusterNode(int nodeIndex, boolean masterEligible, Settings nodeSettings, NodeHealthService nodeHealthService) {
                this(nodeIndex, this$1.AbstractCoordinatorTestCase.this.createDiscoveryNode(nodeIndex, masterEligible), this$1.defaultPersistedStateSupplier, nodeSettings, nodeHealthService);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ClusterNode(int nodeIndex, DiscoveryNode localNode, Function<DiscoveryNode, MockPersistedState> persistedStateSupplier, Settings nodeSettings, NodeHealthService nodeHealthService) {
                this.nodeHealthService = nodeHealthService;
                this.nodeIndex = nodeIndex;
                this.localNode = localNode;
                this.nodeSettings = nodeSettings;
                this.persistedState = persistedStateSupplier.apply(localNode);
                Assert.assertTrue((String)"must use a fresh PersistedState", (boolean)AbstractCoordinatorTestCase.this.openPersistedStates.add(this.persistedState));
                boolean success = false;
                try {
                    AbstractCoordinatorTestCase.onNodeLog(localNode, this::setUp).run();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.persistedState.close();
                    }
                }
            }

            private void setUp() {
                ThreadPool threadPool = Cluster.this.deterministicTaskQueue.getThreadPool(this::onNode);
                this.mockTransport = new DisruptableMockTransport(this.localNode, this.logger, Cluster.this.deterministicTaskQueue){

                    @Override
                    protected void execute(Runnable runnable) {
                        Cluster.this.deterministicTaskQueue.scheduleNow(ClusterNode.this.onNode(runnable));
                    }

                    @Override
                    protected DisruptableMockTransport.ConnectionStatus getConnectionStatus(DiscoveryNode destination) {
                        return Cluster.this.getConnectionStatus(this.getLocalNode(), destination);
                    }

                    @Override
                    protected Optional<DisruptableMockTransport> getDisruptableMockTransport(TransportAddress address) {
                        return Cluster.this.clusterNodes.stream().map(cn -> ((ClusterNode)cn).mockTransport).filter(transport -> transport.getLocalNode().getAddress().equals((Object)address)).findAny();
                    }
                };
                Settings settings = this.nodeSettings.hasValue(DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey()) ? this.nodeSettings : Settings.builder().put(this.nodeSettings).putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), (List)ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(Settings.EMPTY)).build();
                this.transportService = this.mockTransport.createTransportService(settings, threadPool, AbstractCoordinatorTestCase.this.getTransportInterceptor(this.localNode, threadPool), a -> this.localNode, null, Collections.emptySet());
                this.masterService = new AckedFakeThreadPoolMasterService(this.localNode.getId(), "test", threadPool, runnable -> Cluster.this.deterministicTaskQueue.scheduleNow(this.onNode((Runnable)runnable)));
                ClusterSettings clusterSettings = new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
                this.clusterApplierService = new DisruptableClusterApplierService(this.localNode.getId(), settings, clusterSettings, Cluster.this.deterministicTaskQueue, threadPool);
                this.clusterService = new ClusterService(settings, clusterSettings, (MasterService)this.masterService, (ClusterApplierService)this.clusterApplierService);
                this.clusterService.setNodeConnectionsService(new NodeConnectionsService(this.clusterService.getSettings(), threadPool, this.transportService));
                List<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators = Collections.singletonList((dn, cs) -> this.extraJoinValidators.forEach(validator -> validator.accept(dn, cs)));
                ESAllocationTestCase.MockAllocationService allocationService = ESAllocationTestCase.createAllocationService(Settings.EMPTY);
                this.coordinator = new Coordinator("test_node", settings, clusterSettings, this.transportService, AbstractCoordinatorTestCase.this.writableRegistry(), (AllocationService)allocationService, (MasterService)this.masterService, this::getPersistedState, x$0 -> Cluster.this.provideSeedHosts(x$0), (ClusterApplier)this.clusterApplierService, onJoinValidators, Randomness.get(), (s, p, r) -> {}, AbstractCoordinatorTestCase.this.getElectionStrategy(), this.nodeHealthService);
                this.masterService.setClusterStatePublisher((ClusterStatePublisher)this.coordinator);
                GatewayService gatewayService = new GatewayService(settings, (AllocationService)allocationService, this.clusterService, threadPool, null, (Discovery)this.coordinator);
                this.logger.trace("starting up [{}]", (Object)this.localNode);
                this.transportService.start();
                this.transportService.acceptIncomingRequests();
                this.coordinator.start();
                gatewayService.start();
                this.clusterService.start();
                this.coordinator.startInitialJoin();
            }

            void close() {
                Assert.assertThat((String)"must add nodes to a cluster before closing them", Cluster.this.clusterNodes, (Matcher)Matchers.hasItem((Object)this));
                this.onNode(() -> {
                    this.logger.trace("closing");
                    this.coordinator.stop();
                    this.clusterService.stop();
                    this.clusterService.close();
                    this.coordinator.close();
                }).run();
            }

            ClusterNode restartedNode() {
                return this.restartedNode(Function.identity(), Function.identity(), this.nodeSettings);
            }

            ClusterNode restartedNode(Function<Metadata, Metadata> adaptGlobalMetadata, Function<Long, Long> adaptCurrentTerm, Settings nodeSettings) {
                TransportAddress address = ESTestCase.randomBoolean() ? ESTestCase.buildNewFakeTransportAddress() : this.localNode.getAddress();
                DiscoveryNode newLocalNode = new DiscoveryNode(this.localNode.getName(), this.localNode.getId(), UUIDs.randomBase64UUID((Random)LuceneTestCase.random()), address.address().getHostString(), address.getAddress(), address, Collections.emptyMap(), this.localNode.isMasterNode() && DiscoveryNode.isMasterNode((Settings)nodeSettings) ? DiscoveryNodeRole.BUILT_IN_ROLES : Collections.emptySet(), Version.CURRENT);
                return new ClusterNode(this.nodeIndex, newLocalNode, node -> new MockPersistedState(newLocalNode, this.persistedState, adaptGlobalMetadata, adaptCurrentTerm), nodeSettings, this.nodeHealthService);
            }

            private CoordinationState.PersistedState getPersistedState() {
                return this.persistedState;
            }

            String getId() {
                return this.localNode.getId();
            }

            DiscoveryNode getLocalNode() {
                return this.localNode;
            }

            boolean isLeader() {
                return this.coordinator.getMode() == Coordinator.Mode.LEADER;
            }

            boolean isCandidate() {
                return this.coordinator.getMode() == Coordinator.Mode.CANDIDATE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ClusterState improveConfiguration(ClusterState currentState) {
                Object object = this.coordinator.mutex;
                synchronized (object) {
                    return this.coordinator.improveConfiguration(currentState);
                }
            }

            void setClusterStateApplyResponse(ClusterStateApplyResponse clusterStateApplyResponse) {
                this.clusterApplierService.clusterStateApplyResponse = clusterStateApplyResponse;
            }

            ClusterStateApplyResponse getClusterStateApplyResponse() {
                return this.clusterApplierService.clusterStateApplyResponse;
            }

            Runnable onNode(final Runnable runnable) {
                final Runnable wrapped = AbstractCoordinatorTestCase.onNodeLog(this.localNode, runnable);
                return new Runnable(){

                    @Override
                    public void run() {
                        if (!Cluster.this.clusterNodes.contains(ClusterNode.this)) {
                            ClusterNode.this.logger.trace("ignoring runnable {} from node {} as node has been removed from cluster", (Object)runnable, (Object)ClusterNode.this.localNode);
                            return;
                        }
                        wrapped.run();
                    }

                    public String toString() {
                        return wrapped.toString();
                    }
                };
            }

            void submitSetAutoShrinkVotingConfiguration(boolean autoShrinkVotingConfiguration) {
                this.submitUpdateTask("set master nodes failure tolerance [" + autoShrinkVotingConfiguration + "]", cs -> ClusterState.builder((ClusterState)cs).metadata(Metadata.builder((Metadata)cs.metadata()).persistentSettings(Settings.builder().put(cs.metadata().persistentSettings()).put(Reconfigurator.CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION.getKey(), autoShrinkVotingConfiguration).build()).build()).build(), (source, e) -> {});
            }

            AckCollector submitValue(long value) {
                return this.submitValue(0, value);
            }

            AckCollector submitValue(final int key, long value) {
                final int eventId = Cluster.this.history.invoke(new Tuple((Object)key, (Object)value));
                return this.submitUpdateTask("new value [" + value + "]", cs -> AbstractCoordinatorTestCase.this.setValue((ClusterState)cs, key, value), new ClusterStateTaskListener(){

                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        Cluster.this.history.respond(eventId, AbstractCoordinatorTestCase.this.value(oldState, key));
                    }

                    public void onNoLongerMaster(String source) {
                        Cluster.this.history.remove(eventId);
                    }

                    public void onFailure(String source, Exception e) {
                    }
                });
            }

            void readValue(final int key) {
                final int eventId = Cluster.this.history.invoke(new Tuple((Object)key, null));
                this.submitUpdateTask("read value", cs -> ClusterState.builder((ClusterState)cs).build(), new ClusterStateTaskListener(){

                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        Cluster.this.history.respond(eventId, AbstractCoordinatorTestCase.this.value(newState, key));
                    }

                    public void onFailure(String source, Exception e) {
                        Cluster.this.history.remove(eventId);
                    }
                });
            }

            AckCollector submitUpdateTask(String source, final UnaryOperator<ClusterState> clusterStateUpdate, final ClusterStateTaskListener taskListener) {
                final AckCollector ackCollector = new AckCollector();
                this.onNode(() -> {
                    this.logger.trace("[{}] submitUpdateTask: enqueueing [{}]", (Object)this.localNode.getId(), (Object)source);
                    final long submittedTerm = this.coordinator.getCurrentTerm();
                    this.masterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                        public ClusterState execute(ClusterState currentState) {
                            Assert.assertThat((Object)currentState.term(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(submittedTerm)));
                            ((ClusterNode)ClusterNode.this).masterService.nextAckCollector = ackCollector;
                            return (ClusterState)clusterStateUpdate.apply(currentState);
                        }

                        public void onFailure(String source, Exception e) {
                            ClusterNode.this.logger.debug(() -> new ParameterizedMessage("failed to publish: [{}]", (Object)source), (Throwable)e);
                            taskListener.onFailure(source, e);
                        }

                        public void onNoLongerMaster(String source) {
                            ClusterNode.this.logger.trace("no longer master: [{}]", (Object)source);
                            taskListener.onNoLongerMaster(source);
                        }

                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            Cluster.this.updateCommittedStates();
                            ClusterState state = (ClusterState)Cluster.this.committedStatesByVersion.get(newState.version());
                            Assert.assertNotNull((String)("State not committed : " + newState.toString()), (Object)state);
                            AbstractCoordinatorTestCase.this.assertStateEquals(state, newState);
                            ClusterNode.this.logger.trace("successfully published: [{}]", (Object)newState);
                            taskListener.clusterStateProcessed(source, oldState, newState);
                        }
                    });
                }).run();
                return ackCollector;
            }

            public String toString() {
                return this.localNode.toString();
            }

            boolean heal() {
                boolean unBlackholed = Cluster.this.blackholedNodes.remove(this.localNode.getId());
                boolean unDisconnected = Cluster.this.disconnectedNodes.remove(this.localNode.getId());
                assert (!unBlackholed || !unDisconnected);
                return unBlackholed || unDisconnected;
            }

            boolean disconnect() {
                boolean unBlackholed = Cluster.this.blackholedNodes.remove(this.localNode.getId());
                boolean disconnected = Cluster.this.disconnectedNodes.add(this.localNode.getId());
                assert (disconnected || !unBlackholed);
                return disconnected;
            }

            boolean blackhole() {
                boolean unDisconnected = Cluster.this.disconnectedNodes.remove(this.localNode.getId());
                boolean blackholed = Cluster.this.blackholedNodes.add(this.localNode.getId());
                assert (blackholed || !unDisconnected);
                return blackholed;
            }

            void onDisconnectEventFrom(ClusterNode clusterNode) {
                this.transportService.disconnectFromNode(clusterNode.localNode);
            }

            ClusterState getLastAppliedClusterState() {
                return this.clusterApplierService.state();
            }

            void applyInitialConfiguration() {
                this.onNode(() -> {
                    HashSet nodeIdsWithPlaceholders = new HashSet(Cluster.this.initialConfiguration.getNodeIds());
                    Stream.generate(() -> "{bootstrap-placeholder}-" + UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).limit((Math.max(Cluster.this.initialConfiguration.getNodeIds().size(), 2) - 1) / 2).forEach(nodeIdsWithPlaceholders::add);
                    HashSet<String> nodeIds = new HashSet<String>(ESTestCase.randomSubsetOf(Cluster.this.initialConfiguration.getNodeIds().size(), nodeIdsWithPlaceholders));
                    if (Cluster.this.initialConfiguration.getNodeIds().contains(this.localNode.getId()) && !nodeIds.contains(this.localNode.getId())) {
                        nodeIds.remove(nodeIds.iterator().next());
                        nodeIds.add(this.localNode.getId());
                    }
                    CoordinationMetadata.VotingConfiguration configurationWithPlaceholders = new CoordinationMetadata.VotingConfiguration(nodeIds);
                    try {
                        this.coordinator.setInitialConfiguration(configurationWithPlaceholders);
                        this.logger.info("successfully set initial configuration to {}", (Object)configurationWithPlaceholders);
                    }
                    catch (CoordinationStateRejectedException e) {
                        this.logger.info((Message)new ParameterizedMessage("failed to set initial configuration to {}", (Object)configurationWithPlaceholders), (Throwable)e);
                    }
                }).run();
            }

            private boolean isNotUsefullyBootstrapped() {
                return !this.getLocalNode().isMasterNode() || !this.coordinator.isInitialConfigurationSet();
            }

            void allowClusterStateApplicationFailure() {
                this.clusterApplierService.allowClusterStateApplicationFailure();
            }
        }

        class MockPersistedState
        implements CoordinationState.PersistedState {
            private final CoordinationState.PersistedState delegate;
            private final NodeEnvironment nodeEnvironment;

            MockPersistedState(DiscoveryNode localNode) {
                try {
                    if (LuceneTestCase.rarely()) {
                        this.nodeEnvironment = AbstractCoordinatorTestCase.this.newNodeEnvironment();
                        AbstractCoordinatorTestCase.this.nodeEnvironments.add(this.nodeEnvironment);
                        MockGatewayMetaState gatewayMetaState = new MockGatewayMetaState(localNode, Cluster.this.bigArrays);
                        gatewayMetaState.start(Settings.EMPTY, this.nodeEnvironment, AbstractCoordinatorTestCase.this.xContentRegistry());
                        this.delegate = gatewayMetaState.getPersistedState();
                    } else {
                        this.nodeEnvironment = null;
                        this.delegate = new InMemoryPersistedState(0L, ClusterStateUpdaters.addStateNotRecoveredBlock((ClusterState)CoordinationStateTestCluster.clusterState(0L, 0L, localNode, CoordinationMetadata.VotingConfiguration.EMPTY_CONFIG, CoordinationMetadata.VotingConfiguration.EMPTY_CONFIG, 0L)));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to create MockPersistedState", e);
                }
            }

            MockPersistedState(DiscoveryNode newLocalNode, MockPersistedState oldState, Function<Metadata, Metadata> adaptGlobalMetadata, Function<Long, Long> adaptCurrentTerm) {
                block17: {
                    try {
                        long persistedCurrentTerm;
                        if (oldState.nodeEnvironment != null) {
                            this.nodeEnvironment = oldState.nodeEnvironment;
                            Metadata updatedMetadata = adaptGlobalMetadata.apply(oldState.getLastAcceptedState().metadata());
                            long updatedTerm = adaptCurrentTerm.apply(oldState.getCurrentTerm());
                            if (updatedMetadata != oldState.getLastAcceptedState().metadata() || updatedTerm != oldState.getCurrentTerm()) {
                                try (PersistedClusterStateService.Writer writer = new PersistedClusterStateService(this.nodeEnvironment, AbstractCoordinatorTestCase.this.xContentRegistry(), Cluster.this.bigArrays, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), Cluster.this.deterministicTaskQueue::getCurrentTimeMillis).createWriter();){
                                    writer.writeFullStateAndCommit(updatedTerm, ClusterState.builder((ClusterState)oldState.getLastAcceptedState()).metadata(updatedMetadata).build());
                                }
                            }
                            MockGatewayMetaState gatewayMetaState = new MockGatewayMetaState(newLocalNode, Cluster.this.bigArrays);
                            gatewayMetaState.start(Settings.EMPTY, this.nodeEnvironment, AbstractCoordinatorTestCase.this.xContentRegistry());
                            this.delegate = gatewayMetaState.getPersistedState();
                            break block17;
                        }
                        this.nodeEnvironment = null;
                        BytesStreamOutput outStream = new BytesStreamOutput();
                        outStream.setVersion(Version.CURRENT);
                        if (!(oldState.getLastAcceptedState().nodes().getLocalNode().isMasterNode() && newLocalNode.isMasterNode()) && (oldState.getLastAcceptedState().term() > 0L || oldState.getLastAcceptedState().version() > 0L) && ESTestCase.randomBoolean()) {
                            long newLastAcceptedVersion;
                            long newLastAcceptedTerm;
                            persistedCurrentTerm = ESTestCase.randomLongBetween(0L, oldState.getCurrentTerm());
                            long lastAcceptedTerm = oldState.getLastAcceptedState().term();
                            long lastAcceptedVersion = oldState.getLastAcceptedState().version();
                            if (lastAcceptedVersion == 0L) {
                                newLastAcceptedTerm = ESTestCase.randomLongBetween(0L, Math.min(persistedCurrentTerm, lastAcceptedTerm - 1L));
                                newLastAcceptedVersion = ESTestCase.randomNonNegativeLong();
                            } else {
                                newLastAcceptedTerm = ESTestCase.randomLongBetween(0L, Math.min(persistedCurrentTerm, lastAcceptedTerm));
                                newLastAcceptedVersion = ESTestCase.randomLongBetween(0L, newLastAcceptedTerm == lastAcceptedTerm ? lastAcceptedVersion - 1L : Long.MAX_VALUE);
                            }
                            CoordinationMetadata.VotingConfiguration newVotingConfiguration = new CoordinationMetadata.VotingConfiguration(ESTestCase.randomBoolean() ? Collections.emptySet() : Collections.singleton(ESTestCase.randomAlphaOfLength(10)));
                            long newValue = ESTestCase.randomLong();
                            AbstractCoordinatorTestCase.this.logger.trace("rolling back persisted cluster state on master-ineligible node [{}]: previously currentTerm={}, lastAcceptedTerm={}, lastAcceptedVersion={} but now currentTerm={}, lastAcceptedTerm={}, lastAcceptedVersion={}", (Object)newLocalNode, (Object)oldState.getCurrentTerm(), (Object)lastAcceptedTerm, (Object)lastAcceptedVersion, (Object)persistedCurrentTerm, (Object)newLastAcceptedTerm, (Object)newLastAcceptedVersion);
                            CoordinationStateTestCluster.clusterState(newLastAcceptedTerm, newLastAcceptedVersion, newLocalNode, newVotingConfiguration, newVotingConfiguration, newValue).writeTo((StreamOutput)outStream);
                        } else {
                            persistedCurrentTerm = oldState.getCurrentTerm();
                            Metadata updatedMetadata = adaptGlobalMetadata.apply(oldState.getLastAcceptedState().metadata());
                            if (updatedMetadata != oldState.getLastAcceptedState().metadata()) {
                                ClusterState.builder((ClusterState)oldState.getLastAcceptedState()).metadata(updatedMetadata).build().writeTo((StreamOutput)outStream);
                            } else {
                                oldState.getLastAcceptedState().writeTo((StreamOutput)outStream);
                            }
                        }
                        NamedWriteableAwareStreamInput inStream = new NamedWriteableAwareStreamInput(outStream.bytes().streamInput(), new NamedWriteableRegistry(ClusterModule.getNamedWriteables()));
                        this.delegate = new InMemoryPersistedState(adaptCurrentTerm.apply(persistedCurrentTerm).longValue(), ClusterStateUpdaters.addStateNotRecoveredBlock((ClusterState)ClusterState.readFrom((StreamInput)inStream, (DiscoveryNode)newLocalNode)));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to create MockPersistedState", e);
                    }
                }
            }

            private void possiblyFail(String description) {
                if (Cluster.this.disruptStorage && LuceneTestCase.rarely()) {
                    AbstractCoordinatorTestCase.this.logger.trace("simulating IO exception [{}]", (Object)description);
                    throw new UncheckedIOException(new IOException("simulated IO exception [" + description + ']'));
                }
            }

            public long getCurrentTerm() {
                return this.delegate.getCurrentTerm();
            }

            public ClusterState getLastAcceptedState() {
                return this.delegate.getLastAcceptedState();
            }

            public void setCurrentTerm(long currentTerm) {
                this.possiblyFail("before writing term of " + currentTerm);
                this.delegate.setCurrentTerm(currentTerm);
            }

            public void setLastAcceptedState(ClusterState clusterState) {
                this.possiblyFail("before writing last-accepted state of term=" + clusterState.term() + ", version=" + clusterState.version());
                this.delegate.setLastAcceptedState(clusterState);
            }

            public void close() {
                Assert.assertTrue((boolean)AbstractCoordinatorTestCase.this.openPersistedStates.remove(this));
                try {
                    this.delegate.close();
                }
                catch (IOException e) {
                    throw new AssertionError("unexpected", e);
                }
            }
        }
    }

    static enum ClusterStateApplyResponse {
        SUCCEED,
        FAIL,
        HANG;

    }

    static class DisruptableClusterApplierService
    extends ClusterApplierService {
        private final String nodeName;
        private final DeterministicTaskQueue deterministicTaskQueue;
        ClusterStateApplyResponse clusterStateApplyResponse = ClusterStateApplyResponse.SUCCEED;
        private boolean applicationMayFail;

        DisruptableClusterApplierService(String nodeName, Settings settings, ClusterSettings clusterSettings, DeterministicTaskQueue deterministicTaskQueue, ThreadPool threadPool) {
            super(nodeName, settings, clusterSettings, threadPool);
            this.nodeName = nodeName;
            this.deterministicTaskQueue = deterministicTaskQueue;
            this.addStateApplier(event -> {
                switch (this.clusterStateApplyResponse) {
                    case SUCCEED: 
                    case HANG: {
                        ClusterState oldClusterState = event.previousState();
                        ClusterState newClusterState = event.state();
                        assert (oldClusterState.version() <= newClusterState.version()) : "updating cluster state from version " + oldClusterState.version() + " to stale version " + newClusterState.version();
                        break;
                    }
                    case FAIL: {
                        throw new ElasticsearchException("simulated cluster state applier failure", new Object[0]);
                    }
                }
            });
        }

        protected PrioritizedEsThreadPoolExecutor createThreadPoolExecutor() {
            return new MockSinglePrioritizingExecutor(this.nodeName, this.deterministicTaskQueue, this.threadPool);
        }

        public void onNewClusterState(String source, Supplier<ClusterState> clusterStateSupplier, ClusterApplier.ClusterApplyListener listener) {
            if (this.clusterStateApplyResponse == ClusterStateApplyResponse.HANG) {
                if (ESTestCase.randomBoolean()) {
                    super.onNewClusterState(source, clusterStateSupplier, (source1, e) -> {});
                }
            } else {
                super.onNewClusterState(source, clusterStateSupplier, listener);
            }
        }

        protected void connectToNodesAndWait(ClusterState newClusterState) {
        }

        protected boolean applicationMayFail() {
            return this.applicationMayFail;
        }

        void allowClusterStateApplicationFailure() {
            this.applicationMayFail = true;
        }
    }

    static class AckedFakeThreadPoolMasterService
    extends FakeThreadPoolMasterService {
        AckCollector nextAckCollector = new AckCollector();

        AckedFakeThreadPoolMasterService(String nodeName, String serviceName, ThreadPool threadPool, Consumer<Runnable> onTaskAvailableToRun) {
            super(nodeName, serviceName, threadPool, onTaskAvailableToRun);
        }

        @Override
        protected ClusterStatePublisher.AckListener wrapAckListener(final ClusterStatePublisher.AckListener ackListener) {
            final AckCollector ackCollector = this.nextAckCollector;
            this.nextAckCollector = new AckCollector();
            return new ClusterStatePublisher.AckListener(){

                public void onCommit(TimeValue commitTime) {
                    ackCollector.onCommit(commitTime);
                    ackListener.onCommit(commitTime);
                }

                public void onNodeAck(DiscoveryNode node, Exception e) {
                    ackCollector.onNodeAck(node, e);
                    ackListener.onNodeAck(node, e);
                }
            };
        }
    }

    static class AckCollector
    implements ClusterStatePublisher.AckListener {
        private final Set<DiscoveryNode> ackedNodes = new HashSet<DiscoveryNode>();
        private final List<DiscoveryNode> successfulNodes = new ArrayList<DiscoveryNode>();
        private final List<DiscoveryNode> unsuccessfulNodes = new ArrayList<DiscoveryNode>();

        AckCollector() {
        }

        public void onCommit(TimeValue commitTime) {
        }

        public void onNodeAck(DiscoveryNode node, Exception e) {
            Assert.assertTrue((String)("duplicate ack from " + node), (boolean)this.ackedNodes.add(node));
            if (e == null) {
                this.successfulNodes.add(node);
            } else {
                this.unsuccessfulNodes.add(node);
            }
        }

        boolean hasAckedSuccessfully(Cluster.ClusterNode clusterNode) {
            return this.successfulNodes.contains(clusterNode.localNode);
        }

        boolean hasAckedUnsuccessfully(Cluster.ClusterNode clusterNode) {
            return this.unsuccessfulNodes.contains(clusterNode.localNode);
        }

        boolean hasAcked(Cluster.ClusterNode clusterNode) {
            return this.ackedNodes.contains(clusterNode.localNode);
        }

        int getSuccessfulAckIndex(Cluster.ClusterNode clusterNode) {
            assert (this.successfulNodes.contains(clusterNode.localNode)) : "get index of " + clusterNode;
            return this.successfulNodes.indexOf(clusterNode.localNode);
        }
    }
}

