/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.Stream;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.logging.JsonLogLine;
import org.elasticsearch.common.logging.JsonLogsStream;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class JsonLogsIntegTestCase
extends ESRestTestCase {
    private static final int LINES_TO_CHECK = 10;

    protected abstract Matcher<String> nodeNameMatcher();

    protected abstract BufferedReader openReader(Path var1);

    public void testElementsPresentOnAllLinesOfLog() throws IOException {
        JsonLogLine firstLine = this.findFirstLine();
        JsonLogsIntegTestCase.assertNotNull((Object)firstLine);
        try (Stream<JsonLogLine> stream = JsonLogsStream.from(this.openReader(this.getLogFile()));){
            stream.limit(10L).forEach(jsonLogLine -> {
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.type(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.timestamp(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.level(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.component(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.message(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.nodeName(), this.nodeNameMatcher());
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.clusterName(), (Matcher)Matchers.equalTo((Object)firstLine.clusterName()));
            });
        }
    }

    private JsonLogLine findFirstLine() throws IOException {
        try (Stream<JsonLogLine> stream = JsonLogsStream.from(this.openReader(this.getLogFile()));){
            JsonLogLine jsonLogLine = stream.findFirst().orElseThrow(() -> new AssertionError((Object)"no logs at all?!"));
            return jsonLogLine;
        }
    }

    public void testNodeIdAndClusterIdConsistentOnceAvailable() throws IOException {
        try (Stream<JsonLogLine> stream = JsonLogsStream.from(this.openReader(this.getLogFile()));){
            Iterator iterator = stream.iterator();
            JsonLogLine firstLine = null;
            while (iterator.hasNext()) {
                JsonLogLine jsonLogLine = (JsonLogLine)iterator.next();
                if (jsonLogLine.nodeId() == null) continue;
                firstLine = jsonLogLine;
            }
            JsonLogsIntegTestCase.assertNotNull(firstLine);
            int i = 0;
            while (iterator.hasNext() && i++ < 10) {
                JsonLogLine jsonLogLine = (JsonLogLine)iterator.next();
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.nodeId(), (Matcher)Matchers.equalTo((Object)firstLine.nodeId()));
                JsonLogsIntegTestCase.assertThat((Object)jsonLogLine.clusterUuid(), (Matcher)Matchers.equalTo((Object)firstLine.clusterUuid()));
            }
        }
    }

    @SuppressForbidden(reason="PathUtils doesn't have permission to read this file")
    private Path getLogFile() {
        String logFileString = System.getProperty("tests.logfile");
        if (logFileString == null) {
            JsonLogsIntegTestCase.fail((String)"tests.logfile must be set to run this test. It is automatically set by gradle. If you must set it yourself then it should be the absolute path to the log file.");
        }
        return Paths.get(logFileString, new String[0]);
    }
}

