/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;

public class MockFieldMapper
extends FieldMapper {
    public MockFieldMapper(String fullName) {
        this((MappedFieldType)new FakeFieldType(fullName));
    }

    public MockFieldMapper(MappedFieldType fieldType) {
        this(fieldType, org.elasticsearch.common.collect.Map.of());
    }

    public MockFieldMapper(MappedFieldType fieldType, Map<String, NamedAnalyzer> indexAnalyzers) {
        super(MockFieldMapper.findSimpleName(fieldType.name()), fieldType, indexAnalyzers, FieldMapper.MultiFields.empty(), new FieldMapper.CopyTo.Builder().build());
    }

    public MockFieldMapper(String fullName, MappedFieldType fieldType, FieldMapper.MultiFields multifields, FieldMapper.CopyTo copyTo) {
        super(MockFieldMapper.findSimpleName(fullName), fieldType, multifields, copyTo);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName());
    }

    static String findSimpleName(String fullName) {
        int ndx = fullName.lastIndexOf(46);
        return fullName.substring(ndx + 1);
    }

    protected String contentType() {
        return null;
    }

    protected void parseCreateField(ParseContext context) {
    }

    public static class FakeFieldType
    extends TermBasedFieldType {
        public FakeFieldType(String name) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        public String typeName() {
            return "faketype";
        }

        public ValueFetcher valueFetcher(QueryShardContext context, String format) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final MappedFieldType fieldType;

        protected Builder(String name) {
            super(name);
            this.fieldType = new FakeFieldType(name);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.emptyList();
        }

        public Builder addMultiField(Builder builder) {
            this.multiFieldsBuilder.add((FieldMapper.Builder)builder);
            return this;
        }

        public Builder copyTo(String field) {
            this.copyTo.add(field);
            return this;
        }

        public MockFieldMapper build(ContentPath contentPath) {
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath);
            return new MockFieldMapper(this.name(), this.fieldType, multiFields, this.copyTo.build());
        }
    }
}

