/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.mockstore.MockRepository;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;

public abstract class AbstractSnapshotIntegTestCase
extends ESIntegTestCase {
    private static final String OLD_VERSION_SNAPSHOT_PREFIX = "old-version-snapshot-";
    protected static final Settings LARGE_SNAPSHOT_POOL_SETTINGS = Settings.builder().put("thread_pool.snapshot.core", 5).put("thread_pool.snapshot.max", 5).build();
    private String skipRepoConsistencyCheckReason;
    private static final Settings SINGLE_SHARD_NO_REPLICA = AbstractSnapshotIntegTestCase.indexSettingsNoReplicas(1).build();

    @Override
    protected Settings nodeSettings(int nodeOrdinal) {
        return Settings.builder().put(super.nodeSettings(nodeOrdinal)).put(EnableAllocationDecider.CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING.getKey(), (Enum)EnableAllocationDecider.Rebalance.NONE).build();
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Arrays.asList(MockRepository.Plugin.class);
    }

    @After
    public void assertConsistentHistoryInLuceneIndex() throws Exception {
        AbstractSnapshotIntegTestCase.internalCluster().assertConsistentHistoryBetweenTranslogAndLuceneIndex();
    }

    @After
    public void verifyNoLeakedListeners() throws Exception {
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (SnapshotsService snapshotsService : AbstractSnapshotIntegTestCase.internalCluster().getInstances(SnapshotsService.class)) {
                AbstractSnapshotIntegTestCase.assertTrue((boolean)snapshotsService.assertAllListenersResolved());
            }
        }), 30L, TimeUnit.SECONDS);
    }

    @After
    public void assertRepoConsistency() {
        if (this.skipRepoConsistencyCheckReason == null) {
            ((GetRepositoriesResponse)this.clusterAdmin().prepareGetRepositories(new String[0]).get()).repositories().forEach(repositoryMetadata -> {
                String name = repositoryMetadata.name();
                if (!repositoryMetadata.settings().getAsBoolean("readonly", Boolean.valueOf(false)).booleanValue()) {
                    this.clusterAdmin().prepareDeleteSnapshot(name, new String[]{"old-version-snapshot-*"}).get();
                    this.clusterAdmin().prepareCleanupRepository(name).get();
                }
                BlobStoreTestUtil.assertRepoConsistency(AbstractSnapshotIntegTestCase.internalCluster(), name);
            });
        } else {
            this.logger.info("--> skipped repo consistency checks because [{}]", (Object)this.skipRepoConsistencyCheckReason);
        }
    }

    protected void disableRepoConsistencyCheck(String reason) {
        AbstractSnapshotIntegTestCase.assertNotNull((Object)reason);
        this.skipRepoConsistencyCheckReason = reason;
    }

    protected RepositoryData getRepositoryData(String repository) {
        return this.getRepositoryData((Repository)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repository));
    }

    protected RepositoryData getRepositoryData(Repository repository) {
        return (RepositoryData)PlainActionFuture.get(arg_0 -> ((Repository)repository).getRepositoryData(arg_0));
    }

    public static long getFailureCount(String repository) {
        long failureCount = 0L;
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataOrMasterNodeInstances(RepositoriesService.class)) {
            MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
            failureCount += mockRepository.getFailureCount();
        }
        return failureCount;
    }

    public static void assertFileCount(Path dir, int expectedCount) throws IOException {
        ArrayList found = new ArrayList();
        AbstractSnapshotIntegTestCase.forEachFileRecursively(dir, (CheckedBiConsumer<Path, BasicFileAttributes, IOException>)((CheckedBiConsumer)(path, basicFileAttributes) -> found.add(path)));
        AbstractSnapshotIntegTestCase.assertEquals((String)("Unexpected file count, found: [" + found + "]."), (long)expectedCount, (long)found.size());
    }

    public static int numberOfFiles(Path dir) throws IOException {
        AtomicInteger count = new AtomicInteger();
        AbstractSnapshotIntegTestCase.forEachFileRecursively(dir, (CheckedBiConsumer<Path, BasicFileAttributes, IOException>)((CheckedBiConsumer)(path, basicFileAttributes) -> count.incrementAndGet()));
        return count.get();
    }

    protected void stopNode(String node) throws IOException {
        this.logger.info("--> stopping node {}", (Object)node);
        AbstractSnapshotIntegTestCase.internalCluster().stopRandomNode(settings -> settings.get("node.name").equals(node));
    }

    public void waitForBlock(String node, String repository) throws Exception {
        this.logger.info("--> waiting for [{}] to be blocked on node [{}]", (Object)repository, (Object)node);
        MockRepository mockRepository = (MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, node));
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSnapshotIntegTestCase.assertTrue((boolean)mockRepository.blocked())), 30L, TimeUnit.SECONDS);
    }

    public static void blockMasterFromFinalizingSnapshotOnIndexFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockAndFailOnWriteIndexFile();
    }

    public static void blockMasterOnWriteIndexFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockOnWriteIndexFile();
    }

    public static void blockMasterFromDeletingIndexNFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockOnDeleteIndexFile();
    }

    public static void blockMasterFromFinalizingSnapshotOnSnapFile(String repositoryName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repositoryName))).setBlockAndFailOnWriteSnapFiles();
    }

    protected static <T extends Repository> T getRepositoryOnMaster(String repositoryName) {
        return (T)AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(RepositoriesService.class).repository(repositoryName);
    }

    protected static <T extends Repository> T getRepositoryOnNode(String repositoryName, String nodeName) {
        return (T)AbstractSnapshotIntegTestCase.internalCluster().getInstance(RepositoriesService.class, nodeName).repository(repositoryName);
    }

    public static String blockNodeWithIndex(String repositoryName, String indexName) {
        Iterator<String> iterator = AbstractSnapshotIntegTestCase.internalCluster().nodesInclude(indexName).iterator();
        if (iterator.hasNext()) {
            String node = iterator.next();
            ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repositoryName, node))).blockOnDataFiles();
            return node;
        }
        AbstractSnapshotIntegTestCase.fail((String)("No nodes for the index " + indexName + " found"));
        return null;
    }

    public static void blockNodeOnAnyFiles(String repository, String nodeName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, nodeName))).setBlockOnAnyFiles();
    }

    public static void blockDataNode(String repository, String nodeName) {
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, nodeName))).blockOnDataFiles();
    }

    public static void blockAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            ((MockRepository)repositoriesService.repository(repository)).blockOnDataFiles();
        }
    }

    public static void unblockAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            ((MockRepository)repositoriesService.repository(repository)).unblock();
        }
    }

    public static void failReadsAllDataNodes(String repository) {
        for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
            MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
            mockRepository.setFailReadsAfterUnblock(true);
        }
    }

    public static void waitForBlockOnAnyDataNode(String repository) throws InterruptedException {
        boolean blocked = AbstractSnapshotIntegTestCase.waitUntil(() -> {
            for (RepositoriesService repositoriesService : AbstractSnapshotIntegTestCase.internalCluster().getDataNodeInstances(RepositoriesService.class)) {
                MockRepository mockRepository = (MockRepository)repositoriesService.repository(repository);
                if (!mockRepository.blocked()) continue;
                return true;
            }
            return false;
        }, 30L, TimeUnit.SECONDS);
        AbstractSnapshotIntegTestCase.assertTrue((String)"No repository is blocked waiting on a data node", (boolean)blocked);
    }

    public void unblockNode(String repository, String node) {
        this.logger.info("--> unblocking [{}] on node [{}]", (Object)repository, (Object)node);
        ((MockRepository)((Object)AbstractSnapshotIntegTestCase.getRepositoryOnNode(repository, node))).unblock();
    }

    protected void createRepository(String repoName, String type, Settings.Builder settings) {
        this.logger.info("--> creating repository [{}] [{}]", (Object)repoName, (Object)type);
        ElasticsearchAssertions.assertAcked(this.clusterAdmin().preparePutRepository(repoName).setType(type).setSettings(settings));
    }

    protected void createRepository(String repoName, String type, Path location) {
        this.createRepository(repoName, type, Settings.builder().put("location", location));
    }

    protected void createRepository(String repoName, String type) {
        this.createRepository(repoName, type, this.randomRepositorySettings());
    }

    protected Settings.Builder randomRepositorySettings() {
        Settings.Builder settings = Settings.builder();
        settings.put("location", this.randomRepoPath()).put("compress", AbstractSnapshotIntegTestCase.randomBoolean());
        if (AbstractSnapshotIntegTestCase.rarely()) {
            settings.put("chunk_size", (long)AbstractSnapshotIntegTestCase.randomIntBetween(100, 1000), ByteSizeUnit.BYTES);
        }
        return settings;
    }

    protected static Settings.Builder indexSettingsNoReplicas(int shards) {
        return Settings.builder().put("index.number_of_shards", shards).put("index.number_of_replicas", 0);
    }

    protected void maybeInitWithOldSnapshotVersion(String repoName, Path repoPath) throws IOException {
        if (AbstractSnapshotIntegTestCase.randomBoolean() && AbstractSnapshotIntegTestCase.randomBoolean()) {
            this.initWithSnapshotVersion(repoName, repoPath, VersionUtils.randomIndexCompatibleVersion(AbstractSnapshotIntegTestCase.random()));
        }
    }

    protected String initWithSnapshotVersion(String repoName, Path repoPath, Version version) throws IOException {
        AbstractSnapshotIntegTestCase.assertThat((String)"This hack only works on an empty repository", (Object)this.getRepositoryData(repoName).getSnapshotIds(), (Matcher)Matchers.empty());
        String oldVersionSnapshot = OLD_VERSION_SNAPSHOT_PREFIX + version.id;
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(repoName, oldVersionSnapshot).setIndices(new String[]{"does-not-exist-for-sure-*"}).setWaitForCompletion(true).get();
        SnapshotInfo snapshotInfo = createSnapshotResponse.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.totalShards(), (Matcher)Matchers.is((Object)0));
        this.logger.info("--> writing downgraded RepositoryData for repository metadata version [{}]", (Object)version);
        RepositoryData repositoryData = this.getRepositoryData(repoName);
        XContentBuilder jsonBuilder = JsonXContent.contentBuilder();
        repositoryData.snapshotsToXContent(jsonBuilder, version);
        RepositoryData downgradedRepoData = RepositoryData.snapshotsFromXContent((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, Strings.toString((XContentBuilder)jsonBuilder).replace(Version.CURRENT.toString(), version.toString())), (long)repositoryData.getGenId(), (boolean)AbstractSnapshotIntegTestCase.randomBoolean());
        Files.write(repoPath.resolve("index-" + repositoryData.getGenId()), BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)downgradedRepoData.snapshotsToXContent(XContentFactory.jsonBuilder(), version))), StandardOpenOption.TRUNCATE_EXISTING);
        SnapshotInfo downgradedSnapshotInfo = SnapshotInfo.fromXContentInternal((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, Strings.toString((ToXContent)snapshotInfo, (ToXContent.Params)ChecksumBlobStoreFormat.SNAPSHOT_ONLY_FORMAT_PARAMS).replace(String.valueOf(Version.CURRENT.id), String.valueOf(version.id))));
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repoName);
        PlainActionFuture.get(f -> blobStoreRepository.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)f, () -> BlobStoreRepository.SNAPSHOT_FORMAT.write((ToXContent)downgradedSnapshotInfo, blobStoreRepository.blobStore().blobContainer(blobStoreRepository.basePath()), snapshotInfo.snapshotId().getUUID(), AbstractSnapshotIntegTestCase.randomBoolean(), AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(BigArrays.class)))));
        return oldVersionSnapshot;
    }

    protected SnapshotInfo createFullSnapshot(String repoName, String snapshotName) {
        this.logger.info("--> creating full snapshot [{}] in [{}]", (Object)snapshotName, (Object)repoName);
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clusterAdmin().prepareCreateSnapshot(repoName, snapshotName).setIncludeGlobalState(true).setWaitForCompletion(true).get();
        SnapshotInfo snapshotInfo = createSnapshotResponse.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.successfulShards(), (Matcher)Matchers.is((Object)snapshotInfo.totalShards()));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        return snapshotInfo;
    }

    protected SnapshotInfo createSnapshot(String repositoryName, String snapshot, List<String> indices) {
        this.logger.info("--> creating snapshot [{}] of {} in [{}]", (Object)snapshot, indices, (Object)repositoryName);
        CreateSnapshotResponse response = (CreateSnapshotResponse)AbstractSnapshotIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repositoryName, snapshot).setIndices(indices.toArray(Strings.EMPTY_ARRAY)).setWaitForCompletion(true).get();
        SnapshotInfo snapshotInfo = response.getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.successfulShards(), (Matcher)Matchers.equalTo((Object)snapshotInfo.totalShards()));
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.failedShards(), (Matcher)Matchers.equalTo((Object)0));
        return snapshotInfo;
    }

    protected void createIndexWithRandomDocs(String indexName, int docCount) throws InterruptedException {
        this.createIndex(indexName);
        this.ensureGreen(new String[0]);
        this.indexRandomDocs(indexName, docCount);
    }

    protected void indexRandomDocs(String index, int numdocs) throws InterruptedException {
        this.logger.info("--> indexing [{}] documents into [{}]", (Object)numdocs, (Object)index);
        IndexRequestBuilder[] builders = new IndexRequestBuilder[numdocs];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = AbstractSnapshotIntegTestCase.client().prepareIndex(index, "_doc").setId(Integer.toString(i)).setSource(new Object[]{"field1", "bar " + i});
        }
        this.indexRandom(true, builders);
        this.flushAndRefresh(index);
        this.assertDocCount(index, numdocs);
    }

    protected long getCountForIndex(String indexName) {
        return ((SearchResponse)AbstractSnapshotIntegTestCase.client().search((SearchRequest)new SearchRequest((SearchRequest)new SearchRequest((String[])new String[]{indexName}).source((SearchSourceBuilder)new SearchSourceBuilder().size((int)0).trackTotalHits((boolean)true)))).actionGet()).getHits().getTotalHits().value;
    }

    protected void assertDocCount(String index, long count) {
        AbstractSnapshotIntegTestCase.assertEquals((long)this.getCountForIndex(index), (long)count);
    }

    protected void addBwCFailedSnapshot(String repoName, String snapshotName, Map<String, Object> metadata) throws Exception {
        ClusterState state = ((ClusterStateResponse)this.clusterAdmin().prepareState().get()).getState();
        RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)state.metadata().custom("repositories");
        AbstractSnapshotIntegTestCase.assertNotNull((Object)repositoriesMetadata);
        RepositoryMetadata initialRepoMetadata = repositoriesMetadata.repository(repoName);
        AbstractSnapshotIntegTestCase.assertNotNull((Object)initialRepoMetadata);
        AbstractSnapshotIntegTestCase.assertThat((String)"We can only manually insert a snapshot into a repository that does not have a generation tracked in the CS", (Object)initialRepoMetadata.generation(), (Matcher)Matchers.is((Object)-2L));
        Object repo = AbstractSnapshotIntegTestCase.getRepositoryOnMaster(repoName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID((Random)AbstractSnapshotIntegTestCase.random()));
        this.logger.info("--> adding old version FAILED snapshot [{}] to repository [{}]", (Object)snapshotId, (Object)repoName);
        SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotId, Collections.emptyList(), Collections.emptyList(), SnapshotState.FAILED, "failed on purpose", SnapshotsService.OLD_SNAPSHOT_FORMAT, 0L, 0L, 0, 0, Collections.emptyList(), Boolean.valueOf(AbstractSnapshotIntegTestCase.randomBoolean()), metadata);
        PlainActionFuture.get(f -> repo.finalizeSnapshot(ShardGenerations.EMPTY, this.getRepositoryData(repoName).getGenId(), state.metadata(), snapshotInfo, SnapshotsService.OLD_SNAPSHOT_FORMAT, Function.identity(), (ActionListener)f));
    }

    protected void awaitNDeletionsInProgress(int count) throws Exception {
        this.logger.info("--> wait for [{}] deletions to show up in the cluster state", (Object)count);
        this.awaitClusterState(state -> ((SnapshotDeletionsInProgress)state.custom("snapshot_deletions", (ClusterState.Custom)SnapshotDeletionsInProgress.EMPTY)).getEntries().size() == count);
    }

    protected void awaitNoMoreRunningOperations() throws Exception {
        this.awaitNoMoreRunningOperations(AbstractSnapshotIntegTestCase.internalCluster().getMasterName());
    }

    protected void awaitNoMoreRunningOperations(String viaNode) throws Exception {
        this.logger.info("--> verify no more operations in the cluster state");
        this.awaitClusterState(viaNode, state -> ((SnapshotsInProgress)state.custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY)).entries().isEmpty() && !((SnapshotDeletionsInProgress)state.custom("snapshot_deletions", (ClusterState.Custom)SnapshotDeletionsInProgress.EMPTY)).hasDeletionsInProgress());
    }

    protected void awaitClusterState(Predicate<ClusterState> statePredicate) throws Exception {
        this.awaitClusterState(AbstractSnapshotIntegTestCase.internalCluster().getMasterName(), statePredicate);
    }

    protected void awaitClusterState(String viaNode, Predicate<ClusterState> statePredicate) throws Exception {
        ThreadPool threadPool;
        final ClusterService clusterService = AbstractSnapshotIntegTestCase.internalCluster().getInstance(ClusterService.class, viaNode);
        ClusterStateObserver observer = new ClusterStateObserver(clusterService, this.logger, (threadPool = AbstractSnapshotIntegTestCase.internalCluster().getInstance(ThreadPool.class, viaNode)).getThreadContext());
        if (!statePredicate.test(observer.setAndGetObservedState())) {
            final PlainActionFuture future = PlainActionFuture.newFuture();
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    future.onResponse(null);
                }

                public void onClusterServiceClose() {
                    future.onFailure((Exception)new NodeClosedException(clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    future.onFailure((Exception)new TimeoutException());
                }
            }, statePredicate);
            future.get(30L, TimeUnit.SECONDS);
        }
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshotBlockedOnDataNode(String snapshotName, String repoName, String dataNode) throws Exception {
        AbstractSnapshotIntegTestCase.blockDataNode(repoName, dataNode);
        ActionFuture<CreateSnapshotResponse> fut = this.startFullSnapshot(repoName, snapshotName);
        this.waitForBlock(dataNode, repoName);
        return fut;
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshot(String repoName, String snapshotName) {
        return this.startFullSnapshot(repoName, snapshotName, false);
    }

    protected ActionFuture<CreateSnapshotResponse> startFullSnapshot(String repoName, String snapshotName, boolean partial) {
        this.logger.info("--> creating full snapshot [{}] to repo [{}]", (Object)snapshotName, (Object)repoName);
        return this.clusterAdmin().prepareCreateSnapshot(repoName, snapshotName).setWaitForCompletion(true).setPartial(partial).execute();
    }

    protected void awaitNumberOfSnapshotsInProgress(int count) throws Exception {
        this.logger.info("--> wait for [{}] snapshots to show up in the cluster state", (Object)count);
        this.awaitClusterState(state -> ((SnapshotsInProgress)state.custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY)).entries().size() == count);
    }

    protected SnapshotInfo assertSuccessful(ActionFuture<CreateSnapshotResponse> future) throws Exception {
        this.logger.info("--> wait for snapshot to finish");
        SnapshotInfo snapshotInfo = ((CreateSnapshotResponse)future.get()).getSnapshotInfo();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        return snapshotInfo;
    }

    protected void createIndexWithContent(String indexName) {
        this.createIndexWithContent(indexName, SINGLE_SHARD_NO_REPLICA);
    }

    protected void createIndexWithContent(String indexName, Settings indexSettings) {
        this.logger.info("--> creating index [{}]", (Object)indexName);
        this.createIndex(indexName, indexSettings);
        this.ensureGreen(indexName);
        this.index(indexName, "_doc", "some_id", "foo", "bar");
    }

    protected ActionFuture<AcknowledgedResponse> startDeleteSnapshot(String repoName, String snapshotName) {
        this.logger.info("--> deleting snapshot [{}] from repo [{}]", (Object)snapshotName, (Object)repoName);
        return this.clusterAdmin().prepareDeleteSnapshot(repoName, new String[]{snapshotName}).execute();
    }

    protected void updateClusterState(final Function<ClusterState, ClusterState> updater) throws Exception {
        final PlainActionFuture future = PlainActionFuture.newFuture();
        ClusterService clusterService = AbstractSnapshotIntegTestCase.internalCluster().getCurrentMasterNodeInstance(ClusterService.class);
        clusterService.submitStateUpdateTask("test", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                return (ClusterState)updater.apply(currentState);
            }

            public void onFailure(String source, Exception e) {
                future.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                future.onResponse(null);
            }
        });
        future.get();
    }

    protected SnapshotInfo getSnapshot(String repository, String snapshot) {
        List snapshotInfos = ((GetSnapshotsResponse)this.clusterAdmin().prepareGetSnapshots(repository).setSnapshots(new String[]{snapshot}).get()).getSnapshots();
        AbstractSnapshotIntegTestCase.assertThat((Object)snapshotInfos, (Matcher)Matchers.hasSize((int)1));
        return (SnapshotInfo)snapshotInfos.get(0);
    }

    protected static ThreadPoolStats.Stats snapshotThreadPoolStats(String node) {
        return StreamSupport.stream(AbstractSnapshotIntegTestCase.internalCluster().getInstance(ThreadPool.class, node).stats().spliterator(), false).filter(threadPool -> threadPool.getName().equals("snapshot")).findFirst().orElseThrow(() -> new AssertionError((Object)("Failed to find snapshot pool on node [" + node + "]")));
    }

    protected void awaitMasterFinishRepoOperations() throws Exception {
        this.logger.info("--> waiting for master to finish all repo operations on its SNAPSHOT pool");
        String masterName = AbstractSnapshotIntegTestCase.internalCluster().getMasterName();
        AbstractSnapshotIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSnapshotIntegTestCase.assertEquals((long)AbstractSnapshotIntegTestCase.snapshotThreadPoolStats(masterName).getActive(), (long)0L)));
    }

    protected List<String> createNSnapshots(String repoName, int count) throws Exception {
        PlainActionFuture allSnapshotsDone = PlainActionFuture.newFuture();
        GroupedActionListener snapshotsListener = new GroupedActionListener((ActionListener)allSnapshotsDone, count);
        ArrayList<String> snapshotNames = new ArrayList<String>(count);
        String prefix = "snap-" + UUIDs.randomBase64UUID((Random)AbstractSnapshotIntegTestCase.random()).toLowerCase(Locale.ROOT) + "-";
        for (int i = 0; i < count; ++i) {
            String snapshot = prefix + i;
            snapshotNames.add(snapshot);
            AbstractSnapshotIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repoName, snapshot).setWaitForCompletion(true).execute((ActionListener)snapshotsListener);
        }
        for (CreateSnapshotResponse snapshotResponse : (Collection)allSnapshotsDone.get()) {
            AbstractSnapshotIntegTestCase.assertThat((Object)snapshotResponse.getSnapshotInfo().state(), (Matcher)Matchers.is((Object)SnapshotState.SUCCESS));
        }
        this.logger.info("--> created {} in [{}]", snapshotNames, (Object)repoName);
        return snapshotNames;
    }

    public static void forEachFileRecursively(Path path, final CheckedBiConsumer<Path, BasicFileAttributes, IOException> forEach) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                forEach.accept((Object)file, (Object)attrs);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

