/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots.mockstore;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.blobstore.support.FilterBlobContainer;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.snapshots.mockstore.BlobStoreWrapper;

public class MockRepository
extends FsRepository {
    private static final Logger logger = LogManager.getLogger(MockRepository.class);
    private final AtomicLong failureCounter = new AtomicLong();
    private final double randomControlIOExceptionRate;
    private final double randomDataFileIOExceptionRate;
    private final boolean useLuceneCorruptionException;
    private final long maximumNumberOfFailures;
    private final long waitAfterUnblock;
    private final String randomPrefix;
    private final Environment env;
    private volatile boolean blockOnAnyFiles;
    private volatile boolean blockOnDataFiles;
    private volatile boolean blockOnDeleteIndexN;
    private volatile boolean blockAndFailOnWriteIndexFile;
    private volatile boolean blockOnWriteIndexFile;
    private volatile boolean blockAndFailOnWriteSnapFile;
    private volatile boolean blockOnWriteShardLevelMeta;
    private volatile boolean blockOnReadIndexMeta;
    private final AtomicBoolean blockOnceOnReadSnapshotInfo = new AtomicBoolean(false);
    private volatile boolean failOnIndexLatest = false;
    private volatile boolean failReadsAfterUnblock;
    private volatile boolean throwReadErrorAfterUnblock = false;
    private volatile boolean blocked = false;

    public long getFailureCount() {
        return this.failureCounter.get();
    }

    public MockRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        super(MockRepository.overrideSettings(metadata, environment), environment, namedXContentRegistry, clusterService, bigArrays, recoverySettings);
        this.randomControlIOExceptionRate = metadata.settings().getAsDouble("random_control_io_exception_rate", Double.valueOf(0.0));
        this.randomDataFileIOExceptionRate = metadata.settings().getAsDouble("random_data_file_io_exception_rate", Double.valueOf(0.0));
        this.useLuceneCorruptionException = metadata.settings().getAsBoolean("use_lucene_corruption", Boolean.valueOf(false));
        this.maximumNumberOfFailures = metadata.settings().getAsLong("max_failure_number", Long.valueOf(100L));
        this.blockOnAnyFiles = metadata.settings().getAsBoolean("block_on_control", Boolean.valueOf(false));
        this.blockOnDataFiles = metadata.settings().getAsBoolean("block_on_data", Boolean.valueOf(false));
        this.blockAndFailOnWriteSnapFile = metadata.settings().getAsBoolean("block_on_snap", Boolean.valueOf(false));
        this.randomPrefix = metadata.settings().get("random", "default");
        this.waitAfterUnblock = metadata.settings().getAsLong("wait_after_unblock", Long.valueOf(0L));
        this.env = environment;
        logger.info("starting mock repository with random prefix {}", (Object)this.randomPrefix);
    }

    public RepositoryMetadata getMetadata() {
        return MockRepository.overrideSettings(super.getMetadata(), this.env);
    }

    private static RepositoryMetadata overrideSettings(RepositoryMetadata metadata, Environment environment) {
        if (metadata.settings().getAsBoolean("localize_location", Boolean.valueOf(false)).booleanValue()) {
            Path location = PathUtils.get((String)metadata.settings().get("location"), (String[])new String[0]);
            location = location.resolve(Integer.toString(environment.hashCode()));
            return new RepositoryMetadata(metadata.name(), metadata.type(), Settings.builder().put(metadata.settings()).put("location", location.toAbsolutePath()).build());
        }
        return metadata;
    }

    private long incrementAndGetFailureCount() {
        return this.failureCounter.incrementAndGet();
    }

    protected void doStop() {
        this.unblock();
        super.doStop();
    }

    protected BlobStore createBlobStore() throws Exception {
        return new MockBlobStore(super.createBlobStore());
    }

    public synchronized void unblock() {
        this.blocked = false;
        this.blockOnDataFiles = false;
        this.blockOnAnyFiles = false;
        this.blockAndFailOnWriteIndexFile = false;
        this.blockOnWriteIndexFile = false;
        this.blockAndFailOnWriteSnapFile = false;
        this.blockOnDeleteIndexN = false;
        this.blockOnWriteShardLevelMeta = false;
        this.blockOnReadIndexMeta = false;
        this.blockOnceOnReadSnapshotInfo.set(false);
        ((Object)((Object)this)).notifyAll();
    }

    public void blockOnDataFiles() {
        this.blockOnDataFiles = true;
    }

    public void setBlockOnAnyFiles() {
        this.blockOnAnyFiles = true;
    }

    public void setBlockAndFailOnWriteSnapFiles() {
        this.blockAndFailOnWriteSnapFile = true;
    }

    public void setBlockAndFailOnWriteIndexFile() {
        assert (!this.blockOnWriteIndexFile) : "Either fail or wait after blocking on index-N not both";
        this.blockAndFailOnWriteIndexFile = true;
    }

    public void setBlockOnWriteIndexFile() {
        assert (!this.blockAndFailOnWriteIndexFile) : "Either fail or wait after blocking on index-N not both";
        this.blockOnWriteIndexFile = true;
    }

    public void setBlockOnDeleteIndexFile() {
        this.blockOnDeleteIndexN = true;
    }

    public void setBlockOnWriteShardLevelMeta() {
        this.blockOnWriteShardLevelMeta = true;
    }

    public void setBlockOnReadIndexMeta() {
        this.blockOnReadIndexMeta = true;
    }

    public void setFailReadsAfterUnblock(boolean failReadsAfterUnblock) {
        this.failReadsAfterUnblock = failReadsAfterUnblock;
    }

    public void setBlockOnceOnReadSnapshotInfoIfAlreadyBlocked() {
        this.blockOnceOnReadSnapshotInfo.set(true);
    }

    public boolean blocked() {
        return this.blocked;
    }

    public void setFailOnIndexLatest(boolean failOnIndexLatest) {
        this.failOnIndexLatest = failOnIndexLatest;
    }

    private synchronized boolean blockExecution() {
        logger.debug("[{}] Blocking execution", (Object)this.metadata.name());
        boolean wasBlocked = false;
        try {
            while (this.blockOnDataFiles || this.blockOnAnyFiles || this.blockAndFailOnWriteIndexFile || this.blockOnWriteIndexFile || this.blockAndFailOnWriteSnapFile || this.blockOnDeleteIndexN || this.blockOnWriteShardLevelMeta || this.blockOnReadIndexMeta) {
                this.blocked = true;
                ((Object)((Object)this)).wait();
                wasBlocked = true;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        logger.debug("[{}] Unblocking execution", (Object)this.metadata.name());
        if (wasBlocked && this.failReadsAfterUnblock) {
            logger.debug("[{}] Next read operations will fail", (Object)this.metadata.name());
            this.throwReadErrorAfterUnblock = true;
        }
        return wasBlocked;
    }

    public class MockBlobStore
    extends BlobStoreWrapper {
        ConcurrentMap<String, AtomicLong> accessCounts;

        private long incrementAndGet(String path) {
            AtomicLong value = (AtomicLong)this.accessCounts.get(path);
            if (value == null) {
                value = this.accessCounts.putIfAbsent(path, new AtomicLong(1L));
            }
            if (value != null) {
                return value.incrementAndGet();
            }
            return 1L;
        }

        public MockBlobStore(BlobStore delegate) {
            super(delegate);
            this.accessCounts = new ConcurrentHashMap<String, AtomicLong>();
        }

        @Override
        public BlobContainer blobContainer(BlobPath path) {
            return new MockBlobContainer(super.blobContainer(path));
        }

        private class MockBlobContainer
        extends FilterBlobContainer {
            private boolean shouldFail(String blobName, double probability) {
                if (probability > 0.0) {
                    String path = this.path().add(blobName).buildAsString() + MockRepository.this.randomPrefix;
                    path = path + "/" + MockBlobStore.this.incrementAndGet(path);
                    logger.info("checking [{}] [{}]", (Object)path, (Object)((double)Math.abs(this.hashCode(path)) < 2.147483647E9 * probability ? 1 : 0));
                    return (double)Math.abs(this.hashCode(path)) < 2.147483647E9 * probability;
                }
                return false;
            }

            private int hashCode(String path) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    byte[] bytes = digest.digest(path.getBytes("UTF-8"));
                    int i = 0;
                    return (bytes[i++] & 0xFF) << 24 | (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
                }
                catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
                    throw new ElasticsearchException("cannot calculate hashcode", (Throwable)ex, new Object[0]);
                }
            }

            private void maybeIOExceptionOrBlock(String blobName) throws IOException {
                if ("index.latest".equals(blobName)) {
                    return;
                }
                if (blobName.startsWith("__")) {
                    if (this.shouldFail(blobName, MockRepository.this.randomDataFileIOExceptionRate) && MockRepository.this.incrementAndGetFailureCount() < MockRepository.this.maximumNumberOfFailures) {
                        logger.info("throwing random IOException for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                        if (MockRepository.this.useLuceneCorruptionException) {
                            throw new CorruptIndexException("Random corruption", "random file");
                        }
                        throw new IOException("Random IOException");
                    }
                    if (MockRepository.this.blockOnDataFiles) {
                        this.blockExecutionAndMaybeWait(blobName);
                    }
                } else {
                    if (this.shouldFail(blobName, MockRepository.this.randomControlIOExceptionRate) && MockRepository.this.incrementAndGetFailureCount() < MockRepository.this.maximumNumberOfFailures) {
                        logger.info("throwing random IOException for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                        throw new IOException("Random IOException");
                    }
                    if (MockRepository.this.blockOnAnyFiles) {
                        this.blockExecutionAndMaybeWait(blobName);
                    } else if (blobName.startsWith("snap-") && MockRepository.this.blockAndFailOnWriteSnapFile) {
                        this.blockExecutionAndFail(blobName);
                    }
                }
            }

            private void blockExecutionAndMaybeWait(String blobName) throws IOException {
                logger.info("[{}] blocking I/O operation for file [{}] at path [{}]", (Object)MockRepository.this.metadata.name(), (Object)blobName, (Object)this.path());
                boolean wasBlocked = MockRepository.this.blockExecution();
                if (wasBlocked && MockRepository.this.lifecycle.stoppedOrClosed()) {
                    throw new IOException("already closed");
                }
                if (wasBlocked && MockRepository.this.waitAfterUnblock > 0L) {
                    try {
                        Thread.sleep(MockRepository.this.waitAfterUnblock);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            private void blockExecutionAndFail(String blobName) throws IOException {
                logger.info("blocking I/O operation for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                MockRepository.this.blockExecution();
                throw new IOException("exception after block");
            }

            private void maybeReadErrorAfterBlock(String blobName) {
                if (MockRepository.this.throwReadErrorAfterUnblock) {
                    throw new AssertionError((Object)("Read operation are not allowed anymore at this point [blob=" + blobName + "]"));
                }
            }

            MockBlobContainer(BlobContainer delegate) {
                super(delegate);
            }

            protected BlobContainer wrapChild(BlobContainer child) {
                return new MockBlobContainer(child);
            }

            public InputStream readBlob(String name) throws IOException {
                if (MockRepository.this.blockOnReadIndexMeta && name.startsWith("meta-") && !this.path().equals(MockRepository.this.basePath())) {
                    this.blockExecutionAndMaybeWait(name);
                } else if (this.path().equals(MockRepository.this.basePath()) && name.startsWith("snap-") && MockRepository.this.blockOnceOnReadSnapshotInfo.compareAndSet(true, false)) {
                    this.blockExecutionAndMaybeWait(name);
                } else {
                    this.maybeReadErrorAfterBlock(name);
                    this.maybeIOExceptionOrBlock(name);
                }
                return super.readBlob(name);
            }

            public InputStream readBlob(String name, long position, long length) throws IOException {
                this.maybeReadErrorAfterBlock(name);
                this.maybeIOExceptionOrBlock(name);
                return super.readBlob(name, position, length);
            }

            public DeleteResult delete() throws IOException {
                DeleteResult deleteResult = DeleteResult.ZERO;
                for (BlobContainer child : this.children().values()) {
                    deleteResult = deleteResult.add(child.delete());
                }
                Map<String, BlobMetadata> blobs = this.listBlobs();
                long deleteBlobCount = blobs.size();
                long deleteByteCount = 0L;
                for (String blob : blobs.values().stream().map(BlobMetadata::name).collect(Collectors.toList())) {
                    this.maybeIOExceptionOrBlock(blob);
                    this.deleteBlobsIgnoringIfNotExists(Collections.singletonList(blob));
                    deleteByteCount += blobs.get(blob).length();
                }
                MockRepository.this.blobStore().blobContainer(this.path().parent()).deleteBlobsIgnoringIfNotExists(Collections.singletonList(this.path().toArray()[this.path().toArray().length - 1]));
                return deleteResult.add(deleteBlobCount, deleteByteCount);
            }

            public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
                if (MockRepository.this.blockOnDeleteIndexN && blobNames.stream().anyMatch(name -> name.startsWith("index-"))) {
                    this.blockExecutionAndMaybeWait("index-{N}");
                }
                super.deleteBlobsIgnoringIfNotExists(blobNames);
            }

            public Map<String, BlobMetadata> listBlobs() throws IOException {
                this.maybeIOExceptionOrBlock("");
                return super.listBlobs();
            }

            public Map<String, BlobContainer> children() throws IOException {
                HashMap<String, BlobContainer> res = new HashMap<String, BlobContainer>();
                for (Map.Entry entry : super.children().entrySet()) {
                    res.put((String)entry.getKey(), (BlobContainer)new MockBlobContainer((BlobContainer)entry.getValue()));
                }
                return res;
            }

            public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
                this.maybeIOExceptionOrBlock(blobNamePrefix);
                return super.listBlobsByPrefix(blobNamePrefix);
            }

            public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
                this.maybeIOExceptionOrBlock(blobName);
                if (MockRepository.this.blockOnWriteShardLevelMeta && blobName.startsWith("snap-") && !this.path().equals(MockRepository.this.basePath())) {
                    this.blockExecutionAndMaybeWait(blobName);
                }
                super.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
                if (RandomizedContext.current().getRandom().nextBoolean()) {
                    this.maybeIOExceptionOrBlock(blobName);
                }
            }

            public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
                Random random = RandomizedContext.current().getRandom();
                if (MockRepository.this.failOnIndexLatest && "index.latest".equals(blobName)) {
                    throw new IOException("Random IOException");
                }
                if (blobName.startsWith("index-")) {
                    if (MockRepository.this.blockAndFailOnWriteIndexFile) {
                        this.blockExecutionAndFail(blobName);
                    } else if (MockRepository.this.blockOnWriteIndexFile) {
                        this.blockExecutionAndMaybeWait(blobName);
                    }
                }
                if (MockBlobStore.this.delegate() instanceof FsBlobContainer && random.nextBoolean()) {
                    String tempBlobName = FsBlobContainer.tempBlobName((String)blobName);
                    super.writeBlob(tempBlobName, inputStream, blobSize, failIfAlreadyExists);
                    this.maybeIOExceptionOrBlock(blobName);
                    FsBlobContainer fsBlobContainer = (FsBlobContainer)MockBlobStore.this.delegate();
                    fsBlobContainer.moveBlobAtomic(tempBlobName, blobName, failIfAlreadyExists);
                } else {
                    this.maybeIOExceptionOrBlock(blobName);
                    super.writeBlobAtomic(blobName, inputStream, blobSize, failIfAlreadyExists);
                }
            }
        }
    }

    public static class Plugin
    extends org.elasticsearch.plugins.Plugin
    implements RepositoryPlugin {
        public static final Setting<String> USERNAME_SETTING = Setting.simpleString((String)"secret.mock.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> PASSWORD_SETTING = Setting.simpleString((String)"secret.mock.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});

        public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
            return Collections.singletonMap("mock", metadata -> new MockRepository(metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings));
        }

        public List<Setting<?>> getSettings() {
            return Arrays.asList(USERNAME_SETTING, PASSWORD_SETTING);
        }
    }
}

