/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.NestedDocuments;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public class TestSearchContext
extends SearchContext {
    public static final SearchShardTarget SHARD_TARGET = new SearchShardTarget("test", new ShardId("test", "test", 0), null, OriginalIndices.NONE);
    final IndexService indexService;
    final BitsetFilterCache fixedBitSetFilterCache;
    final Map<Class<?>, Collector> queryCollectors = new HashMap();
    final IndexShard indexShard;
    final QuerySearchResult queryResult = new QuerySearchResult();
    final QueryShardContext queryShardContext;
    ParsedQuery originalQuery;
    ParsedQuery postFilter;
    Query query;
    Float minScore;
    SearchShardTask task;
    SortAndFormats sort;
    boolean trackScores = false;
    int trackTotalHitsUpTo = 10000;
    ContextIndexSearcher searcher;
    int from;
    int size;
    private int terminateAfter = 0;
    private SearchContextAggregations aggregations;
    private ScrollContext scrollContext;
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();

    public TestSearchContext(IndexService indexService) {
        this.indexService = indexService;
        this.fixedBitSetFilterCache = indexService.cache().bitsetFilterCache();
        this.indexShard = indexService.getShardOrNull(0);
        this.queryShardContext = indexService.newQueryShardContext(0, null, () -> 0L, null, Collections.emptyMap());
    }

    public TestSearchContext(QueryShardContext queryShardContext) {
        this(queryShardContext, null, null, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext, IndexShard indexShard, ContextIndexSearcher searcher) {
        this(queryShardContext, indexShard, searcher, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext, IndexShard indexShard, ContextIndexSearcher searcher, ScrollContext scrollContext) {
        this.indexService = null;
        this.fixedBitSetFilterCache = null;
        this.indexShard = indexShard;
        this.queryShardContext = queryShardContext;
        this.searcher = searcher;
        this.scrollContext = scrollContext;
    }

    public void setSearcher(ContextIndexSearcher searcher) {
        this.searcher = searcher;
    }

    public void preProcess(boolean rewrite) {
    }

    public Query buildFilteredQuery(Query query) {
        return null;
    }

    public ShardSearchContextId id() {
        return new ShardSearchContextId("", 0L);
    }

    public String source() {
        return null;
    }

    public ShardSearchRequest request() {
        return null;
    }

    public SearchType searchType() {
        return null;
    }

    public SearchShardTarget shardTarget() {
        return null;
    }

    public int numberOfShards() {
        return 1;
    }

    public ScrollContext scrollContext() {
        return this.scrollContext;
    }

    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    public SearchHighlightContext highlight() {
        return null;
    }

    public void highlight(SearchHighlightContext highlight) {
    }

    public SuggestionSearchContext suggest() {
        return null;
    }

    public void suggest(SuggestionSearchContext suggest) {
    }

    public List<RescoreContext> rescore() {
        return Collections.emptyList();
    }

    public boolean hasScriptFields() {
        return false;
    }

    public ScriptFieldsContext scriptFields() {
        return null;
    }

    public boolean sourceRequested() {
        return false;
    }

    public boolean hasFetchSourceContext() {
        return false;
    }

    public FetchSourceContext fetchSourceContext() {
        return null;
    }

    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        return null;
    }

    public FetchDocValuesContext docValuesContext() {
        return null;
    }

    public SearchContext docValuesContext(FetchDocValuesContext docValuesContext) {
        return null;
    }

    public FetchFieldsContext fetchFieldsContext() {
        return null;
    }

    public SearchContext fetchFieldsContext(FetchFieldsContext fetchFieldsContext) {
        return null;
    }

    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.fixedBitSetFilterCache;
    }

    public TimeValue timeout() {
        return TimeValue.ZERO;
    }

    public void timeout(TimeValue timeout) {
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    public boolean lowLevelCancellation() {
        return false;
    }

    public SearchContext minimumScore(float minimumScore) {
        this.minScore = Float.valueOf(minimumScore);
        return this;
    }

    public Float minimumScore() {
        return this.minScore;
    }

    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    public SortAndFormats sort() {
        return this.sort;
    }

    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public SearchContext trackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this;
    }

    public int trackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    public SearchContext searchAfter(FieldDoc searchAfter) {
        return null;
    }

    public FieldDoc searchAfter() {
        return null;
    }

    public SearchContext collapse(CollapseContext collapse) {
        return null;
    }

    public CollapseContext collapse() {
        return null;
    }

    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    public Query query() {
        return this.query;
    }

    public int from() {
        return this.from;
    }

    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public SearchContext size(int size) {
        return null;
    }

    public boolean hasStoredFields() {
        return false;
    }

    public StoredFieldsContext storedFieldsContext() {
        return null;
    }

    public SearchContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        return null;
    }

    public boolean explain() {
        return false;
    }

    public void explain(boolean explain) {
    }

    public List<String> groupStats() {
        return null;
    }

    public void groupStats(List<String> groupStats) {
    }

    public boolean version() {
        return false;
    }

    public void version(boolean version) {
    }

    public boolean seqNoAndPrimaryTerm() {
        return false;
    }

    public void seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
    }

    public int[] docIdsToLoad() {
        return new int[0];
    }

    public int docIdsToLoadSize() {
        return 0;
    }

    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadSize) {
        return null;
    }

    public DfsSearchResult dfsResult() {
        return null;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public FetchSearchResult fetchResult() {
        return null;
    }

    public NestedDocuments getNestedDocuments() {
        return new NestedDocuments(this.indexService.mapperService(), arg_0 -> ((BitsetFilterCache)this.bitsetFilterCache()).getBitSetProducer(arg_0));
    }

    public FetchPhase fetchPhase() {
        return null;
    }

    public long getRelativeTimeInMillis() {
        return 0L;
    }

    public Profilers getProfilers() {
        return null;
    }

    public Map<Class<?>, Collector> queryCollectors() {
        return this.queryCollectors;
    }

    public QueryShardContext getQueryShardContext() {
        return this.queryShardContext;
    }

    public void setTask(SearchShardTask task) {
        this.task = task;
    }

    public SearchShardTask getTask() {
        return this.task;
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    public void addRescore(RescoreContext rescore) {
    }

    public ReaderContext readerContext() {
        throw new UnsupportedOperationException();
    }
}

