/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.WarningsHandler;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Set;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.rest.yaml.ObjectPath;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class ESRestTestCase
extends ESTestCase {
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String CERTIFICATE_AUTHORITIES = "certificate_authorities";
    public static final String CLIENT_CERT_PATH = "client.cert.path";
    public static final String CLIENT_KEY_PATH = "client.key.path";
    public static final String CLIENT_KEY_PASSWORD = "client.key.password";
    public static final String CLIENT_SOCKET_TIMEOUT = "client.socket.timeout";
    public static final String CLIENT_PATH_PREFIX = "client.path.prefix";
    private static List<HttpHost> clusterHosts;
    private static RestClient client;
    private static RestClient adminClient;
    private static Boolean hasXPack;
    private static TreeSet<Version> nodeVersions;
    static final Pattern CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES;
    static final Pattern PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES;

    public static Map<String, Object> entityAsMap(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, response.getEntity().getContent());){
            Map map = parser.map();
            return map;
        }
    }

    public static List<Object> entityAsList(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, response.getEntity().getContent());){
            List list = parser.list();
            return list;
        }
    }

    public static boolean hasXPack() {
        if (hasXPack == null) {
            throw new IllegalStateException("must be called inside of a rest test case test");
        }
        return hasXPack;
    }

    @Before
    public void initClient() throws IOException {
        if (client == null) {
            assert (adminClient == null);
            assert (clusterHosts == null);
            assert (hasXPack == null);
            assert (nodeVersions == null);
            String cluster = this.getTestRestCluster();
            String[] stringUrls = cluster.split(",");
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
            for (String stringUrl : stringUrls) {
                int portSeparator = stringUrl.lastIndexOf(58);
                if (portSeparator < 0) {
                    throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
                }
                String host = stringUrl.substring(0, portSeparator);
                int port = Integer.valueOf(stringUrl.substring(portSeparator + 1));
                hosts.add(this.buildHttpHost(host, port));
            }
            clusterHosts = Collections.unmodifiableList(hosts);
            this.logger.info("initializing REST clients against {}", clusterHosts);
            client = this.buildClient(this.restClientSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            adminClient = this.buildClient(this.restAdminSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            hasXPack = false;
            nodeVersions = new TreeSet();
            Map<String, Object> response = ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "_nodes/plugins")));
            Map nodes = (Map)response.get("nodes");
            for (Map.Entry node : nodes.entrySet()) {
                Map nodeInfo = (Map)node.getValue();
                nodeVersions.add(Version.fromString((String)nodeInfo.get("version").toString()));
                for (Object module : (List)nodeInfo.get("modules")) {
                    Map moduleInfo = (Map)module;
                    if (!moduleInfo.get("name").toString().startsWith("x-pack-")) continue;
                    hasXPack = true;
                }
            }
        }
        assert (client != null);
        assert (adminClient != null);
        assert (clusterHosts != null);
        assert (hasXPack != null);
        assert (nodeVersions != null);
    }

    protected String getTestRestCluster() {
        String cluster = System.getProperty("tests.rest.cluster");
        if (cluster == null) {
            throw new RuntimeException("Must specify [tests.rest.cluster] system property with a comma delimited list of [host:port] to which to send REST requests");
        }
        return cluster;
    }

    public static RequestOptions expectVersionSpecificWarnings(Consumer<VersionSensitiveWarningsHandler> expectationsSetter) {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        VersionSensitiveWarningsHandler warningsHandler = new VersionSensitiveWarningsHandler(nodeVersions);
        expectationsSetter.accept(warningsHandler);
        builder.setWarningsHandler((WarningsHandler)warningsHandler);
        return builder.build();
    }

    public static RequestOptions expectWarnings(String ... warnings) {
        return ESRestTestCase.expectVersionSpecificWarnings(consumer -> consumer.current(warnings));
    }

    @Deprecated
    public static RequestOptions allowTypesRemovalWarnings() {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setWarningsHandler(new WarningsHandler(){

            public boolean warningsShouldFailRequest(List<String> warnings) {
                for (String warning : warnings) {
                    if (warning.startsWith("[types removal]")) continue;
                    return true;
                }
                return false;
            }
        });
        return builder.build();
    }

    protected HttpHost buildHttpHost(String host, int port) {
        return new HttpHost(host, port, this.getProtocol());
    }

    @After
    public final void cleanUpCluster() throws Exception {
        if (!this.preserveClusterUponCompletion()) {
            if (nodeVersions.stream().noneMatch(version -> version.before(Version.V_6_2_0))) {
                ESRestTestCase.ensureNoInitializingShards();
            }
            this.wipeCluster();
            this.waitForClusterStateUpdatesToFinish();
            this.logIfThereAreRunningTasks();
        }
    }

    @AfterClass
    public static void closeClients() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{client, adminClient});
        }
        finally {
            clusterHosts = null;
            client = null;
            adminClient = null;
            hasXPack = null;
            nodeVersions = null;
        }
    }

    protected static RestClient client() {
        return client;
    }

    protected static RestClient adminClient() {
        return adminClient;
    }

    public static void waitForPendingTasks(RestClient adminClient) throws Exception {
        ESRestTestCase.waitForPendingTasks(adminClient, taskName -> false);
    }

    public static void waitForPendingTasks(RestClient adminClient, Predicate<String> taskFilter) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            block8: {
                try {
                    Request request = new Request("GET", "/_cat/tasks");
                    request.addParameter("detailed", "true");
                    Response response = adminClient.performRequest(request);
                    if (response.getStatusLine().getStatusCode() != 200) break block8;
                    try (BufferedReader responseReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
                        String line;
                        int activeTasks = 0;
                        StringBuilder tasksListString = new StringBuilder();
                        while ((line = responseReader.readLine()) != null) {
                            String taskName = line.split("\\s+")[0];
                            if (taskName.startsWith("cluster:monitor/tasks/lists") || taskFilter.test(taskName)) continue;
                            ++activeTasks;
                            tasksListString.append(line);
                            tasksListString.append('\n');
                        }
                        ESRestTestCase.assertEquals((String)(activeTasks + " active tasks found:\n" + tasksListString), (long)0L, (long)activeTasks);
                    }
                }
                catch (IOException e) {
                    throw new AssertionError("error getting active tasks list", e);
                }
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected boolean preserveClusterUponCompletion() {
        return false;
    }

    protected boolean preserveIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveTemplatesUponCompletion() {
        return false;
    }

    protected boolean preserveDataStreamsUponCompletion() {
        return false;
    }

    protected boolean preserveClusterSettings() {
        return false;
    }

    protected boolean preserveReposUponCompletion() {
        return false;
    }

    protected boolean preserveSnapshotsUponCompletion() {
        return false;
    }

    protected boolean preserveRollupJobsUponCompletion() {
        return false;
    }

    protected boolean preserveILMPoliciesUponCompletion() {
        return false;
    }

    protected boolean preserveSLMPoliciesUponCompletion() {
        return false;
    }

    protected java.util.Set<String> preserveILMPolicyIds() {
        return Sets.newHashSet((Object[])new String[]{"ilm-history-ilm-policy", "slm-history-ilm-policy", "watch-history-ilm-policy", "ml-size-based-ilm-policy", "logs", "metrics"});
    }

    protected boolean preserveAutoFollowPatternsUponCompletion() {
        return false;
    }

    protected boolean waitForAllSnapshotsWiped() {
        return false;
    }

    private void wipeCluster() throws Exception {
        if (hasXPack.booleanValue() && !this.preserveRollupJobsUponCompletion()) {
            this.wipeRollupJobs();
            this.waitForPendingRollupTasks();
        }
        if (nodeVersions.first().onOrAfter(Version.V_7_4_0) && !this.preserveSLMPoliciesUponCompletion()) {
            ESRestTestCase.deleteAllSLMPolicies();
        }
        SetOnce inProgressSnapshots = new SetOnce();
        if (this.waitForAllSnapshotsWiped()) {
            AtomicReference snapshots = new AtomicReference();
            try {
                ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                    snapshots.set(this.wipeSnapshots());
                    ESRestTestCase.assertThat((Object)((Map)snapshots.get()), (Matcher)Matchers.anEmptyMap());
                }), 2L, TimeUnit.MINUTES);
                inProgressSnapshots.set((Object)((Map)snapshots.get()));
            }
            catch (AssertionError e) {
                inProgressSnapshots.set((Object)((Map)snapshots.get()));
            }
        } else {
            inProgressSnapshots.set(this.wipeSnapshots());
        }
        if (!this.preserveDataStreamsUponCompletion()) {
            ESRestTestCase.wipeDataStreams();
        }
        if (!this.preserveIndicesUponCompletion()) {
            ESRestTestCase.wipeAllIndices();
        }
        if (!this.preserveTemplatesUponCompletion()) {
            if (hasXPack.booleanValue()) {
                Request request = new Request("GET", "_cat/templates");
                request.addParameter("h", "name");
                String templates = EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(request).getEntity());
                if (!"".equals(templates)) {
                    for (String template : templates.split("\n")) {
                        if (ESRestTestCase.isXPackTemplate(template)) continue;
                        if ("".equals(template)) {
                            throw new IllegalStateException("empty template in templates list:\n" + templates);
                        }
                        this.logger.info("Clearing template [{}]", (Object)template);
                        try {
                            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/" + template));
                        }
                        catch (ResponseException e) {
                            ESRestTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)("index_template [" + template + "] missing")));
                            try {
                                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/" + template));
                            }
                            catch (ResponseException responseException) {
                                // empty catch block
                            }
                        }
                    }
                }
                try {
                    Request compReq = new Request("GET", "_component_template");
                    String componentTemplates = EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(compReq).getEntity());
                    Map cTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)componentTemplates, (boolean)false);
                    List names = ((List)cTemplates.get("component_templates")).stream().map(ct -> (String)ct.get("name")).collect(Collectors.toList());
                    for (String componentTemplate : names) {
                        try {
                            if (ESRestTestCase.isXPackTemplate(componentTemplate)) continue;
                            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/" + componentTemplate));
                        }
                        catch (ResponseException e) {
                            this.logger.debug((Message)new ParameterizedMessage("unable to remove component template {}", (Object)componentTemplate), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.info("ignoring exception removing all component templates", (Throwable)e);
                }
            } else {
                this.logger.debug("Clearing all templates");
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/*"));
                try {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/*"));
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/*"));
                }
                catch (ResponseException responseException) {
                    // empty catch block
                }
            }
        }
        if (!this.preserveClusterSettings()) {
            this.wipeClusterSettings();
        }
        if (hasXPack.booleanValue() && !this.preserveILMPoliciesUponCompletion()) {
            ESRestTestCase.deleteAllILMPolicies(this.preserveILMPolicyIds());
        }
        if (hasXPack.booleanValue() && !this.preserveAutoFollowPatternsUponCompletion()) {
            ESRestTestCase.deleteAllAutoFollowPatterns();
        }
        ESRestTestCase.assertThat((String)("Found in progress snapshots [" + inProgressSnapshots.get() + "]."), (Object)((Map)inProgressSnapshots.get()), (Matcher)Matchers.anEmptyMap());
    }

    protected static void wipeAllIndices() throws IOException {
        block8: {
            boolean includeHidden = ESRestTestCase.minimumNodeVersion().onOrAfter(Version.V_7_7_0);
            try {
                Request deleteRequest = new Request("DELETE", "*,-.ds-ilm-history-*");
                deleteRequest.addParameter("expand_wildcards", "open,closed" + (includeHidden ? ",hidden" : ""));
                RequestOptions.Builder allowSystemIndexAccessWarningOptions = RequestOptions.DEFAULT.toBuilder();
                allowSystemIndexAccessWarningOptions.setWarningsHandler(warnings -> {
                    if (warnings.size() == 0) {
                        return false;
                    }
                    if (warnings.size() > 1) {
                        return true;
                    }
                    String warning = (String)warnings.get(0);
                    boolean isSystemIndexWarning = warning.contains("this request accesses system indices") && warning.contains("but in a future major version, direct access to system indices will be prevented by default");
                    return !isSystemIndexWarning;
                });
                deleteRequest.setOptions(allowSystemIndexAccessWarningOptions);
                Response response = ESRestTestCase.adminClient().performRequest(deleteRequest);
                try (InputStream is = response.getEntity().getContent();){
                    ESRestTestCase.assertTrue((boolean)((Boolean)XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true).get("acknowledged")));
                }
            }
            catch (ResponseException e) {
                if (e.getResponse().getStatusLine().getStatusCode() == 404) break block8;
                throw e;
            }
        }
    }

    protected static void wipeDataStreams() throws IOException {
        block6: {
            try {
                if (ESRestTestCase.hasXPack()) {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_data_stream/*?expand_wildcards=all"));
                }
            }
            catch (ResponseException e) {
                try {
                    if (ESRestTestCase.hasXPack()) {
                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_data_stream/*"));
                    }
                }
                catch (ResponseException ee) {
                    int statusCode = ee.getResponse().getStatusLine().getStatusCode();
                    if (Set.of((Object[])new Integer[]{404, 405, 500}).contains(statusCode)) break block6;
                    throw ee;
                }
            }
        }
    }

    protected Map<String, List<Map<?, ?>>> wipeSnapshots() throws IOException {
        HashMap inProgressSnapshots = new HashMap();
        for (Map.Entry<String, Object> repo : ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "/_snapshot/_all"))).entrySet()) {
            String repoName = repo.getKey();
            Map repoSpec = (Map)repo.getValue();
            String repoType = (String)repoSpec.get("type");
            if (!this.preserveSnapshotsUponCompletion() && repoType.equals("fs")) {
                Request listRequest = new Request("GET", "/_snapshot/" + repoName + "/_all");
                listRequest.addParameter("ignore_unavailable", "true");
                List snapshots = (List)ESRestTestCase.entityAsMap(adminClient.performRequest(listRequest)).get("snapshots");
                for (Object snapshot : snapshots) {
                    Map snapshotInfo = (Map)snapshot;
                    String name = (String)snapshotInfo.get("snapshot");
                    if (!SnapshotState.valueOf((String)((String)snapshotInfo.get("state"))).completed()) {
                        inProgressSnapshots.computeIfAbsent(repoName, key -> new ArrayList()).add(snapshotInfo);
                    }
                    this.logger.debug("wiping snapshot [{}/{}]", (Object)repoName, (Object)name);
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_snapshot/" + repoName + "/" + name));
                }
            }
            if (this.preserveReposUponCompletion()) continue;
            this.deleteRepository(repoName);
        }
        return inProgressSnapshots;
    }

    protected void deleteRepository(String repoName) throws IOException {
        this.logger.debug("wiping snapshot repository [{}]", (Object)repoName);
        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_snapshot/" + repoName));
    }

    private void wipeClusterSettings() throws IOException {
        Map<String, Object> getResponse = ESRestTestCase.entityAsMap(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/settings")));
        boolean mustClear = false;
        XContentBuilder clearCommand = JsonXContent.contentBuilder();
        clearCommand.startObject();
        for (Map.Entry<String, Object> entry : getResponse.entrySet()) {
            String type = entry.getKey().toString();
            Map settings = (Map)entry.getValue();
            if (settings.isEmpty()) continue;
            mustClear = true;
            clearCommand.startObject(type);
            for (Object key : settings.keySet()) {
                clearCommand.field(key + ".*").nullValue();
            }
            clearCommand.endObject();
        }
        clearCommand.endObject();
        if (mustClear) {
            Request request = new Request("PUT", "/_cluster/settings");
            request.setJsonEntity(Strings.toString((XContentBuilder)clearCommand));
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    private void wipeRollupJobs() throws IOException {
        Request request;
        String jobId;
        Response response;
        try {
            response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_rollup/job/_all"));
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == RestStatus.NOT_FOUND.getStatus()) {
                return;
            }
            throw e;
        }
        Map<String, Object> jobs = ESRestTestCase.entityAsMap(response);
        List jobConfigs = (List)XContentMapValues.extractValue((String)"jobs", jobs);
        if (jobConfigs == null) {
            return;
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("POST", "/_rollup/job/" + jobId + "/_stop");
            request.addParameter("ignore", "404");
            request.addParameter("wait_for_completion", "true");
            request.addParameter("timeout", "10s");
            this.logger.debug("stopping rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("DELETE", "/_rollup/job/" + jobId);
            request.addParameter("ignore", "404");
            this.logger.debug("deleting rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    protected void refreshAllIndices() throws IOException {
        boolean includeHidden = ESRestTestCase.minimumNodeVersion().onOrAfter(Version.V_7_7_0);
        Request refreshRequest = new Request("POST", "/_refresh");
        refreshRequest.addParameter("expand_wildcards", "open" + (includeHidden ? ",hidden" : ""));
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder();
        requestOptions.setWarningsHandler(warnings -> {
            if (warnings.isEmpty()) {
                return false;
            }
            if (warnings.size() > 1) {
                return true;
            }
            return !((String)warnings.get(0)).startsWith("this request accesses system indices:");
        });
        refreshRequest.setOptions(requestOptions);
        ESRestTestCase.client().performRequest(refreshRequest);
    }

    private void waitForPendingRollupTasks() throws Exception {
        ESRestTestCase.waitForPendingTasks(ESRestTestCase.adminClient(), taskName -> !taskName.startsWith("xpack/rollup/job"));
    }

    private static void deleteAllILMPolicies(java.util.Set<String> exclusions) throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ilm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        policies.keySet().stream().filter(p -> !exclusions.contains(p)).forEach(policyName -> {
            try {
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_ilm/policy/" + policyName));
            }
            catch (IOException e) {
                throw new RuntimeException("failed to delete policy: " + policyName, e);
            }
        });
    }

    private static void deleteAllSLMPolicies() throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_slm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        for (String policyName : policies.keySet()) {
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_slm/policy/" + policyName));
        }
    }

    private static void deleteAllAutoFollowPatterns() throws IOException {
        List patterns;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ccr/auto_follow"));
            patterns = (List)ESRestTestCase.entityAsMap(response).get("patterns");
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (patterns == null || patterns.isEmpty()) {
            return;
        }
        for (Map pattern : patterns) {
            String patternName = (String)pattern.get("name");
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_ccr/auto_follow/" + patternName));
        }
    }

    private void logIfThereAreRunningTasks() throws IOException {
        java.util.Set<String> runningTasks = this.runningTasks(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_tasks")));
        runningTasks.remove("cluster:monitor/tasks/lists");
        runningTasks.remove("cluster:monitor/tasks/lists[n]");
        if (runningTasks.isEmpty()) {
            return;
        }
        ArrayList<String> stillRunning = new ArrayList<String>(runningTasks);
        Collections.sort(stillRunning);
        this.logger.info("There are still tasks running after this test that might break subsequent tests {}.", stillRunning);
    }

    private void waitForClusterStateUpdatesToFinish() throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            try {
                Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/pending_tasks"));
                List tasks = (List)ESRestTestCase.entityAsMap(response).get("tasks");
                if (!tasks.isEmpty()) {
                    StringBuilder message = new StringBuilder("there are still running tasks:");
                    for (Object task : tasks) {
                        message.append('\n').append(task.toString());
                    }
                    ESRestTestCase.fail((String)message.toString());
                }
            }
            catch (IOException e) {
                ESRestTestCase.fail((String)("cannot get cluster's pending tasks: " + e.getMessage()));
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected Settings restClientSettings() {
        Settings.Builder builder = Settings.builder();
        if (System.getProperty("tests.rest.client_path_prefix") != null) {
            builder.put(CLIENT_PATH_PREFIX, System.getProperty("tests.rest.client_path_prefix"));
        }
        return builder.build();
    }

    protected Settings restAdminSettings() {
        return this.restClientSettings();
    }

    protected final List<HttpHost> getClusterHosts() {
        return clusterHosts;
    }

    protected String getProtocol() {
        return "http";
    }

    protected RestClient buildClient(Settings settings, HttpHost[] hosts) throws IOException {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        ESRestTestCase.configureClient(builder, settings);
        builder.setStrictDeprecationMode(true);
        return builder.build();
    }

    protected static void configureClient(RestClientBuilder builder, Settings settings) throws IOException {
        SSLIOSessionStrategy sessionStrategy;
        SSLContext sslcontext;
        String truststorePath = settings.get(TRUSTSTORE_PATH);
        String certificateAuthorities = settings.get(CERTIFICATE_AUTHORITIES);
        String clientCertificatePath = settings.get(CLIENT_CERT_PATH);
        if (certificateAuthorities != null && truststorePath != null) {
            throw new IllegalStateException("Cannot set both certificate_authorities and truststore.path. Please configure one of these.");
        }
        if (truststorePath != null) {
            if (ESRestTestCase.inFipsJvm()) {
                throw new IllegalStateException("Keystore " + truststorePath + "cannot be used in FIPS 140 mode. Please configure " + CERTIFICATE_AUTHORITIES + " with a PEM encoded trusted CA/certificate instead");
            }
            String keystorePass = settings.get(TRUSTSTORE_PASSWORD);
            if (keystorePass == null) {
                throw new IllegalStateException("truststore.path is provided but not truststore.password");
            }
            Path path = PathUtils.get((String)truststorePath, (String[])new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("truststore.path is set but points to a non-existing file");
            }
            try {
                String keyStoreType = truststorePath.endsWith(".p12") ? "PKCS12" : "jks";
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    keyStore.load(is, keystorePass.toCharArray());
                }
                sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, null).build();
                sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        }
        if (certificateAuthorities != null) {
            Path caPath = PathUtils.get((String)certificateAuthorities, (String[])new String[0]);
            if (!Files.exists(caPath, new LinkOption[0])) {
                throw new IllegalStateException("certificate_authorities is set but points to a non-existing file");
            }
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                Certificate caCert = (Certificate)PemUtils.readCertificates(Collections.singletonList(caPath)).get(0);
                keyStore.setCertificateEntry(caCert.toString(), caCert);
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (clientCertificatePath != null) {
                    Path certPath = PathUtils.get((String)clientCertificatePath, (String[])new String[0]);
                    Path keyPath = PathUtils.get((String)Objects.requireNonNull(settings.get(CLIENT_KEY_PATH), "No key provided"), (String[])new String[0]);
                    String password = settings.get(CLIENT_KEY_PASSWORD);
                    char[] passwordChars = password == null ? null : password.toCharArray();
                    PrivateKey key = PemUtils.readPrivateKey((Path)keyPath, () -> passwordChars);
                    Certificate[] clientCertChain = PemUtils.readCertificates(Collections.singletonList(certPath)).toArray(new Certificate[1]);
                    keyStore.setKeyEntry("client", key, passwordChars, clientCertChain);
                    sslContextBuilder.loadKeyMaterial(keyStore, passwordChars);
                }
                sslcontext = sslContextBuilder.loadTrustMaterial(keyStore, null).build();
                sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        } else if (clientCertificatePath != null) {
            throw new IllegalStateException("Client certificates are currently only supported when using a custom CA");
        }
        Map headers = ThreadContext.buildDefaultHeaders((Settings)settings);
        Header[] defaultHeaders = new Header[headers.size()];
        int i = 0;
        for (Map.Entry entry : headers.entrySet()) {
            defaultHeaders[i++] = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
        }
        builder.setDefaultHeaders(defaultHeaders);
        String socketTimeoutString = settings.get(CLIENT_SOCKET_TIMEOUT);
        TimeValue socketTimeout = TimeValue.parseTimeValue((String)(socketTimeoutString == null ? "60s" : socketTimeoutString), (String)CLIENT_SOCKET_TIMEOUT);
        builder.setRequestConfigCallback(conf -> conf.setSocketTimeout(Math.toIntExact(socketTimeout.getMillis())));
        if (settings.hasValue(CLIENT_PATH_PREFIX)) {
            builder.setPathPrefix(settings.get(CLIENT_PATH_PREFIX));
        }
    }

    private java.util.Set<String> runningTasks(Response response) throws IOException {
        HashSet<String> runningTasks = new HashSet<String>();
        Map nodes = (Map)ESRestTestCase.entityAsMap(response).get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            Map nodeTasks = (Map)nodeInfo.get("tasks");
            for (Map.Entry taskAndName : nodeTasks.entrySet()) {
                Map task = (Map)taskAndName.getValue();
                runningTasks.add(task.get("action").toString());
            }
        }
        return runningTasks;
    }

    protected static void assertOK(Response response) {
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)200), (Matcher)Matchers.equalTo((Object)201)));
    }

    public static void ensureGreen(String index) throws IOException {
        ESRestTestCase.ensureHealth(index, request -> {
            request.addParameter("wait_for_status", "green");
            request.addParameter("wait_for_no_relocating_shards", "true");
            request.addParameter("timeout", "70s");
            request.addParameter("level", "shards");
        });
    }

    protected static void ensureHealth(Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth("", requestConsumer);
    }

    protected static void ensureHealth(String index, Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth(ESRestTestCase.client(), index, requestConsumer);
    }

    protected static void ensureHealth(RestClient client, String index, Consumer<Request> requestConsumer) throws IOException {
        Request request = new Request("GET", "/_cluster/health" + (index.trim().isEmpty() ? "" : "/" + index));
        requestConsumer.accept(request);
        try {
            client.performRequest(request);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 408) {
                try {
                    Response clusterStateResponse = client.performRequest(new Request("GET", "/_cluster/state?pretty"));
                    ESRestTestCase.fail((String)("timed out waiting for green state for index [" + index + "] cluster state [" + EntityUtils.toString((HttpEntity)clusterStateResponse.getEntity()) + "]"));
                }
                catch (Exception inner) {
                    e.addSuppressed((Throwable)inner);
                }
            }
            throw e;
        }
    }

    protected static void ensureNoInitializingShards() throws IOException {
        Request request = new Request("GET", "/_cluster/health");
        request.addParameter("wait_for_no_initializing_shards", "true");
        request.addParameter("timeout", "70s");
        request.addParameter("level", "shards");
        ESRestTestCase.adminClient().performRequest(request);
    }

    protected static void createIndex(String name, Settings settings) throws IOException {
        ESRestTestCase.createIndex(name, settings, null);
    }

    protected static void createIndex(String name, Settings settings, String mapping) throws IOException {
        ESRestTestCase.createIndex(name, settings, mapping, null);
    }

    protected static void createIndex(String name, Settings settings, String mapping, String aliases) throws IOException {
        Request request = new Request("PUT", "/" + name);
        String entity = "{\"settings\": " + Strings.toString((ToXContent)settings);
        if (mapping != null) {
            entity = entity + ",\"mappings\" : {" + mapping + "}";
        }
        if (aliases != null) {
            entity = entity + ",\"aliases\": {" + aliases + "}";
        }
        entity = entity + "}";
        if (!settings.getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(true)).booleanValue()) {
            ESRestTestCase.expectSoftDeletesWarning(request, name);
        } else if (settings.hasValue(IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.getKey()) || settings.hasValue(IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.getKey())) {
            ESRestTestCase.expectTranslogRetentionWarning(request);
        }
        request.setJsonEntity(entity);
        ESRestTestCase.client().performRequest(request);
    }

    protected static void deleteIndex(String name) throws IOException {
        Request request = new Request("DELETE", "/" + name);
        ESRestTestCase.client().performRequest(request);
    }

    protected static void updateIndexSettings(String index, Settings.Builder settings) throws IOException {
        ESRestTestCase.updateIndexSettings(index, settings.build());
    }

    private static void updateIndexSettings(String index, Settings settings) throws IOException {
        Request request = new Request("PUT", "/" + index + "/_settings");
        request.setJsonEntity(Strings.toString((ToXContent)settings));
        ESRestTestCase.client().performRequest(request);
    }

    protected static void expectSoftDeletesWarning(Request request, String indexName) {
        List<String> expectedWarnings = Collections.singletonList("Creating indices with soft-deletes disabled is deprecated and will be removed in future Elasticsearch versions. Please do not specify value for setting [index.soft_deletes.enabled] of index [" + indexName + "].");
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder();
        if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_6_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.equals(expectedWarnings));
            request.setOptions(requestOptions);
        } else if (nodeVersions.stream().anyMatch(version -> version.onOrAfter(Version.V_7_6_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(expectedWarnings));
            request.setOptions(requestOptions);
        }
    }

    protected static void expectTranslogRetentionWarning(Request request) {
        List<String> expectedWarnings = Collections.singletonList("Translog retention settings [index.translog.retention.age] and [index.translog.retention.size] are deprecated and effectively ignored. They will be removed in a future version.");
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder();
        if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_7_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.equals(expectedWarnings));
            request.setOptions(requestOptions);
        } else if (nodeVersions.stream().anyMatch(version -> version.onOrAfter(Version.V_7_7_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(expectedWarnings));
            request.setOptions(requestOptions);
        }
    }

    protected static Map<String, Object> getIndexSettings(String index) throws IOException {
        Request request = new Request("GET", "/" + index + "/_settings");
        request.addParameter("flat_settings", "true");
        Response response = ESRestTestCase.client().performRequest(request);
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
            return map;
        }
    }

    protected Map<String, Object> getIndexSettingsAsMap(String index) throws IOException {
        Map<String, Object> indexSettings = ESRestTestCase.getIndexSettings(index);
        return (Map)((Map)indexSettings.get(index)).get("settings");
    }

    protected static boolean indexExists(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static void closeIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_close"));
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void openIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_open"));
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static boolean aliasExists(String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static boolean aliasExists(String index, String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index + "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static Map<String, Object> getAlias(String index, String alias) throws IOException {
        String endpoint = "/_alias";
        if (!Strings.isEmpty((CharSequence)index)) {
            endpoint = index + endpoint;
        }
        if (!Strings.isEmpty((CharSequence)alias)) {
            endpoint = endpoint + "/" + alias;
        }
        Map<String, Object> getAliasResponse = ESRestTestCase.getAsMap(endpoint);
        return (Map)XContentMapValues.extractValue((String)(index + ".aliases." + alias), getAliasResponse);
    }

    protected static Map<String, Object> getAsMap(String endpoint) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("GET", endpoint));
        return ESRestTestCase.responseAsMap(response);
    }

    protected static Map<String, Object> responseAsMap(Response response) throws IOException {
        XContentType entityContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        Map responseEntity = XContentHelper.convertToMap((XContent)entityContentType.xContent(), (InputStream)response.getEntity().getContent(), (boolean)false);
        ESRestTestCase.assertNotNull((Object)responseEntity);
        return responseEntity;
    }

    protected static void registerRepository(String repository, String type, boolean verify, Settings settings) throws IOException {
        Request request = new Request("PUT", "_snapshot/" + repository);
        request.addParameter("verify", Boolean.toString(verify));
        request.setJsonEntity(Strings.toString((ToXContent)new PutRepositoryRequest(repository).type(type).settings(settings)));
        Response response = ESRestTestCase.client().performRequest(request);
        ESRestTestCase.assertAcked("Failed to create repository [" + repository + "] of type [" + type + "]: " + response, response);
    }

    protected static void createSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("PUT", "_snapshot/" + repository + '/' + snapshot);
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = ESRestTestCase.client().performRequest(request);
        ESRestTestCase.assertThat((String)("Failed to create snapshot [" + snapshot + "] in repository [" + repository + "]: " + response), (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void restoreSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("POST", "_snapshot/" + repository + '/' + snapshot + "/_restore");
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = ESRestTestCase.client().performRequest(request);
        ESRestTestCase.assertThat((String)("Failed to restore snapshot [" + snapshot + "] from repository [" + repository + "]: " + response), (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    private static void assertAcked(String message, Response response) throws IOException {
        int responseStatusCode = response.getStatusLine().getStatusCode();
        ESRestTestCase.assertThat((String)(message + ": expecting response code [200] but got [" + responseStatusCode + ']'), (Object)responseStatusCode, (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
        Map<String, Object> responseAsMap = ESRestTestCase.responseAsMap(response);
        Boolean acknowledged = (Boolean)XContentMapValues.extractValue(responseAsMap, (String[])new String[]{"acknowledged"});
        ESRestTestCase.assertThat((String)(message + ": response is not acknowledged"), (Object)acknowledged, (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
    }

    protected static boolean isXPackTemplate(String name) {
        if (name.startsWith(".monitoring-")) {
            return true;
        }
        if (name.startsWith(".watch") || name.startsWith(".triggered_watches")) {
            return true;
        }
        if (name.startsWith(".data-frame-")) {
            return true;
        }
        if (name.startsWith(".ml-")) {
            return true;
        }
        if (name.startsWith(".transform-")) {
            return true;
        }
        switch (name) {
            case ".watches": 
            case "logstash-index-template": 
            case ".logstash-management": 
            case "security_audit_log": 
            case ".slm-history": 
            case ".async-search": 
            case "saml-service-provider": 
            case "ilm-history": 
            case "logs": 
            case "logs-settings": 
            case "logs-mappings": 
            case "metrics": 
            case "metrics-settings": 
            case "metrics-mappings": 
            case "synthetics": 
            case "synthetics-settings": 
            case "synthetics-mappings": 
            case ".snapshot-blob-cache": 
            case ".deprecation-indexing-template": {
                return true;
            }
        }
        return false;
    }

    public void flush(String index, boolean force) throws IOException {
        this.logger.info("flushing index {} force={}", (Object)index, (Object)force);
        Request flushRequest = new Request("POST", "/" + index + "/_flush");
        flushRequest.addParameter("force", Boolean.toString(force));
        flushRequest.addParameter("wait_if_ongoing", "true");
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest(flushRequest));
    }

    public void assertNoFileBasedRecovery(String indexName, Predicate<String> targetNode) throws IOException {
        Map<String, Object> recoveries = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", indexName + "/_recovery?detailed=true")));
        List shards = (List)XContentMapValues.extractValue((String)(indexName + ".shards"), recoveries);
        ESRestTestCase.assertNotNull((Object)shards);
        boolean foundReplica = false;
        this.logger.info("index {} recovery stats {}", (Object)indexName, (Object)shards);
        for (Map shard : shards) {
            if (shard.get("primary") != Boolean.FALSE || !targetNode.test((String)XContentMapValues.extractValue((String)"target.name", (Map)shard))) continue;
            List details = (List)XContentMapValues.extractValue((String)"index.files.details", (Map)shard);
            if (details == null) {
                long totalFiles = ((Number)XContentMapValues.extractValue((String)"index.files.total", (Map)shard)).longValue();
                long reusedFiles = ((Number)XContentMapValues.extractValue((String)"index.files.reused", (Map)shard)).longValue();
                this.logger.info("total [{}] reused [{}]", (Object)totalFiles, (Object)reusedFiles);
                ESRestTestCase.assertThat((String)("must reuse all files, recoveries [" + recoveries + "]"), (Object)totalFiles, (Matcher)Matchers.equalTo((Object)reusedFiles));
            } else {
                ESRestTestCase.assertNotNull((Object)details);
                ESRestTestCase.assertThat((Object)details, (Matcher)Matchers.empty());
            }
            foundReplica = true;
        }
        ESRestTestCase.assertTrue((String)"must find replica", (boolean)foundReplica);
    }

    public void assertEmptyTranslog(String index) throws Exception {
        Map<String, Object> stats = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
        ESRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)("indices." + index + ".total.translog.uncommitted_operations"), stats), (Matcher)Matchers.equalTo((Object)0));
        ESRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)("indices." + index + ".total.translog.operations"), stats), (Matcher)Matchers.equalTo((Object)0));
    }

    public void ensurePeerRecoveryRetentionLeasesRenewedAndSynced(String index) throws Exception {
        boolean alwaysExists = ESRestTestCase.minimumNodeVersion().onOrAfter(Version.V_7_6_0);
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Map<String, Object> stats = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
            Map shards = (Map)XContentMapValues.extractValue((String)("indices." + index + ".shards"), stats);
            for (List shard : shards.values()) {
                for (Map copy : shard) {
                    Integer globalCheckpoint = (Integer)XContentMapValues.extractValue((String)"seq_no.global_checkpoint", (Map)copy);
                    ESRestTestCase.assertNotNull((Object)globalCheckpoint);
                    ESRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)"seq_no.max_seq_no", (Map)copy), (Matcher)Matchers.equalTo((Object)globalCheckpoint));
                    List retentionLeases = (List)XContentMapValues.extractValue((String)"retention_leases.leases", (Map)copy);
                    if (!alwaysExists && retentionLeases == null) continue;
                    ESRestTestCase.assertNotNull((Object)retentionLeases);
                    for (Map retentionLease : retentionLeases) {
                        if (!((String)retentionLease.get("id")).startsWith("peer_recovery/")) continue;
                        ESRestTestCase.assertThat(retentionLease.get("retaining_seq_no"), (Matcher)Matchers.equalTo((Object)(globalCheckpoint + 1)));
                    }
                    if (!alwaysExists) continue;
                    List existingLeaseIds = retentionLeases.stream().map(lease -> (String)lease.get("id")).collect(Collectors.toList());
                    List expectedLeaseIds = shard.stream().map(shr -> (String)XContentMapValues.extractValue((String)"routing.node", (Map)shr)).map(ReplicationTracker::getPeerRecoveryRetentionLeaseId).collect(Collectors.toList());
                    ESRestTestCase.assertThat((String)"not every active copy has established its PPRL", expectedLeaseIds, (Matcher)Matchers.everyItem((Matcher)Matchers.in(existingLeaseIds)));
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    public static Boolean getHasXPack() {
        return hasXPack;
    }

    protected static Version minimumNodeVersion() throws IOException {
        Request request = new Request("GET", "_nodes");
        request.addParameter("filter_path", "nodes.*.version");
        Response response = ESRestTestCase.adminClient().performRequest(request);
        Map nodes = (Map)ObjectPath.createFromResponse(response).evaluate("nodes");
        Version minVersion = null;
        for (Map.Entry node : nodes.entrySet()) {
            Version nodeVersion = Version.fromString((String)((String)((Map)node.getValue()).get("version")));
            if (minVersion != null && !minVersion.after(nodeVersion)) continue;
            minVersion = nodeVersion;
        }
        ESRestTestCase.assertNotNull(minVersion);
        return minVersion;
    }

    protected static void performSyncedFlush(String indexName, boolean retryOnConflict) throws Exception {
        Request request = new Request("POST", indexName + "/_flush/synced");
        List<String> expectedWarnings = Collections.singletonList("Synced flush is deprecated and will be removed in 8.0. Use flush at /_flush or /{index}/_flush instead.");
        List<String> incorrectWarningMessage = Collections.singletonList("Synced flush is deprecated and will be removed in 8.0. Use flush at _/flush or /{index}/_flush instead.");
        RequestOptions.Builder options = RequestOptions.DEFAULT.toBuilder();
        if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_11_0))) {
            options.setWarningsHandler(warnings -> !warnings.equals(expectedWarnings));
        } else if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_7_6_0))) {
            options.setWarningsHandler(warnings -> !warnings.equals(expectedWarnings) && !warnings.equals(incorrectWarningMessage));
        } else if (nodeVersions.stream().anyMatch(version -> version.onOrAfter(Version.V_7_6_0))) {
            options.setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(expectedWarnings) && !warnings.equals(incorrectWarningMessage));
        }
        request.setOptions(options);
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            block3: {
                try {
                    Response resp = ESRestTestCase.client().performRequest(request);
                    if (retryOnConflict) {
                        Map result = (Map)ObjectPath.createFromResponse(resp).evaluate("_shards");
                        ESRestTestCase.assertThat(result.get("failed"), (Matcher)Matchers.equalTo((Object)0));
                    }
                }
                catch (ResponseException ex) {
                    ESRestTestCase.assertThat((Object)ex.getResponse().getStatusLine(), (Matcher)Matchers.equalTo((Object)409));
                    if (!retryOnConflict) break block3;
                    throw new AssertionError((Object)ex);
                }
            }
        }));
    }

    protected static void waitForActiveLicense(RestClient restClient) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Request request = new Request("GET", "/_xpack");
            request.setOptions(RequestOptions.DEFAULT.toBuilder());
            Response response = restClient.performRequest(request);
            ESRestTestCase.assertOK(response);
            try (InputStream is = response.getEntity().getContent();){
                XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
                Map map = XContentHelper.convertToMap((XContent)xContentType.xContent(), (InputStream)is, (boolean)true);
                ESRestTestCase.assertThat((Object)map, (Matcher)Matchers.notNullValue());
                ESRestTestCase.assertThat((String)"License must exist", (Object)map.containsKey("license"), (Matcher)Matchers.equalTo((Object)true));
                Map license = (Map)map.get("license");
                ESRestTestCase.assertThat((String)"Expecting non-null license", (Object)license, (Matcher)Matchers.notNullValue());
                ESRestTestCase.assertThat((String)"License status must exist", (Object)license.containsKey("status"), (Matcher)Matchers.equalTo((Object)true));
                String status = (String)license.get("status");
                ESRestTestCase.assertThat((String)"Expecting non-null license status", (Object)status, (Matcher)Matchers.notNullValue());
                ESRestTestCase.assertThat((String)"Expecting active license", (Object)status, (Matcher)Matchers.equalTo((Object)"active"));
            }
        }));
    }

    protected static void useIgnoreMultipleMatchingTemplatesWarningsHandler(Request request) throws IOException {
        RequestOptions.Builder options = request.getOptions().toBuilder();
        options.setWarningsHandler(warnings -> {
            if (warnings.size() > 0) {
                boolean matches = warnings.stream().anyMatch(message -> CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches() || PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches());
                return !matches;
            }
            return false;
        });
        request.setOptions(options);
    }

    static {
        CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index \\[(.+)\\] matches multiple legacy templates \\[(.+)\\], composable templates will only match a single template$");
        PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index template \\[(.+)\\] has index patterns \\[(.+)\\] matching patterns from existing older templates \\[(.+)\\] with patterns \\((.+)\\); this template \\[(.+)\\] will take precedence during new index creation$");
    }

    public static class VersionSensitiveWarningsHandler
    implements WarningsHandler {
        java.util.Set<String> requiredSameVersionClusterWarnings = new HashSet<String>();
        java.util.Set<String> allowedWarnings = new HashSet<String>();
        final java.util.Set<Version> testNodeVersions;

        public VersionSensitiveWarningsHandler(java.util.Set<Version> nodeVersions) {
            this.testNodeVersions = nodeVersions;
        }

        public void current(String ... requiredWarnings) {
            this.requiredSameVersionClusterWarnings.addAll(Arrays.asList(requiredWarnings));
        }

        public void compatible(String ... allowedWarnings) {
            this.allowedWarnings.addAll(Arrays.asList(allowedWarnings));
        }

        public boolean warningsShouldFailRequest(List<String> warnings) {
            if (this.isExclusivelyTargetingCurrentVersionCluster()) {
                HashSet<String> actual = new HashSet<String>(warnings);
                return false == this.requiredSameVersionClusterWarnings.equals(actual);
            }
            for (String actualWarning : warnings) {
                if (this.allowedWarnings.contains(actualWarning) || this.requiredSameVersionClusterWarnings.contains(actualWarning)) continue;
                return true;
            }
            return false;
        }

        private boolean isExclusivelyTargetingCurrentVersionCluster() {
            Assert.assertFalse((String)"Node versions running in the cluster are missing", (boolean)this.testNodeVersions.isEmpty());
            return this.testNodeVersions.size() == 1 && this.testNodeVersions.iterator().next().equals((Object)Version.CURRENT);
        }
    }
}

