/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;

public class StubbableConnectionManager
implements ConnectionManager {
    private final ConnectionManager delegate;
    private final ConcurrentMap<TransportAddress, GetConnectionBehavior> getConnectionBehaviors;
    private volatile GetConnectionBehavior defaultGetConnectionBehavior = ConnectionManager::getConnection;
    private volatile NodeConnectedBehavior defaultNodeConnectedBehavior = ConnectionManager::nodeConnected;

    public StubbableConnectionManager(ConnectionManager delegate) {
        this.delegate = delegate;
        this.getConnectionBehaviors = new ConcurrentHashMap<TransportAddress, GetConnectionBehavior>();
    }

    public boolean addGetConnectionBehavior(TransportAddress transportAddress, GetConnectionBehavior connectBehavior) {
        return this.getConnectionBehaviors.put(transportAddress, connectBehavior) == null;
    }

    public boolean setDefaultGetConnectionBehavior(GetConnectionBehavior behavior) {
        GetConnectionBehavior prior = this.defaultGetConnectionBehavior;
        this.defaultGetConnectionBehavior = behavior;
        return prior == null;
    }

    public boolean setDefaultNodeConnectedBehavior(NodeConnectedBehavior behavior) {
        NodeConnectedBehavior prior = this.defaultNodeConnectedBehavior;
        this.defaultNodeConnectedBehavior = behavior;
        return prior == null;
    }

    public void clearBehaviors() {
        this.defaultGetConnectionBehavior = ConnectionManager::getConnection;
        this.getConnectionBehaviors.clear();
    }

    public void clearBehavior(TransportAddress transportAddress) {
        this.getConnectionBehaviors.remove(transportAddress);
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        this.delegate.openConnection(node, connectionProfile, listener);
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        TransportAddress address = node.getAddress();
        GetConnectionBehavior behavior = this.getConnectionBehaviors.getOrDefault(address, this.defaultGetConnectionBehavior);
        return behavior.getConnection(this.delegate, node);
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.defaultNodeConnectedBehavior.connectedNodes(this.delegate, node);
    }

    public void addListener(TransportConnectionListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(TransportConnectionListener listener) {
        this.delegate.removeListener(listener);
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        this.delegate.connectToNode(node, connectionProfile, connectionValidator, listener);
    }

    public void disconnectFromNode(DiscoveryNode node) {
        this.delegate.disconnectFromNode(node);
    }

    public int size() {
        return this.delegate.size();
    }

    public Set<DiscoveryNode> getAllConnectedNodes() {
        return this.delegate.getAllConnectedNodes();
    }

    public void close() {
        this.delegate.close();
    }

    public void closeNoBlock() {
        this.delegate.closeNoBlock();
    }

    public ConnectionProfile getConnectionProfile() {
        return this.delegate.getConnectionProfile();
    }

    @FunctionalInterface
    public static interface GetConnectionBehavior {
        public Transport.Connection getConnection(ConnectionManager var1, DiscoveryNode var2);
    }

    @FunctionalInterface
    public static interface NodeConnectedBehavior {
        public boolean connectedNodes(ConnectionManager var1, DiscoveryNode var2);
    }
}

