/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;

public class TestThreadPool
extends ThreadPool {
    private final CountDownLatch blockingLatch = new CountDownLatch(1);
    private volatile boolean returnRejectingExecutor = false;
    private volatile ThreadPoolExecutor rejectingExecutor;

    public TestThreadPool(String name, ExecutorBuilder<?> ... customBuilders) {
        this(name, Settings.EMPTY, customBuilders);
    }

    public TestThreadPool(String name, Settings settings, ExecutorBuilder<?> ... customBuilders) {
        super(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), name).put(settings).build(), customBuilders);
    }

    public ExecutorService executor(String name) {
        if (this.returnRejectingExecutor) {
            return this.rejectingExecutor;
        }
        return super.executor(name);
    }

    public void startForcingRejections() {
        if (this.rejectingExecutor == null) {
            this.createRejectingExecutor();
        }
        this.returnRejectingExecutor = true;
    }

    public void stopForcingRejections() {
        this.returnRejectingExecutor = false;
    }

    public void shutdown() {
        this.blockingLatch.countDown();
        if (this.rejectingExecutor != null) {
            this.rejectingExecutor.shutdown();
        }
        super.shutdown();
    }

    public void shutdownNow() {
        this.blockingLatch.countDown();
        if (this.rejectingExecutor != null) {
            this.rejectingExecutor.shutdownNow();
        }
        super.shutdownNow();
    }

    private synchronized void createRejectingExecutor() {
        if (this.rejectingExecutor != null) {
            return;
        }
        ThreadFactory factory = EsExecutors.daemonThreadFactory((String)"reject_thread");
        this.rejectingExecutor = EsExecutors.newFixed((String)"rejecting", (int)1, (int)0, (ThreadFactory)factory, (ThreadContext)this.getThreadContext());
        CountDownLatch startedLatch = new CountDownLatch(1);
        this.rejectingExecutor.execute(() -> {
            try {
                startedLatch.countDown();
                this.blockingLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            startedLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

