/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.mvc.UrlParamHandler;
import org.eweb4j.mvc.config.bean.ActionConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionConfigBeanCache {
    private static Log log = LogFactory.getMVCLogger(ActionConfigBeanCache.class);
    private static final HashMap<Object, ActionConfigBean> ACTION_CFG_BEAN = new HashMap();

    private ActionConfigBeanCache() {
    }

    public static boolean containsKey(String beanID) {
        return ACTION_CFG_BEAN.containsKey(beanID);
    }

    public static Map<String, List<?>> getByMatches(String aUri, String reqMethod) {
        String uri = new String(aUri);
        HashMap result = null;
        for (Map.Entry<Object, ActionConfigBean> entry : ACTION_CFG_BEAN.entrySet()) {
            String bid;
            Object beanID = entry.getKey();
            ActionConfigBean mvcBean = entry.getValue();
            if (!String.class.isAssignableFrom(beanID.getClass()) || (bid = String.valueOf(beanID).replace("#" + mvcBean.getHttpMethod(), "")).contains("{") || bid.contains("}")) continue;
            if (aUri.endsWith("/")) {
                uri = aUri.substring(0, aUri.length() - 1);
            }
            if (bid.endsWith("/")) {
                bid = bid.substring(0, bid.length() - 1);
            }
            String[] methods = mvcBean.getHttpMethod().split("\\|");
            boolean checkMethod = false;
            String[] stringArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                if (m.trim().equalsIgnoreCase(reqMethod)) {
                    checkMethod = true;
                    break;
                }
                ++n2;
            }
            if (bid == null || !checkMethod || !uri.matches(bid)) continue;
            result = new HashMap();
            String urlMapping = mvcBean.getUriMapping();
            if (urlMapping.startsWith("/")) {
                urlMapping = urlMapping.substring(1);
            }
            String pattern = "\\{[-a-zA-Z0-9_\u4e00-\u9fa5\\.,;:\\|]+\\}";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(urlMapping);
            ArrayList<String> urlParamNames = new ArrayList<String>();
            ArrayList<String> urlParamValues = new ArrayList<String>();
            while (m.find()) {
                String g = m.group();
                String[] regexSplit = urlMapping.split(pattern);
                String paramVal = UrlParamHandler.matchersUrlParam(uri, regexSplit);
                if (paramVal != null) {
                    urlParamValues.add(paramVal);
                    urlParamNames.add(g);
                    urlMapping = urlMapping.replace(g, paramVal);
                    continue;
                }
                urlMapping = urlMapping.replace(g, g.replace("{", "").replace("}", ""));
            }
            if (urlParamNames.size() > 0 && urlParamValues.size() > 0) {
                result.put("urlParamNames", urlParamNames);
                result.put("urlParamValues", urlParamValues);
            }
            ArrayList<ActionConfigBean> mvcBeanList = new ArrayList<ActionConfigBean>();
            mvcBeanList.add(mvcBean);
            result.put("mvcBean", mvcBeanList);
            break;
        }
        return result;
    }

    public static void add(String beanID, ActionConfigBean o) {
        if (beanID != null && o != null) {
            String info = null;
            if (!ACTION_CFG_BEAN.containsKey(beanID)) {
                ACTION_CFG_BEAN.put(beanID, o);
                info = "http -> " + beanID + " mapping to class -> " + o.getClazz() + "." + o.getMethod() + " ok";
            } else {
                ActionConfigBean actionBean = ACTION_CFG_BEAN.get(beanID);
                if (actionBean != null) {
                    String level1 = actionBean.getLevel();
                    String level2 = o.getLevel();
                    if (level1 == null || level1.trim().length() == 0) {
                        level1 = "1";
                    }
                    if (level2 == null || level2.trim().length() == 0) {
                        level2 = "1";
                    }
                    int level_1 = 1;
                    int level_2 = 1;
                    if (level1.matches("^-?\\d+$")) {
                        level_1 = Integer.parseInt(level1);
                    }
                    if (level2.matches("^-?\\d+$")) {
                        level_2 = Integer.parseInt(level2);
                    }
                    if (level_2 > level_1) {
                        ACTION_CFG_BEAN.remove(beanID);
                        ACTION_CFG_BEAN.put(beanID, o);
                        info = " " + actionBean.getClazz() + "#" + actionBean.getMethod() + "#uri-mapping:" + beanID + "  level[" + level_1 + "]is lower than" + o.getClazz() + "." + o.getMethod() + "#uri-mapping:" + beanID + "level[" + level_2 + "]\uff0cso replaced\u3002";
                    } else {
                        info = "the http -> " + beanID + " is exists";
                    }
                } else {
                    ACTION_CFG_BEAN.put(beanID, o);
                    info = "http -> " + beanID + " mapping to class -> " + o.getClazz() + "." + o.getMethod() + " ok";
                }
            }
            log.debug(info);
        }
    }

    public static ActionConfigBean get(String beanID) {
        ActionConfigBean o = null;
        if (beanID != null && ACTION_CFG_BEAN.containsKey(beanID)) {
            o = ACTION_CFG_BEAN.get(beanID);
        }
        return o;
    }

    public static void clear() {
        if (!ACTION_CFG_BEAN.isEmpty()) {
            ACTION_CFG_BEAN.clear();
        }
    }

    public static HashMap<Object, ActionConfigBean> getAll() {
        return ACTION_CFG_BEAN;
    }
}

