/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eweb4j.cache.ActionConfigBeanCache;
import org.eweb4j.cache.DBInfoConfigBeanCache;
import org.eweb4j.cache.IOCConfigBeanCache;
import org.eweb4j.cache.ORMConfigBeanCache;
import org.eweb4j.cache.Props;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.CheckConfigBean;
import org.eweb4j.config.ConfigBeanCreator;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.config.bean.Prop;
import org.eweb4j.ioc.config.IOCConfig;
import org.eweb4j.mvc.config.ActionAnnotationConfig;
import org.eweb4j.mvc.config.ActionConfig;
import org.eweb4j.mvc.config.InterceptorAnnotationConfig;
import org.eweb4j.mvc.config.InterceptorConfig;
import org.eweb4j.orm.config.ORMConfig;
import org.eweb4j.orm.config.PojoAnnotationConfig;
import org.eweb4j.orm.dao.DAOFactory;
import org.eweb4j.orm.dao.config.DAOConfig;
import org.eweb4j.orm.dao.config.bean.DBInfoConfigBean;
import org.eweb4j.orm.dao.update.UpdateDAO;
import org.eweb4j.orm.jdbc.transaction.Trans;
import org.eweb4j.orm.jdbc.transaction.Transaction;
import org.eweb4j.orm.sql.Model2Table;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.FileUtil;
import org.eweb4j.util.xml.BeanXMLUtil;
import org.eweb4j.util.xml.XMLReader;
import org.eweb4j.util.xml.XMLWriter;

public class EWeb4JConfig {
    private static Log log = LogFactory.getLogger(EWeb4JConfig.class, true);

    public static synchronized String start() {
        return EWeb4JConfig.start(ConfigConstant.START_FILE_NAME);
    }

    public static synchronized String start(String fileName) {
        EWeb4JConfig.setSTART_FILE_NAME(fileName);
        return EWeb4JConfig.startByAbFile(ConfigConstant.START_FILE_PATH());
    }

    public static synchronized String start(ConfigBean config) {
        String error = EWeb4JConfig._start(null, config);
        EWeb4JConfig._done(error);
        return error;
    }

    private static synchronized String startByAbFile(String aStartXmlPath) {
        ConfigBean cb;
        String startXmlPath = aStartXmlPath;
        String error = null;
        File file = null;
        boolean readXml = true;
        if ("successStart".equals(String.valueOf(SingleBeanCache.get("successStart")))) {
            String reload;
            cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
            String string = reload = cb == null ? "true" : cb.getReload();
            if ("true".equals(reload) || "1".equals(reload)) {
                SingleBeanCache.clear();
                ORMConfigBeanCache.clear();
                IOCConfigBeanCache.clear();
                ActionConfigBeanCache.clear();
                log.debug("EWeb4J clear cache");
                readXml = true;
            } else {
                readXml = false;
            }
        }
        if (readXml) {
            try {
                file = new File(startXmlPath);
                cb = null;
                boolean readFile = true;
                String check = ConfigConstant.CHECK_START_FILE_EXIST;
                if (!(file.exists() || "true".equals(check) || "1".equals(check))) {
                    log.warn("Skip the Start Configuation file !!!");
                    cb = ConfigBeanCreator.create();
                    readFile = false;
                }
                if (readFile) {
                    XMLReader reader = BeanXMLUtil.getBeanXMLReader(file);
                    reader.setBeanName("eweb4j");
                    reader.setClass("eweb4j", ConfigBean.class);
                    cb = (ConfigBean)reader.readOne();
                }
                error = EWeb4JConfig._start(error, cb);
            }
            catch (Throwable e) {
                try {
                    FileUtil.copy(file, new File(String.valueOf(startXmlPath) + ".back" + "_" + CommonUtil.getNowTime("MMddHHmmss")));
                    XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(file, (Object)ConfigBeanCreator.create());
                    writer.setBeanName("eweb4j");
                    writer.setClass("eweb4j", ConfigBean.class);
                    writer.write();
                    String info = "configuration error, now it has repaired.";
                    error = String.valueOf(CommonUtil.getNowTime()) + "EWeb4JConfig : " + info + "exception\uff1a" + CommonUtil.getExceptionString(e);
                    log.error(info, e);
                }
                catch (Throwable e1) {
                    String info = "can not write any configuration";
                    error = String.valueOf(CommonUtil.getNowTime()) + "EWeb4JConfig : " + info + "exception\uff1a" + CommonUtil.getExceptionString(e1);
                    log.fatal(info, e);
                }
            }
            EWeb4JConfig._done(error);
        }
        return error;
    }

    private static void _done(String error) {
        if (error != null) {
            SingleBeanCache.clear();
            ORMConfigBeanCache.clear();
            IOCConfigBeanCache.clear();
            ActionConfigBeanCache.clear();
            log.error(error);
        } else {
            SingleBeanCache.add("successStart", "successStart");
        }
    }

    private static String _start(String error, ConfigBean cb) {
        if (cb == null) {
            error = " can not read any configuration info! But now have bean repaired, please restart.";
        } else {
            String error8;
            String error7;
            String error6;
            String error5;
            String error4;
            String error3;
            String error2;
            StringBuilder infos = new StringBuilder("EWeb4JConfig.start \n");
            infos.append("start-config-xml-path --> ").append(ConfigConstant.START_FILE_PATH()).append("\n");
            infos.append("${RootPath} --> ").append(ConfigConstant.ROOT_PATH).append("\n");
            infos.append(cb).append("\n");
            log.debug(infos.toString());
            String error1 = CheckConfigBean.checkEWeb4JConfigBean(cb);
            if (error1 != null) {
                error = error1;
            }
            if ((error2 = CheckConfigBean.checkEWeb4JIOCPart(cb.getIoc())) != null) {
                error = error == null ? error2 : String.valueOf(error) + error2;
            }
            if ((error3 = CheckConfigBean.checkIOCXml(cb.getIoc().getIocXmlFiles())) != null) {
                error = error == null ? error3 : String.valueOf(error) + error3;
            }
            if ((error4 = CheckConfigBean.checkEWeb4JORMPart(cb.getOrm())) != null) {
                error = error == null ? error4 : String.valueOf(error) + error4;
            }
            if ((error5 = CheckConfigBean.checkORMXml(cb.getOrm().getOrmXmlFiles())) != null) {
                error = error == null ? error5 : String.valueOf(error) + error5;
            }
            if ((error6 = CheckConfigBean.checkEWeb4JMVCPart(cb.getMvc())) != null) {
                error = error == null ? error6 : String.valueOf(error) + error6;
            }
            if ((error7 = CheckConfigBean.checkMVCActionXmlFile(cb.getMvc().getActionXmlFiles())) != null) {
                error = error == null ? error7 : String.valueOf(error) + error7;
            }
            if ((error8 = CheckConfigBean.checkInter(cb.getMvc().getInterXmlFiles())) != null) {
                error = error == null ? error8 : String.valueOf(error) + error8;
            }
            if (error == null) {
                SingleBeanCache.add(ConfigBean.class.getName(), cb);
                String info = "EWeb4J start configuration info have bean validated and pushed to the cache. ";
                log.debug(info);
                String error13 = null;
                try {
                    for (Prop f : cb.getProperties().getFile()) {
                        error13 = Props.readProperties(f, true);
                        if (error13 == null) continue;
                        error = error == null ? error13 : String.valueOf(error) + error13;
                    }
                }
                catch (Throwable e) {
                    log.warn(e.toString(), e);
                    error = error == null ? e.toString() : String.valueOf(error) + e.toString();
                }
                if (error == null) {
                    log.debug("properties module -> ok");
                }
                if (error == null && ("true".equals(cb.getIoc().getOpen()) || "1".equals(cb.getIoc().getOpen()))) {
                    String error10 = IOCConfig.check();
                    if (error10 != null) {
                        error = error10;
                    }
                    if (error == null) {
                        log.debug("ioc module -> ok");
                    }
                }
                if (error == null && ("true".equals(cb.getOrm().getOpen()) || "1".equals(cb.getOrm().getOpen()))) {
                    String error14 = DAOConfig.check();
                    if (error14 != null) {
                        error = error14;
                    }
                    if (error == null) {
                        log.debug("orm.dao module -> ok");
                        String error10 = new PojoAnnotationConfig().readAnnotation(cb.getOrm().getScanPojoPackage().getPath());
                        if (error10 != null) {
                            error = error10;
                        }
                        if (error == null) {
                            File sqlFile;
                            DBInfoConfigBean dcb;
                            log.debug("orm.pojo.annotation module -> ok");
                            String error11 = ORMConfig.check();
                            if (error11 != null) {
                                error = error11;
                            }
                            if (error == null) {
                                log.debug("orm.pojo.xml module -> ok");
                            }
                            if (error == null && ("true".equals(cb.getOrm().getDdl().getGenerate()) || "1".equals(cb.getOrm().getDdl().getGenerate()))) {
                                log.debug("ddl.generate -> true");
                                dcb = DBInfoConfigBeanCache.get(cb.getOrm().getDdl().getDs());
                                if ("MYSQL".equals(dcb.getDataBaseType())) {
                                    sqlFile = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH()) + cb.getOrm().getDdl().getDs() + "-create.sql");
                                    if ("1".equals(cb.getOrm().getDdl().getOverride()) || "true".equals(cb.getOrm().getDdl().getOverride()) || !sqlFile.exists()) {
                                        String errr12 = Model2Table.write(cb.getOrm().getDdl().getDs());
                                        if (errr12 != null) {
                                            error = errr12;
                                        } else {
                                            log.debug("ddl.generate execute success -> " + sqlFile.getAbsolutePath());
                                        }
                                    } else {
                                        log.warn("ddl.generate do not need to execute ->" + sqlFile.getAbsolutePath() + " is exists !");
                                    }
                                } else {
                                    log.warn("sorry only mysql db can use the ddl feature !");
                                }
                                if (error == null) {
                                    log.debug("orm.ddl.generate module -> ok");
                                }
                            }
                            if (error == null && ("true".equals(cb.getOrm().getDdl().getRun()) || "1".equals(cb.getOrm().getDdl().getRun()))) {
                                block65: {
                                    log.debug("ddl.run -> true");
                                    dcb = DBInfoConfigBeanCache.get(cb.getOrm().getDdl().getDs());
                                    if (dcb != null) {
                                        if ("MYSQL".equals(dcb.getDataBaseType())) {
                                            sqlFile = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH()) + cb.getOrm().getDdl().getDs() + "-create.sql");
                                            StringBuilder builder = new StringBuilder();
                                            BufferedReader sql_reader = null;
                                            try {
                                                try {
                                                    sql_reader = new BufferedReader(new InputStreamReader(new FileInputStream(sqlFile)));
                                                    String line = null;
                                                    while ((line = sql_reader.readLine()) != null) {
                                                        builder.append(line);
                                                    }
                                                    final String[] sqls = builder.toString().split(";");
                                                    final UpdateDAO dao = DAOFactory.getUpdateDAO(cb.getOrm().getDdl().getDs());
                                                    Transaction.execute(new Trans(){

                                                        public void run(Object ... args) throws Exception {
                                                            String[] stringArray = sqls;
                                                            int n = sqls.length;
                                                            int n2 = 0;
                                                            while (n2 < n) {
                                                                String sql = stringArray[n2];
                                                                log.debug("ddl run -> " + sql);
                                                                dao.updateBySQL(sql);
                                                                ++n2;
                                                            }
                                                        }
                                                    }, new Object[0]);
                                                }
                                                catch (Exception e) {
                                                    String _error13 = CommonUtil.getExceptionString(e);
                                                    if (_error13 != null) {
                                                        error = _error13;
                                                    }
                                                    if (sql_reader != null) {
                                                        try {
                                                            sql_reader.close();
                                                        }
                                                        catch (IOException e2) {
                                                            e2.printStackTrace();
                                                        }
                                                    }
                                                    break block65;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                if (sql_reader != null) {
                                                    try {
                                                        sql_reader.close();
                                                    }
                                                    catch (IOException e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                                throw throwable;
                                            }
                                            if (sql_reader != null) {
                                                try {
                                                    sql_reader.close();
                                                }
                                                catch (IOException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        } else {
                                            log.warn("sorry only mysql db can use the ddl feature !");
                                        }
                                    } else {
                                        log.error("ddl.ds -> " + cb.getOrm().getDdl().getDs() + " not found !");
                                    }
                                }
                                if (error == null) {
                                    log.debug("orm.ddl.run module -> ok");
                                }
                            }
                        }
                    }
                    if (error == null) {
                        log.debug("orm module -> ok ");
                    }
                }
                if (error == null && ("true".equals(cb.getMvc().getOpen()) || "1".equals(cb.getMvc().getOpen()))) {
                    String error20 = new ActionAnnotationConfig().readAnnotation(cb.getMvc().getScanActionPackage().getPath());
                    if (error20 != null) {
                        error = String.valueOf(error) + error20;
                    }
                    log.debug("mvc.action.annotation module -> ok");
                    String error11 = ActionConfig.check();
                    if (error11 != null) {
                        error = error11;
                    }
                    if (error == null) {
                        log.debug("mvc.action.xml module -> ok");
                        String error12 = new InterceptorAnnotationConfig().readAnnotation(cb.getMvc().getScanInterceptorPackage().getPath());
                        if (error12 != null) {
                            error = error12;
                        }
                        if (error == null) {
                            log.debug("mvc.action.interceptor.annotation module -> ok");
                            String error21 = InterceptorConfig.check();
                            if (error21 != null) {
                                error = error21;
                            }
                            if (error == null) {
                                log.debug("mvc.action.interceptor.xml module -> ok");
                            }
                        }
                    }
                    if (error == null) {
                        log.debug("mvc module -> ok");
                    }
                }
            }
        }
        return error;
    }

    public static void createStartXml(String path, ConfigBean cb) throws Exception {
        XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH()) + path), (Object)cb);
        writer.setBeanName("eweb4j");
        writer.setClass("eweb4j", ConfigBean.class);
        writer.write();
    }

    public static String about() {
        return "EWeb4J Framework 1.9.2-SNAPSHOT";
    }

    public static void setSTART_FILE_NAME(String START_FILE_NAME) {
        if (START_FILE_NAME == null || START_FILE_NAME.trim().length() == 0) {
            return;
        }
        ConfigConstant.START_FILE_NAME = START_FILE_NAME;
    }

    public static void setCONFIG_BASE_PATH(String CONFIG_BASE_PATH) {
        if (CONFIG_BASE_PATH == null || CONFIG_BASE_PATH.trim().length() == 0) {
            return;
        }
        ConfigConstant.CONFIG_BASE_PATH = CONFIG_BASE_PATH;
    }

    public static void setCHECK_START_FILE_EXIST(String CHECK_START_FILE_EXIST) {
        if (CHECK_START_FILE_EXIST == null || CHECK_START_FILE_EXIST.trim().length() == 0) {
            return;
        }
        ConfigConstant.CHECK_START_FILE_EXIST = CHECK_START_FILE_EXIST;
    }
}

