/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc;

import java.io.IOException;
import java.util.Map;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.Crud;
import org.eweb4j.mvc.action.Validation;
import org.eweb4j.mvc.validator.annotation.Int;
import org.eweb4j.mvc.validator.annotation.Required;
import org.eweb4j.mvc.validator.annotation.Size;
import org.eweb4j.mvc.view.DivPageComp;
import org.eweb4j.util.JsonConverter;
import org.eweb4j.util.xml.BeanXMLUtil;
import org.eweb4j.util.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller
implements Crud {
    private static final String PAGE_MESS = "\u5206\u9875\u53c2\u6570\u5fc5\u987b\u662f\u6574\u6570\u683c\u5f0f";
    private static final String PAGE_UP_MESS = "\u5206\u9875\u53c2\u6570\u5fc5\u987b\u5927\u4e8e 0 ";
    protected static final String SUCCESS = "success";
    @Required
    @Size(min=1)
    @Int
    protected Long id;
    @Int(mess="\u5206\u9875\u53c2\u6570\u5fc5\u987b\u662f\u6574\u6570\u683c\u5f0f")
    @Size(min=1, mess="\u5206\u9875\u53c2\u6570\u5fc5\u987b\u5927\u4e8e 0 ")
    protected int pageNum = 1;
    @Int(mess="\u5206\u9875\u53c2\u6570\u5fc5\u987b\u662f\u6574\u6570\u683c\u5f0f")
    @Size(min=1, mess="\u5206\u9875\u53c2\u6570\u5fc5\u987b\u5927\u4e8e 0 ")
    protected int numPerPage = 10;
    protected String keyword = "";
    protected Context context;
    protected DivPageComp dpc = null;

    private String render(String template) {
        return template;
    }

    private String render(String template, String[] names, Object ... objs) {
        int i = 0;
        while (i < names.length) {
            this.context.getModel().put(names[i], objs[i]);
            ++i;
        }
        return template;
    }

    protected String render(String template, String names, Object ... objs) {
        return this.render(template, names.split(","), objs);
    }

    protected String renderFMT(String template) {
        return "fmt:" + this.render(template);
    }

    protected String renderFMT(String template, String[] names, Object ... objs) {
        return "fmt:" + this.render(template, names, objs);
    }

    protected String renderFMT(String template, String names, Object ... objs) {
        return "fmt:" + this.render(template, names, objs);
    }

    protected String renderJSP(String template) {
        return "forward:" + this.render(template);
    }

    protected String renderJSP(String template, String[] names, Object ... objs) {
        return "forward:" + this.render(template, names, objs);
    }

    protected String renderJSP(String template, String names, Object ... objs) {
        return "forward:" + this.render(template, names, objs);
    }

    protected void renderJSON(Object obj) {
        try {
            this.context.getResponse().setContentType("application/json");
            this.context.getWriter().print(JsonConverter.convert(obj));
            this.context.getWriter().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void renderXML(Object obj) {
        try {
            Class<?> cls = obj.getClass();
            XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(obj);
            writer.setSubNameAuto(true);
            writer.setClass(cls);
            writer.setRootElementName(null);
            this.context.getResponse().setContentType("application/xml");
            this.context.getWriter().print(writer.toXml());
            this.context.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String render404() {
        this.context.getResponse().setStatus(404);
        return "forward:errors/404.html";
    }

    protected String renderRedirect(String path) {
        return "redirect:" + path;
    }

    protected String renderAction(String uri, String httpMethod, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> en : params.entrySet()) {
            String name = en.getKey();
            String value = en.getValue();
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(name).append("=").append(value);
        }
        if (sb.length() > 0) {
            sb.insert(0, "?");
        }
        return "action:" + uri + "@" + httpMethod + sb.toString();
    }

    protected Map<String, Object> getModel() {
        return this.context.getModel();
    }

    protected Validation getValidation() {
        return this.context.getValidation();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getNumPerPage() {
        return this.numPerPage;
    }

    public void setNumPerPage(int numPerPage) {
        this.numPerPage = numPerPage;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public DivPageComp getDpc() {
        return this.dpc;
    }
}

