/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.validator;

import java.util.HashMap;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.action.Validation;
import org.eweb4j.mvc.config.bean.FieldConfigBean;
import org.eweb4j.mvc.config.bean.ValidatorConfigBean;
import org.eweb4j.mvc.validator.ValidatorIF;

public class ValidatorHelper
implements ValidatorIF {
    private String regex;

    public ValidatorHelper(String regex) {
        this.regex = regex;
    }

    public Validation validate(ValidatorConfigBean val, Context context) {
        HashMap<String, String> valError = new HashMap<String, String>();
        for (FieldConfigBean f : val.getField()) {
            String fieldName = f.getName();
            String[] value = context.getQueryParamMap().get(fieldName);
            if (value == null || value.length == 0) continue;
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.matches(this.regex)) {
                    String mess = f.getMessage();
                    if (mess.length() == 0) {
                        mess = " %s-validator : your input { %s = %s } must matches [ %s ]";
                    }
                    valError.put(fieldName, String.format(mess, val.getName(), fieldName, v, this.regex));
                    break;
                }
                ++n2;
            }
            context.getRequest().setAttribute(fieldName, (Object)value);
        }
        Validation validation = new Validation();
        if (!valError.isEmpty()) {
            validation.getErrors().put(val.getName(), valError);
        }
        return validation;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

