/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm;

import java.lang.reflect.Method;
import java.util.Collection;
import org.eweb4j.orm.Cascade;
import org.eweb4j.orm.CascadeImpl;
import org.eweb4j.orm.IModel;
import org.eweb4j.orm.Query;
import org.eweb4j.orm.QueryImpl;
import org.eweb4j.orm.annotation.Ignore;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.dao.DAO;
import org.eweb4j.orm.dao.DAOFactory;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelHelper<T>
implements IModel<T> {
    private T model;
    private ReflectUtil ru;
    @Ignore
    private String dsName = null;

    public ModelHelper(T model) {
        this.model = model;
        this.ru = new ReflectUtil(this.model);
    }

    @Override
    public void setDataSourceName(String dsName) {
        this.dsName = dsName;
    }

    @Override
    public DAO dao() {
        return DAOFactory.getDAO(this.model.getClass(), this.dsName);
    }

    @Override
    public boolean create(String ... field) {
        Number id = field != null && field.length > 0 ? (Number)DAOFactory.getInsertDAO(this.dsName).insertByField(this.model, field) : (Number)DAOFactory.getInsertDAO(this.dsName).insert(this.model);
        if (id == null || (Integer)id == -1) {
            return false;
        }
        this._setId(Long.parseLong("" + id));
        return true;
    }

    @Override
    public T save(String ... field) {
        Long id = this._getId();
        if (id != null && id > 0L) {
            if (field != null && field.length > 0) {
                DAOFactory.getUpdateDAO(this.dsName).updateByFields(this.model, field);
            } else {
                DAOFactory.getUpdateDAO(this.dsName).update(this.model);
            }
        } else {
            this.create(field);
        }
        return this.model;
    }

    @Override
    public boolean delete() {
        Long id = this._getId();
        if (id == null || id <= 0L) {
            return false;
        }
        Number rows = DAOFactory.getDeleteDAO(this.dsName).deleteById(this.model);
        return rows != null && (Integer)rows != -1;
    }

    @Override
    public void load() {
        Long id = this._getId();
        if (id == null || id <= 0L) {
            return;
        }
        ReflectUtil ru = new ReflectUtil(this.model);
        T _model = DAOFactory.getSelectDAO(this.dsName).selectOneById(this.model);
        if (_model == null) {
            return;
        }
        ReflectUtil _ru = new ReflectUtil(_model);
        String[] stringArray = ru.getFieldsName();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method _getter;
            String field = stringArray[n2];
            Method setter = ru.getSetter(field);
            if (setter != null && (_getter = _ru.getGetter(field)) != null) {
                try {
                    setter.invoke(this.model, _getter.invoke(_model, new Object[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        String[] fields = ORMConfigBeanUtil.getToOneField(this.model.getClass());
        if (fields != null && fields.length > 0) {
            DAOFactory.getCascadeDAO(this.dsName).select(this.model, fields);
        }
    }

    @Override
    public Number delete(String query, Object ... params) {
        return DAOFactory.getDeleteDAO(this.dsName).deleteWhere(this.model.getClass(), query, params);
    }

    @Override
    public Number deleteAll() {
        return DAOFactory.getDAO(this.model.getClass(), this.dsName).delete().execute();
    }

    @Override
    public T findById(long id) {
        Object t = DAOFactory.getSelectDAO(this.dsName).selectOneById(this.model.getClass(), id);
        String[] fields = ORMConfigBeanUtil.getToOneField(this.model.getClass());
        if (fields != null && fields.length > 0) {
            DAOFactory.getCascadeDAO(this.dsName).select(t, fields);
        }
        return (T)t;
    }

    @Override
    public Query find() {
        Class<?> clazz = this.model.getClass();
        DAO dao = DAOFactory.getDAO(clazz, this.dsName);
        dao.selectAll();
        QueryImpl _query = new QueryImpl(dao);
        return _query;
    }

    @Override
    public Query find(String query, Object ... params) {
        Class<?> clazz = this.model.getClass();
        DAO dao = DAOFactory.getDAO(clazz, this.dsName);
        dao.selectAll().where().append(query).fillArgs(params);
        QueryImpl _query = new QueryImpl(dao);
        return _query;
    }

    @Override
    public Collection<T> findAll() {
        return this.find().fetch();
    }

    @Override
    public long count() {
        return DAOFactory.getSelectDAO().selectCount(this.model.getClass());
    }

    @Override
    public long count(String query, Object ... params) {
        return DAOFactory.getSelectDAO(this.dsName).selectCount(this.model.getClass(), query, params);
    }

    @Override
    public Cascade cascade() {
        return new CascadeImpl<T>(DAOFactory.getCascadeDAO(this.dsName), this.model);
    }

    public Long _getId() {
        Object _id;
        block3: {
            try {
                _id = ORMConfigBeanUtil.getIdVal(this.model);
                if (_id != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return (Long)_id;
    }

    public void _setId(long id) {
        String idField = ORMConfigBeanUtil.getIdField(this.model);
        if (idField == null) {
            return;
        }
        try {
            Method setter = this.ru.getSetter(idField);
            setter.invoke(this.model, id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public T getModel() {
        return this.model;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }
}

