/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm;

import java.util.Collection;
import org.eweb4j.orm.Page;
import org.eweb4j.orm.dao.DAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PageImpl<T>
implements Page<T> {
    private final int pageIndex;
    private final int pageSize;
    private final DAO owner;
    private Collection<T> pojos;
    private Long totalCount;
    private Long totalPageCount;

    public PageImpl(int pageIndex, int pageSize, DAO owner) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.owner = owner;
    }

    @Override
    public synchronized Collection<T> getList() {
        if (this.pojos == null) {
            this.pojos = this.owner.query(this.pageIndex, this.pageSize);
        }
        return this.pojos;
    }

    @Override
    public synchronized long getTotalRowCount() {
        if (this.totalCount == null) {
            this.totalCount = this.owner.count();
        }
        return this.totalCount;
    }

    @Override
    public synchronized long getTotalPageCount() {
        long all = this.getTotalRowCount();
        if (this.pageSize == 0) {
            return 0L;
        }
        if (this.totalPageCount == null) {
            this.totalPageCount = all / (long)this.pageSize + (long)(all % (long)this.pageSize > 0L ? 1 : 0);
        }
        return this.totalPageCount;
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public boolean hasNext() {
        return this.getTotalPageCount() > (long)this.pageIndex;
    }

    @Override
    public boolean hasPrev() {
        return this.pageIndex > 1;
    }

    @Override
    public Page<T> next() {
        return this.owner.getPage(this.pageIndex + 1, this.pageSize);
    }

    @Override
    public Page<T> prev() {
        return this.owner.getPage(this.pageIndex - 1, this.pageSize);
    }

    @Override
    public String getDisplayXtoYofZ(String to, String of) {
        return null;
    }
}

