/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.cascade;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.eweb4j.orm.dao.cascade.ManyToManyDAO;
import org.eweb4j.orm.dao.cascade.OneToManyDAO;
import org.eweb4j.orm.dao.cascade.ToOneDAO;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeDAO {
    private ToOneDAO oneToOne = null;
    private OneToManyDAO oneToMany = null;
    private ManyToManyDAO manyToMany = null;

    public CascadeDAO(String dsName) {
        this.oneToOne = new ToOneDAO(dsName);
        this.oneToMany = new OneToManyDAO(dsName);
        this.manyToMany = new ManyToManyDAO(dsName);
    }

    public <T> void select(T[] t) {
        this.cascade(t, null, 1);
    }

    public <T> void select(T t) {
        this.cascade(new Object[]{t}, null, 1);
    }

    public <T> void delete(T[] t) {
        this.cascade(t, null, 2);
    }

    public <T> void insert(T[] t) {
        this.cascade(t, null, 3);
    }

    public <T> void insert(T t) {
        this.cascade(new Object[]{t}, null, 3);
    }

    public <T> void update(T[] t, long newIdVal) {
        this.cascade(t, null, 4, newIdVal);
    }

    public <T> void update(T t, long newIdVal) {
        this.update((T)new Object[]{t}, newIdVal);
    }

    public <T> void select(T[] t, String fieldName) {
        this.cascade(t, new String[]{fieldName}, 1);
    }

    public <T> void select(T t, String fieldName) {
        this.cascade(new Object[]{t}, new String[]{fieldName}, 1);
    }

    public <T> void delete(T[] t, String fieldName) {
        this.delete((T)t, new String[]{fieldName});
    }

    public <T> void delete(T t, String fieldName) {
        this.delete((T)new Object[]{t}, new String[]{fieldName});
    }

    public <T> void insert(T[] t, String fieldName) {
        this.cascade(t, new String[]{fieldName}, 3);
    }

    public <T> void insert(T t, String fieldName) {
        this.cascade(new Object[]{t}, new String[]{fieldName}, 3);
    }

    public <T> void update(T[] t, String fieldName, long newIdVal) {
        this.cascade(t, new String[]{fieldName}, 4, newIdVal);
    }

    public <T> void update(T t, String fieldName, long newIdVal) {
        this.cascade(new Object[]{t}, new String[]{fieldName}, 4, newIdVal);
    }

    public <T> void select(T[] t, String ... fieldNames) {
        this.cascade(t, fieldNames, 1);
    }

    public <T> void select(T t, String ... fieldNames) {
        this.cascade(new Object[]{t}, fieldNames, 1);
    }

    public <T> void delete(T[] t, String ... fieldNames) {
        this.cascade(t, fieldNames, 2);
    }

    public <T> void delete(T t, String ... fieldNames) {
        this.cascade(new Object[]{t}, fieldNames, 2);
    }

    public <T> void insert(T[] t, String ... fieldNames) {
        this.cascade(t, fieldNames, 3);
    }

    public <T> void insert(T t, String ... fieldNames) {
        this.cascade(new Object[]{t}, fieldNames, 3);
    }

    public <T> void update(T[] t, long newIdVal, String ... fieldNames) {
        this.cascade(t, fieldNames, 4, newIdVal);
    }

    public <T> void update(T t, long newIdVal, String ... fieldNames) {
        this.cascade(new Object[]{t}, fieldNames, 4, newIdVal);
    }

    public <T> void cascade(T[] ts, String[] fieldNames, int type) {
        this.cascade(ts, fieldNames, type, -1L);
    }

    public <T> void cascade(T[] ts, String[] fieldNames, int type, long newIdVal) {
        if (ts == null || ts.length == 0) {
            return;
        }
        T[] TArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t != null) {
                Class<?> clazz = t.getClass();
                String clsName = clazz.getSimpleName();
                Entity entity = clazz.getAnnotation(Entity.class);
                if (!(entity != null || clsName.endsWith("PO") || clsName.endsWith("POJO") || clsName.endsWith("Entity") || clsName.endsWith("Model"))) {
                    return;
                }
                ReflectUtil ru = new ReflectUtil(t);
                Field[] fields = null;
                if (fieldNames == null || fieldNames.length == 0) {
                    fields = ru.getFields();
                } else {
                    ArrayList<Field> fieldList = new ArrayList<Field>();
                    String[] stringArray = fieldNames;
                    int n3 = fieldNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Field f;
                        String n5 = stringArray[n4];
                        if (n5 != null && !"".equals(n5.trim()) && (f = ru.getField(n5)) != null) {
                            fieldList.add(f);
                        }
                        ++n4;
                    }
                    if (fieldList.size() > 0) {
                        fields = fieldList.toArray(new Field[0]);
                    }
                }
                if (fields != null) {
                    ArrayList<Field> oneList = new ArrayList<Field>();
                    ArrayList<Field> manyList = new ArrayList<Field>();
                    ArrayList<Field> manyManyList = new ArrayList<Field>();
                    Field[] fieldArray = fields;
                    int n6 = fields.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Field f = fieldArray[n7];
                        Method getter = ru.getGetter(f.getName());
                        if (f.isAnnotationPresent(OneToMany.class) || getter != null && getter.isAnnotationPresent(OneToMany.class)) {
                            manyList.add(f);
                        } else if (f.isAnnotationPresent(ManyToOne.class) || getter != null && getter.isAnnotationPresent(ManyToOne.class)) {
                            oneList.add(f);
                        } else if (f.isAnnotationPresent(OneToOne.class) || getter != null && getter.isAnnotationPresent(OneToOne.class)) {
                            oneList.add(f);
                        } else if (f.isAnnotationPresent(ManyToMany.class) || getter != null && getter.isAnnotationPresent(ManyToMany.class)) {
                            manyManyList.add(f);
                        }
                        ++n7;
                    }
                    this.manyToMany.init(t, manyManyList);
                    this.oneToMany.init(t, manyList);
                    this.oneToOne.init(t, oneList);
                    switch (type) {
                        case 1: {
                            this.manyToMany.select();
                            this.oneToMany.select();
                            this.oneToOne.select();
                            break;
                        }
                        case 2: {
                            this.manyToMany.delete();
                            this.oneToMany.delete();
                            break;
                        }
                        case 3: {
                            this.manyToMany.insert();
                            this.oneToMany.insert();
                            break;
                        }
                        case 4: {
                            this.oneToMany.update(newIdVal);
                            this.manyToMany.update(newIdVal);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

