/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.cascade;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.eweb4j.orm.Models;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.DAOFactory;
import org.eweb4j.orm.jdbc.transaction.Trans;
import org.eweb4j.orm.jdbc.transaction.Transaction;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyDAO {
    private String dsName;
    private Object t;
    private List<Field> fields;
    private ReflectUtil ru;
    private String idVal;
    private String table;

    public OneToManyDAO(String dsName) {
        this.dsName = dsName;
    }

    public void init(Object t, List<Field> fields) throws DAOException {
        this.t = t;
        this.fields = fields;
        this.ru = new ReflectUtil(this.t);
        this.table = ORMConfigBeanUtil.getTable(this.t.getClass(), true);
        String idField = ORMConfigBeanUtil.getIdField(this.t.getClass());
        Method idGetter = this.ru.getGetter(idField);
        Object idVal = null;
        if (idGetter != null) {
            try {
                idVal = idGetter.invoke(this.t, new Object[0]);
                this.idVal = idVal == null ? null : String.valueOf(idVal);
            }
            catch (Exception e) {
                throw new DAOException(idGetter + " invoke exception ", e);
            }
        }
    }

    public void insert() throws DAOException {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        final Class<?> ownClass = this.ru.getObject().getClass();
        Transaction.execute(new Trans(){

            public void run(Object ... args) throws Exception {
                if (OneToManyDAO.this.idVal == null || "0".equals(OneToManyDAO.this.idVal) || "".equals(OneToManyDAO.this.idVal)) {
                    Number _idVal = DAOFactory.getInsertDAO(OneToManyDAO.this.dsName).insert(OneToManyDAO.this.t);
                    if (_idVal == null || _idVal.intValue() <= 0) {
                        throw new Exception("can not inster the main obj into db");
                    }
                } else if (DAOFactory.getSelectDAO(OneToManyDAO.this.dsName).selectOneById(OneToManyDAO.this.t) == null) {
                    throw new Exception("the main object'id val is invalid!");
                }
                String fromRefVal = null;
                for (Field f : OneToManyDAO.this.fields) {
                    Method fGetter = OneToManyDAO.this.ru.getGetter(f.getName());
                    if (fGetter == null) continue;
                    OneToMany oneToMany = null;
                    if (f.isAnnotationPresent(OneToMany.class)) {
                        oneToMany = f.getAnnotation(OneToMany.class);
                    } else {
                        if (!fGetter.isAnnotationPresent(OneToMany.class)) continue;
                        oneToMany = fGetter.getAnnotation(OneToMany.class);
                    }
                    Class<?> tarClass = oneToMany.targetEntity();
                    if (Void.TYPE.isAssignableFrom(tarClass)) {
                        tarClass = ClassUtil.getGenericType(f);
                    }
                    List fList = null;
                    try {
                        fList = (List)fGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new DAOException(fGetter + " invoke exception ", e);
                    }
                    if (fList == null) continue;
                    int i = 0;
                    while (i < fList.size()) {
                        Object tarObj = fList.get(i);
                        if (tarObj != null) {
                            ReflectUtil tarRu = new ReflectUtil(tarObj);
                            String mappedBy = oneToMany.mappedBy();
                            if (mappedBy != null && mappedBy.trim().length() > 0) {
                                Method ownFieldSetter = tarRu.getSetter(mappedBy);
                                if (ownFieldSetter != null) {
                                    ownFieldSetter.invoke(tarObj, OneToManyDAO.this.ru.getObject());
                                    Models.inst(tarObj).create(new String[0]);
                                }
                            } else {
                                JoinColumn[] froms;
                                JoinTable joinTable = null;
                                if (f.isAnnotationPresent(JoinTable.class)) {
                                    joinTable = f.getAnnotation(JoinTable.class);
                                } else if (fGetter.isAnnotationPresent(JoinTable.class)) {
                                    joinTable = fGetter.getAnnotation(JoinTable.class);
                                } else {
                                    Field[] fieldArray = tarRu.getFields();
                                    int n = fieldArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Method ownFieldSetter;
                                        Field tarObjField = fieldArray[n2];
                                        if (tarObjField.getType().getName().equals(ownClass.getName()) && (ownFieldSetter = tarRu.getSetter(tarObjField.getName())) != null) {
                                            ownFieldSetter.invoke(tarObj, OneToManyDAO.this.ru.getObject());
                                            Models.inst(tarObj).create(new String[0]);
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                                if (joinTable != null && (froms = joinTable.joinColumns()) != null && froms.length != 0) {
                                    String from = froms[0].name();
                                    JoinColumn[] tos = joinTable.inverseJoinColumns();
                                    if (tos != null && tos.length != 0) {
                                        String to = tos[0].name();
                                        String relTable = joinTable.name();
                                        String fromRefCol = froms[0].referencedColumnName();
                                        if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                                            fromRefCol = ORMConfigBeanUtil.getIdColumn(OneToManyDAO.this.t);
                                        }
                                        String fromRefField = ORMConfigBeanUtil.getField(OneToManyDAO.this.t.getClass(), fromRefCol);
                                        Method fromRefFieldGetter = OneToManyDAO.this.ru.getGetter(fromRefField);
                                        if (fromRefFieldGetter == null) {
                                            throw new Exception("can not find the 'from ref field -> " + fromRefField + "' of " + OneToManyDAO.this.t.getClass() + " 's getter method");
                                        }
                                        Object _obj = fromRefFieldGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                                        if (_obj != null) {
                                            String toRefField;
                                            Method toRefFieldGetter;
                                            fromRefVal = String.valueOf(_obj);
                                            String toRefCol = tos[0].referencedColumnName();
                                            if (toRefCol == null || toRefCol.trim().length() == 0) {
                                                toRefCol = ORMConfigBeanUtil.getIdColumn(tarClass);
                                            }
                                            if ((toRefFieldGetter = tarRu.getGetter(toRefField = ORMConfigBeanUtil.getField(tarClass, toRefCol))) == null) {
                                                throw new Exception("can not find the 'to ref field -> " + toRefField + "' of " + tarClass + " 's getter method");
                                            }
                                            Object _obj2 = toRefFieldGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                                            if (_obj2 != null) {
                                                String toRefVal = String.valueOf(_obj2);
                                                String _format = "select %s, %s from %s where %s = ? and %s = ? ";
                                                String _sql = String.format(_format, from, to, relTable, from, to);
                                                if (DAOFactory.getSelectDAO(OneToManyDAO.this.dsName).selectBySQL(Map.class, _sql, fromRefVal, toRefVal) == null) {
                                                    String format = "insert into %s(%s, %s) values(?, ?) ;";
                                                    String sql = String.format(format, relTable, from, to);
                                                    DAOFactory.getUpdateDAO(OneToManyDAO.this.dsName).updateBySQLWithArgs(sql, fromRefVal, toRefVal);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }, new Object[0]);
    }

    public void delete() throws DAOException {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        final Class<?> ownClass = this.ru.getObject().getClass();
        Transaction.execute(new Trans(){

            public void run(Object ... args) throws Exception {
                block2: for (Field f : OneToManyDAO.this.fields) {
                    JoinColumn joinCol;
                    OneToMany ann;
                    Method tarGetter = OneToManyDAO.this.ru.getGetter(f.getName());
                    if (tarGetter == null || (ann = tarGetter.getAnnotation(OneToMany.class)) == null && (ann = f.getAnnotation(OneToMany.class)) == null) continue;
                    String mappedBy = ann.mappedBy();
                    Class<?> tarClass = ann.targetEntity();
                    if (Void.TYPE.isAssignableFrom(tarClass)) {
                        tarClass = ClassUtil.getGenericType(f);
                    }
                    List tarList = null;
                    try {
                        tarList = (List)tarGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new DAOException(tarGetter + " invoke exception ", e);
                    }
                    if (tarList == null || tarList.size() == 0) {
                        ReflectUtil tarRu = new ReflectUtil(tarClass);
                        if (mappedBy != null && mappedBy.trim().length() != 0) continue;
                        Field[] fieldArray = tarRu.getFields();
                        int n = fieldArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Method tarObjFieldGetter;
                            Field tarObjField = fieldArray[n2];
                            if (tarObjField.getType().getName().equals(ownClass.getName()) && (tarObjFieldGetter = tarRu.getGetter(tarObjField.getName())) != null) {
                                ManyToOne manyToOne = tarObjField.getAnnotation(ManyToOne.class);
                                if (manyToOne == null) {
                                    manyToOne = tarObjFieldGetter.getAnnotation(ManyToOne.class);
                                }
                                if (manyToOne != null) {
                                    mappedBy = tarObjField.getName();
                                    String fromRefCol = null;
                                    joinCol = tarObjField.getAnnotation(JoinColumn.class);
                                    if (joinCol == null) {
                                        joinCol = tarObjFieldGetter.getAnnotation(JoinColumn.class);
                                    }
                                    if (joinCol != null) {
                                        fromRefCol = joinCol.referencedColumnName();
                                    }
                                    if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                                        fromRefCol = ORMConfigBeanUtil.getIdColumn(OneToManyDAO.this.t);
                                    }
                                    String fromRefField = ORMConfigBeanUtil.getField(ownClass, fromRefCol);
                                    Method fromRefFieldGetter = OneToManyDAO.this.ru.getGetter(fromRefField);
                                    if (fromRefFieldGetter == null) {
                                        throw new Exception("can not find the 'from ref field field -> " + fromRefField + "' of " + ownClass + " 's getter method");
                                    }
                                    String fromRefVal = null;
                                    Object _obj = fromRefFieldGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                                    if (_obj != null) {
                                        fromRefVal = String.valueOf(_obj);
                                    }
                                    DAOFactory.getDeleteDAO(OneToManyDAO.this.dsName).deleteByFieldIsValue(tarClass, new String[]{tarObjField.getName()}, new String[]{fromRefVal});
                                    continue block2;
                                }
                            }
                            ++n2;
                        }
                        continue;
                    }
                    int i = 0;
                    while (i < tarList.size()) {
                        Object tarObjIdVal;
                        Object tarObj = tarList.get(i);
                        if (tarObj != null && (tarObjIdVal = ORMConfigBeanUtil.getIdVal(tarObj)) != null) {
                            ReflectUtil tarRu = new ReflectUtil(tarObj);
                            if (mappedBy != null && mappedBy.trim().length() > 0) {
                                Method ownFieldSetter = tarRu.getSetter(mappedBy);
                                if (ownFieldSetter != null) {
                                    DAOFactory.getDeleteDAO(OneToManyDAO.this.dsName).deleteById(tarObj);
                                }
                            } else {
                                JoinColumn[] froms;
                                JoinTable joinTable = null;
                                if (f.isAnnotationPresent(JoinTable.class)) {
                                    joinTable = f.getAnnotation(JoinTable.class);
                                } else if (tarGetter.isAnnotationPresent(JoinTable.class)) {
                                    joinTable = tarGetter.getAnnotation(JoinTable.class);
                                } else {
                                    joinCol = tarRu.getFields();
                                    int fromRefCol = ((Field[])joinCol).length;
                                    int manyToOne = 0;
                                    while (manyToOne < fromRefCol) {
                                        Method tarObjFieldGetter;
                                        Field tarObjField = joinCol[manyToOne];
                                        if (tarObjField.getType().getName().equals(ownClass.getName()) && (tarObjFieldGetter = tarRu.getGetter(tarObjField.getName())) != null) {
                                            ManyToOne manyToOne2 = tarObjField.getAnnotation(ManyToOne.class);
                                            if (manyToOne2 == null) {
                                                manyToOne2 = tarObjFieldGetter.getAnnotation(ManyToOne.class);
                                            }
                                            if (manyToOne2 != null) {
                                                String fromRefCol2 = null;
                                                JoinColumn joinCol2 = tarObjField.getAnnotation(JoinColumn.class);
                                                if (joinCol2 == null) {
                                                    joinCol2 = tarObjFieldGetter.getAnnotation(JoinColumn.class);
                                                }
                                                if (joinCol2 != null) {
                                                    fromRefCol2 = joinCol2.referencedColumnName();
                                                }
                                                if (fromRefCol2 == null || fromRefCol2.trim().length() == 0) {
                                                    fromRefCol2 = ORMConfigBeanUtil.getIdColumn(OneToManyDAO.this.t);
                                                }
                                                String fromRefField = ORMConfigBeanUtil.getField(ownClass, fromRefCol2);
                                                Method fromRefFieldGetter = OneToManyDAO.this.ru.getGetter(fromRefField);
                                                if (fromRefFieldGetter == null) {
                                                    throw new Exception("can not find the 'from ref field field -> " + fromRefField + "' of " + ownClass + " 's getter method");
                                                }
                                                String fromRefVal = null;
                                                Object _obj = fromRefFieldGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                                                if (_obj != null) {
                                                    fromRefVal = String.valueOf(_obj);
                                                }
                                                DAOFactory.getDeleteDAO(OneToManyDAO.this.dsName).deleteByFieldIsValue(tarClass, new String[]{tarObjField.getName()}, new String[]{fromRefVal});
                                                break;
                                            }
                                        }
                                        ++manyToOne;
                                    }
                                }
                                if (joinTable != null && (froms = joinTable.joinColumns()) != null && froms.length != 0) {
                                    String from = froms[0].name();
                                    JoinColumn[] tos = joinTable.inverseJoinColumns();
                                    if (tos != null && tos.length != 0) {
                                        String to = tos[0].name();
                                        String relTable = joinTable.name();
                                        String fromRefCol = froms[0].referencedColumnName();
                                        if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                                            fromRefCol = ORMConfigBeanUtil.getIdColumn(OneToManyDAO.this.t);
                                        }
                                        String fromRefField = ORMConfigBeanUtil.getField(OneToManyDAO.this.t.getClass(), fromRefCol);
                                        Method fromRefFieldGetter = OneToManyDAO.this.ru.getGetter(fromRefField);
                                        if (fromRefFieldGetter == null) {
                                            throw new Exception("can not find the 'from ref field -> " + fromRefField + "' of " + OneToManyDAO.this.t.getClass() + " 's getter method");
                                        }
                                        Object _obj = fromRefFieldGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                                        if (_obj != null) {
                                            String toRefField;
                                            Method toRefFieldGetter;
                                            String fromRefVal = String.valueOf(_obj);
                                            String toRefCol = tos[0].referencedColumnName();
                                            if (toRefCol == null || toRefCol.trim().length() == 0) {
                                                toRefCol = ORMConfigBeanUtil.getIdColumn(tarClass);
                                            }
                                            if ((toRefFieldGetter = tarRu.getGetter(toRefField = ORMConfigBeanUtil.getField(tarClass, toRefCol))) == null) {
                                                throw new Exception("can not find the 'to ref field -> " + toRefField + "' of " + tarClass + " 's getter method");
                                            }
                                            Object _obj2 = toRefFieldGetter.invoke(tarObj, new Object[0]);
                                            if (_obj2 != null) {
                                                String toRefVal = String.valueOf(_obj2);
                                                String format = "delete from %s where %s = ? and %s = ? ;";
                                                String sql = String.format(format, relTable, from, to);
                                                DAOFactory.getUpdateDAO(OneToManyDAO.this.dsName).updateBySQLWithArgs(sql, fromRefVal, toRefVal);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }, new Object[0]);
    }

    public void select() throws DAOException {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        Class<?> ownClass = this.ru.getObject().getClass();
        String fromRefVal = null;
        for (Field f : this.fields) {
            Class<?> tarClass;
            OneToMany ann;
            Method tarGetter = this.ru.getGetter(f.getName());
            if (tarGetter == null || (ann = tarGetter.getAnnotation(OneToMany.class)) == null && (ann = f.getAnnotation(OneToMany.class)) == null) continue;
            OrderBy orderAnn = tarGetter.getAnnotation(OrderBy.class);
            if (orderAnn == null) {
                orderAnn = f.getAnnotation(OrderBy.class);
            }
            if (Void.TYPE.isAssignableFrom(tarClass = ann.targetEntity())) {
                tarClass = ClassUtil.getGenericType(f);
            }
            String orderBy = "";
            if (orderAnn != null && orderAnn.value().trim().length() > 0) {
                orderBy = " ORDER BY " + orderAnn.value().replace("t.", String.valueOf(tarClass.getSimpleName().toLowerCase()) + ".");
            }
            String mappedBy = ann.mappedBy();
            try {
                Method tarSetter;
                Object fromRefField;
                String fromRefCol2;
                ReflectUtil tarRu = new ReflectUtil(tarClass);
                List<?> tarList = null;
                JoinTable joinTable = null;
                if (f.isAnnotationPresent(JoinTable.class)) {
                    joinTable = f.getAnnotation(JoinTable.class);
                } else if (tarGetter.isAnnotationPresent(JoinTable.class)) {
                    joinTable = tarGetter.getAnnotation(JoinTable.class);
                }
                if (joinTable != null) {
                    Method fromRefFieldGetter;
                    JoinColumn[] froms = joinTable.joinColumns();
                    if (froms == null || froms.length == 0) continue;
                    String tarTable = joinTable.name();
                    String from = froms[0].name();
                    fromRefCol2 = froms[0].referencedColumnName();
                    if (fromRefCol2 == null || fromRefCol2.trim().length() == 0) {
                        fromRefCol2 = ORMConfigBeanUtil.getIdColumn(this.t);
                    }
                    if ((fromRefFieldGetter = this.ru.getGetter((String)(fromRefField = ORMConfigBeanUtil.getField(this.t.getClass(), fromRefCol2)))) == null) {
                        throw new Exception("can not find the 'from ref field -> " + (String)fromRefField + "' of " + this.t.getClass() + " 's getter method");
                    }
                    Object _obj = fromRefFieldGetter.invoke(this.t, new Object[0]);
                    if (_obj == null) continue;
                    fromRefVal = String.valueOf(_obj);
                    String format = "select %s from %s where %s = ?  ;";
                    String sql = String.valueOf(String.format(format, ORMConfigBeanUtil.getSelectAllColumn(tarClass), tarTable, from)) + orderBy;
                    tarList = DAOFactory.getSelectDAO(this.dsName).selectBySQL(tarClass, sql, fromRefVal);
                } else {
                    String fromRefField2;
                    Method fromRefFieldGetter;
                    Field mappedField = null;
                    if (mappedBy != null && mappedBy.trim().length() > 0) {
                        mappedField = tarRu.getField(mappedBy);
                    } else {
                        fromRefField = tarRu.getFields();
                        int fromRefCol2 = ((Field[])fromRefField).length;
                        int from = 0;
                        while (from < fromRefCol2) {
                            Field field = fromRefField[from];
                            if (field.getType().getName().equals(ownClass.getName())) {
                                mappedField = field;
                                mappedBy = mappedField.getName();
                                break;
                            }
                            ++from;
                        }
                    }
                    if (mappedField == null) {
                        throw new Exception("mapped field of " + tarClass + " not found");
                    }
                    Method tarObjFieldGetter = tarRu.getGetter(mappedBy);
                    if (tarObjFieldGetter == null) continue;
                    ManyToOne manyToOne = mappedField.getAnnotation(ManyToOne.class);
                    if (manyToOne == null) {
                        manyToOne = tarObjFieldGetter.getAnnotation(ManyToOne.class);
                    }
                    if (manyToOne == null) continue;
                    fromRefCol2 = null;
                    JoinColumn joinCol = mappedField.getAnnotation(JoinColumn.class);
                    if (joinCol == null) {
                        joinCol = tarObjFieldGetter.getAnnotation(JoinColumn.class);
                    }
                    if (joinCol != null) {
                        fromRefCol2 = joinCol.referencedColumnName();
                    }
                    if (fromRefCol2 == null || fromRefCol2.trim().length() == 0) {
                        fromRefCol2 = ORMConfigBeanUtil.getIdColumn(this.t);
                    }
                    if ((fromRefFieldGetter = this.ru.getGetter(fromRefField2 = ORMConfigBeanUtil.getField(ownClass, fromRefCol2))) == null) {
                        throw new Exception("can not find the 'from ref field field -> " + fromRefField2 + "' of " + ownClass + " 's getter method");
                    }
                    Object _obj = fromRefFieldGetter.invoke(this.t, new Object[0]);
                    if (_obj != null) {
                        fromRefVal = String.valueOf(_obj);
                    }
                    String format = "select %s from %s where %s = ?  ;";
                    String sql = String.valueOf(String.format(format, ORMConfigBeanUtil.getSelectAllColumn(tarClass), ORMConfigBeanUtil.getTable(tarClass, true), ORMConfigBeanUtil.getColumn(tarClass, mappedBy))) + orderBy;
                    tarList = DAOFactory.getSelectDAO(this.dsName).selectBySQL(tarClass, sql, fromRefVal);
                }
                if (tarList == null || (tarSetter = this.ru.getSetter(f.getName())) == null) continue;
                tarSetter.invoke(this.t, tarList);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
    }

    public void update(final long newFromRefVal) {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        try {
            Transaction.execute(new Trans(){

                public void run(Object ... args) throws Exception {
                    Class<?> ownClass = OneToManyDAO.this.ru.getObject().getClass();
                    String format = "update %s set %s = %s where %s = %s ;";
                    String fromRefCol = null;
                    String fromRefVal = null;
                    for (Field f : OneToManyDAO.this.fields) {
                        Method tarGetter = OneToManyDAO.this.ru.getGetter(f.getName());
                        if (tarGetter == null) continue;
                        OneToMany ann = tarGetter.getAnnotation(OneToMany.class);
                        if (ann == null) {
                            ann = f.getAnnotation(OneToMany.class);
                        }
                        if (ann == null) continue;
                        Class<?> tarClass = ann.targetEntity();
                        if (Void.TYPE.isAssignableFrom(tarClass)) {
                            tarClass = ClassUtil.getGenericType(f);
                        }
                        String mappedBy = ann.mappedBy();
                        ReflectUtil tarRu = new ReflectUtil(tarClass);
                        if (mappedBy != null && mappedBy.trim().length() > 0) {
                            Method ownFieldSetter = tarRu.getSetter(mappedBy);
                            if (ownFieldSetter == null) {
                                continue;
                            }
                        } else {
                            JoinTable joinTable = null;
                            if (f.isAnnotationPresent(JoinTable.class)) {
                                joinTable = f.getAnnotation(JoinTable.class);
                            } else if (tarGetter.isAnnotationPresent(JoinTable.class)) {
                                joinTable = tarGetter.getAnnotation(JoinTable.class);
                            } else {
                                Field[] fieldArray = tarRu.getFields();
                                int n = fieldArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Field tarObjField = fieldArray[n2];
                                    if (tarObjField.getType().getName().equals(ownClass.getName())) {
                                        mappedBy = tarObjField.getName();
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            if (joinTable != null) {
                                JoinColumn[] tos;
                                JoinColumn[] froms = joinTable.joinColumns();
                                if (froms == null || froms.length == 0 || (tos = joinTable.inverseJoinColumns()) == null || tos.length == 0) continue;
                                String relTable = joinTable.name();
                                String from = froms[0].name();
                                fromRefCol = froms[0].referencedColumnName();
                                if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                                    fromRefCol = ORMConfigBeanUtil.getIdColumn(OneToManyDAO.this.t);
                                }
                                String fromRefField = ORMConfigBeanUtil.getField(OneToManyDAO.this.t.getClass(), fromRefCol);
                                Method fromRefFieldGetter = OneToManyDAO.this.ru.getGetter(fromRefField);
                                if (fromRefFieldGetter == null) {
                                    throw new Exception("can not find the 'from ref field -> " + fromRefField + "' of " + OneToManyDAO.this.t.getClass() + " 's getter method");
                                }
                                Object _obj = fromRefFieldGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                                if (_obj == null) continue;
                                fromRefVal = String.valueOf(_obj);
                                String _format = "update %s set %s = ? where %s = ? ;";
                                String sql = String.format(_format, relTable, from, from);
                                DAOFactory.getUpdateDAO(OneToManyDAO.this.dsName).updateBySQLWithArgs(sql, newFromRefVal, fromRefVal);
                                continue;
                            }
                        }
                        if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                            fromRefCol = ORMConfigBeanUtil.getIdColumn(OneToManyDAO.this.t);
                        }
                        String fromRefField = ORMConfigBeanUtil.getField(OneToManyDAO.this.t.getClass(), fromRefCol);
                        Method fromRefFieldGetter = OneToManyDAO.this.ru.getGetter(fromRefField);
                        if (fromRefFieldGetter == null) {
                            throw new Exception("can not find the 'from ref field -> " + fromRefField + "' of " + OneToManyDAO.this.t.getClass() + " 's getter method");
                        }
                        Object _obj = fromRefFieldGetter.invoke(OneToManyDAO.this.t, new Object[0]);
                        if (_obj == null) continue;
                        fromRefVal = String.valueOf(_obj);
                        String sql = String.format(format, OneToManyDAO.this.table, fromRefCol, newFromRefVal, fromRefCol, fromRefVal);
                        DAOFactory.getUpdateDAO(OneToManyDAO.this.dsName).updateBySQL(sql);
                        DAOFactory.getDAO(tarClass, OneToManyDAO.this.dsName).update(new String[0]).set(new String[]{mappedBy}, newFromRefVal).where().field(mappedBy).equal(OneToManyDAO.this.idVal).execute();
                    }
                }
            }, new Object[0]);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
    }
}

