/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.cascade;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.DAOFactory;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToOneDAO {
    public static final Log log = LogFactory.getORMLogger(ToOneDAO.class);
    private String dsName;
    private Object t;
    private List<Field> fields;
    private ReflectUtil ru;
    private String table;
    private String idColumn;
    private String idField;
    private String idVal;
    private Method idGetter;

    public ToOneDAO(String dsName) {
        this.dsName = dsName;
    }

    public void init(Object t, List<Field> fields) throws DAOException {
        this.t = t;
        this.fields = fields;
        this.ru = new ReflectUtil(this.t);
        this.table = ORMConfigBeanUtil.getTable(t.getClass(), true);
        this.idField = ORMConfigBeanUtil.getIdField(this.t.getClass());
        this.idColumn = ORMConfigBeanUtil.getIdColumn(this.t.getClass());
        this.idGetter = this.ru.getGetter(this.idField);
        if (this.idGetter != null) {
            try {
                Object idVal = this.idGetter.invoke(this.t, new Object[0]);
                this.idVal = idVal == null ? null : String.valueOf(idVal);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
    }

    public void select() {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        if (this.idVal == null || "0".equals(this.idVal) || "".equals(this.idVal)) {
            log.warn("skip cascade select cause this pojo has no @Id value");
            return;
        }
        for (Field f : this.fields) {
            Method tarGetter = this.ru.getGetter(f.getName());
            if (tarGetter == null) continue;
            String fk = null;
            OneToOne ann = tarGetter.getAnnotation(OneToOne.class);
            if (ann == null) {
                ann = f.getAnnotation(OneToOne.class);
            }
            if (ann == null) {
                ManyToOne moAn = tarGetter.getAnnotation(ManyToOne.class);
                if (moAn == null) {
                    moAn = f.getAnnotation(ManyToOne.class);
                }
                if (moAn == null) continue;
            }
            String refCol = null;
            JoinColumn joinCol = f.getAnnotation(JoinColumn.class);
            if (joinCol == null) {
                joinCol = tarGetter.getAnnotation(JoinColumn.class);
            }
            if (joinCol == null) {
                fk = String.valueOf(f.getName()) + "_id";
            } else {
                fk = joinCol.name();
                refCol = joinCol.referencedColumnName();
            }
            Class<?> tarClass = f.getType();
            if (refCol == null || refCol.trim().length() == 0) {
                refCol = ORMConfigBeanUtil.getIdColumn(tarClass);
            }
            String refField = ORMConfigBeanUtil.getField(tarClass, refCol);
            try {
                Object _tarObj = tarGetter.invoke(this.t, new Object[0]);
                Object tarObj = null;
                boolean flag = false;
                if (_tarObj != null) {
                    Method refFieldGetter = new ReflectUtil(_tarObj).getGetter(refField);
                    if (refFieldGetter != null && refFieldGetter.invoke(_tarObj, new Object[0]) != null) {
                        tarObj = DAOFactory.getSelectDAO(this.dsName).selectOne(_tarObj, refField);
                    } else {
                        flag = true;
                    }
                } else {
                    flag = true;
                }
                if (flag) {
                    String format = "select %s from %s where %s = (select %s from %s where %s = %s )";
                    String tarTable = ORMConfigBeanUtil.getTable(tarClass, true);
                    String sql = String.format(format, ORMConfigBeanUtil.getSelectAllColumn(tarClass), tarTable, refCol, fk, this.table, this.idColumn, this.idVal);
                    List<?> tarList = DAOFactory.getSelectDAO(this.dsName).selectBySQL(tarClass, sql, new Object[0]);
                    if (tarList == null || tarList.size() == 0) continue;
                    tarObj = tarList.get(0);
                }
                if (tarObj == null) continue;
                Method tarSetter = this.ru.getSetter(f.getName());
                tarSetter.invoke(this.t, tarObj);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
    }
}

