/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.delete;

import java.sql.Connection;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.delete.DeleteDAO;
import org.eweb4j.orm.jdbc.JdbcUtil;
import org.eweb4j.orm.sql.Sql;
import org.eweb4j.orm.sql.SqlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDAOImpl
implements DeleteDAO {
    private DataSource ds;

    public DeleteDAOImpl(DataSource ds) {
        this.ds = ds;
    }

    public DataSource getDs() {
        return this.ds;
    }

    public void setDs(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public <T> Number[] batchDelete(T ... ts) throws DAOException {
        Number[] ids = null;
        Connection con = null;
        if (ts == null || ts.length == 0) {
            return ids;
        }
        ids = new Number[ts.length];
        try {
            con = this.ds.getConnection();
            Sql[] sqls = SqlFactory.getDeleteSql(ts).delete();
            ArrayList<Object[]> argList = new ArrayList<Object[]>(ts.length);
            Sql[] sqlArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                Sql sql = sqlArray[n2];
                argList.add(sql.args.toArray());
                ++n2;
            }
            Object[][] args = new Object[argList.size()][];
            int i = 0;
            while (i < argList.size()) {
                args[i] = (Object[])argList.get(i);
                ++i;
            }
            ids = JdbcUtil.batchUpdateWithArgs(con, sqls[0].sql, args);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return ids;
    }

    @Override
    public <T> Number deleteById(T t) throws DAOException {
        Number[] rs = this.batchDelete(t);
        return rs == null ? (Number)0 : (Number)rs[0];
    }

    @Override
    public <T> Number[] deleteByFieldIsValue(Class<T>[] clazz, String[] fields, String[] values) throws DAOException {
        Number[] ids = null;
        Connection con = null;
        if (clazz == null || clazz.length == 0) {
            return ids;
        }
        ids = new Number[clazz.length];
        try {
            con = this.ds.getConnection();
            Object[] ts = new Object[clazz.length];
            int i = 0;
            while (i < clazz.length) {
                ts[i] = clazz[i].newInstance();
                ++i;
            }
            Sql[] sqls = SqlFactory.getDeleteSql(ts).delete(fields, values);
            ArrayList<Object[]> argList = new ArrayList<Object[]>(ts.length);
            Sql[] sqlArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                Sql sql = sqlArray[n2];
                argList.add(sql.args.toArray());
                ++n2;
            }
            Object[][] args = new Object[argList.size()][];
            int i2 = 0;
            while (i2 < argList.size()) {
                args[i2] = (Object[])argList.get(i2);
                ++i2;
            }
            ids = JdbcUtil.batchUpdateWithArgs(con, sqls[0].sql, args);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return ids;
    }

    @Override
    public <T> Number[] deleteByFieldIsValue(Class<T>[] clazz, String field, String value) throws DAOException {
        return this.deleteByFieldIsValue(clazz, new String[]{field}, new String[]{value});
    }

    @Override
    public <T> Number deleteByFields(T t, String[] fields) throws DAOException {
        Number id = 0;
        if (t != null) {
            Connection con = null;
            try {
                con = this.ds.getConnection();
                Sql[] sqls = SqlFactory.getDeleteSql(t).delete(fields);
                id = JdbcUtil.updateWithArgs(con, sqls[0].sql, sqls[0].args.toArray());
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return id;
    }

    @Override
    public <T> Number deleteByFieldIsValue(Class<T> clazz, String[] fields, String[] values) throws DAOException {
        Number id = 0;
        if (clazz != null && fields != null && values != null && fields.length == values.length) {
            Connection con = null;
            try {
                con = this.ds.getConnection();
                Sql[] sqls = SqlFactory.getDeleteSql(clazz.newInstance()).delete(fields, values);
                id = JdbcUtil.updateWithArgs(con, sqls[0].sql, sqls[0].args.toArray());
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return id;
    }

    @Override
    public <T> Number deleteByFieldIsValue(Class<T> clazz, String field, String value) throws DAOException {
        return this.deleteByFieldIsValue(clazz, new String[]{field}, new String[]{value});
    }

    @Override
    public <T> Number deleteWhere(Class<T> clazz, String condition, Object[] args) throws DAOException {
        Number id = 0;
        if (clazz != null) {
            Connection con = null;
            try {
                con = this.ds.getConnection();
                Sql sql = SqlFactory.getDeleteSql(clazz.newInstance()).deleteWhere(ORMConfigBeanUtil.parseQuery(condition, clazz));
                id = JdbcUtil.updateWithArgs(con, sql.sql, args);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return id;
    }

    @Override
    public <T> Number deleteById(Class<T> clazz, Number id) throws DAOException {
        if (clazz == null || id == null) {
            return 0;
        }
        String field = ORMConfigBeanUtil.getIdField(clazz);
        return this.deleteByFieldIsValue(clazz, field, String.valueOf(id));
    }
}

