/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.select;

import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.select.SelectDAO;
import org.eweb4j.orm.jdbc.JdbcUtil;
import org.eweb4j.orm.sql.SqlFactory;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDAOImpl
implements SelectDAO {
    private DataSource ds;
    private String dbType;

    public SelectDAOImpl(DataSource ds, String dbType) {
        this.ds = ds;
        this.dbType = dbType;
    }

    @Override
    public <T> List<T> selectAll(Class<T> clazz, String orderField, int orderType) throws DAOException {
        List<T> list = null;
        if (clazz != null) {
            Connection con = null;
            try {
                con = this.ds.getConnection();
                String sql = SqlFactory.getSelectSql(clazz.newInstance(), this.dbType).selectAll(orderField, orderType);
                list = JdbcUtil.getList(con, clazz, sql);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return list;
    }

    @Override
    public <T> List<T> selectAll(Class<T> clazz, int orderType) throws DAOException {
        return this.selectAll(clazz, null, orderType);
    }

    @Override
    public <T> List<T> selectAll(Class<T> clazz) throws DAOException {
        return this.selectAll(clazz, null, -1);
    }

    @Override
    public <T> T selectOne(T t, String ... fields) throws DAOException {
        T result = null;
        if (t != null) {
            Class<?> clazz = t.getClass();
            Connection con = null;
            try {
                con = this.ds.getConnection();
                String sql = SqlFactory.getSelectSql(t, this.dbType).selectWhere(fields);
                List<?> list = JdbcUtil.getList(con, clazz, sql);
                if (list != null && !list.isEmpty()) {
                    result = (T)list.get(0);
                }
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return result;
    }

    @Override
    public <T> T selectOne(Class<T> clazz, String[] fields, String[] values) throws DAOException {
        T result = null;
        if (clazz != null) {
            Connection con = null;
            try {
                con = this.ds.getConnection();
                T t = clazz.newInstance();
                String sql = SqlFactory.getSelectSql(t, this.dbType).selectWhere(fields, values);
                List<T> list = JdbcUtil.getList(con, clazz, sql);
                if (list != null && !list.isEmpty()) {
                    result = list.get(0);
                }
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return result;
    }

    @Override
    public <T> T selectOneByWhere(Class<T> clazz, String condition) throws DAOException {
        T result = null;
        List<T> list = this.selectWhere(clazz, ORMConfigBeanUtil.parseQuery(condition, clazz), new Object[0]);
        if (list != null && !list.isEmpty()) {
            result = list.get(0);
        }
        return result;
    }

    @Override
    public <T> long selectCount(Class<T> clazz) throws DAOException {
        return this.selectCount(clazz, null);
    }

    @Override
    public <T> long selectCount(Class<T> clazz, String condition) throws DAOException {
        long result = -1L;
        Connection con = null;
        try {
            T t;
            String sql;
            String str;
            con = this.ds.getConnection();
            if (clazz != null && CommonUtil.isNumeric(str = String.valueOf(JdbcUtil.getObject(con, sql = SqlFactory.getSelectSql(t = clazz.newInstance(), this.dbType).selectCount(ORMConfigBeanUtil.parseQuery(condition, clazz)))))) {
                result = Integer.parseInt(str);
            }
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return result;
    }

    @Override
    public <T> List<T> selectWhere(Class<T> clazz, String condition, Object ... args) throws DAOException {
        List<T> result = null;
        Connection con = null;
        try {
            con = this.ds.getConnection();
            T t = clazz.newInstance();
            String sql = SqlFactory.getSelectSql(t, this.dbType).select(ORMConfigBeanUtil.parseQuery(condition, clazz));
            result = JdbcUtil.getListWithArgs(con, clazz, sql, args);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return result;
    }

    @Override
    public <T> List<T> selectBySQL(Class<T> clazz, String sql, Object ... args) throws DAOException {
        List<T> result = null;
        Connection con = null;
        try {
            con = this.ds.getConnection();
            result = JdbcUtil.getListWithArgs(con, clazz, sql, args);
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return result;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public DataSource getDs() {
        return this.ds;
    }

    public void setDs(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public <T> long selectCount(Class<T> clazz, String condition, Object ... args) throws DAOException {
        long result = -1L;
        Connection con = null;
        try {
            T t;
            String sql;
            String str;
            con = this.ds.getConnection();
            if (clazz != null && CommonUtil.isNumeric(str = String.valueOf(JdbcUtil.getObject(con, sql = SqlFactory.getSelectSql(t = clazz.newInstance(), this.dbType).selectCount(ORMConfigBeanUtil.parseQuery(condition, clazz)), args)))) {
                result = Integer.parseInt(str);
            }
        }
        catch (Exception e) {
            throw new DAOException("", e);
        }
        return result;
    }

    @Override
    public <T> T selectOneById(Class<T> clazz, Number id) throws DAOException {
        if (clazz == null || id == null) {
            return null;
        }
        String idField = ORMConfigBeanUtil.getIdField(clazz);
        if (idField == null) {
            return null;
        }
        String[] fields = new String[]{idField};
        String[] values = new String[]{String.valueOf(id)};
        return this.selectOne(clazz, fields, values);
    }

    @Override
    public <T> T selectOneById(T t) throws DAOException {
        if (t == null) {
            return null;
        }
        String idField = ORMConfigBeanUtil.getIdField(t.getClass());
        if (idField == null) {
            return null;
        }
        return this.selectOne(t, idField);
    }
}

