/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.update;

import java.sql.Connection;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.update.UpdateDAO;
import org.eweb4j.orm.jdbc.JdbcUtil;
import org.eweb4j.orm.sql.Sql;
import org.eweb4j.orm.sql.SqlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDAOImpl
implements UpdateDAO {
    private DataSource ds;

    public UpdateDAOImpl(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public <T> Number update(T t) throws DAOException {
        Number[] rs = this.batchUpdate(new Object[]{t}, new String[0]);
        return rs == null ? (Number)0 : (Number)rs[0];
    }

    @Override
    public <T> Number[] batchUpdate(T[] ts, String ... fields) throws DAOException {
        Number[] ids = null;
        if (ts != null && ts.length > 0) {
            Connection con = null;
            ids = new Number[ts.length];
            try {
                con = this.ds.getConnection();
                Sql[] sqls = SqlFactory.getUpdateSql(ts).update(fields);
                ArrayList<Object[]> argList = new ArrayList<Object[]>(ts.length);
                Sql[] sqlArray = sqls;
                int n = sqls.length;
                int n2 = 0;
                while (n2 < n) {
                    Sql sql = sqlArray[n2];
                    argList.add(sql.args.toArray());
                    ++n2;
                }
                Object[][] args = new Object[argList.size()][];
                int i = 0;
                while (i < argList.size()) {
                    args[i] = (Object[])argList.get(i);
                    ++i;
                }
                ids = JdbcUtil.batchUpdateWithArgs(con, sqls[0].sql, args);
            }
            catch (Exception e) {
                throw new DAOException("batchUpdate exception ", e);
            }
        }
        return ids;
    }

    @Override
    public <T> Number[] batchUpdate(T[] ts, String[] fields, Object[] values) throws DAOException {
        Number[] ids = null;
        if (ts != null && ts.length > 0) {
            Connection con = null;
            ids = new Number[ts.length];
            try {
                con = this.ds.getConnection();
                Sql[] sqls = SqlFactory.getUpdateSql(ts).update(fields, values);
                ArrayList<Object[]> argList = new ArrayList<Object[]>(ts.length);
                Sql[] sqlArray = sqls;
                int n = sqls.length;
                int n2 = 0;
                while (n2 < n) {
                    Sql sql = sqlArray[n2];
                    argList.add(sql.args.toArray());
                    ++n2;
                }
                Object[][] args = new Object[argList.size()][];
                int i = 0;
                while (i < argList.size()) {
                    args[i] = (Object[])argList.get(i);
                    ++i;
                }
                ids = JdbcUtil.batchUpdateWithArgs(con, sqls[0].sql, args);
            }
            catch (Exception e) {
                throw new DAOException("batchUpdate exception ", e);
            }
        }
        return ids;
    }

    @Override
    public <T> Number updateByFields(T t, String ... fields) throws DAOException {
        Number[] rs = this.updateByFields(new Object[]{t}, fields);
        return rs == null ? (Number)0 : (Number)rs[0];
    }

    @Override
    public <T> Number updateByFieldIsValue(T t, String[] fields, String[] values) throws DAOException {
        Number[] rs = this.updateByFieldIsValue(new Object[]{t}, fields, values);
        return rs == null ? (Number)0 : (Number)rs[0];
    }

    @Override
    public <T> Number updateByFieldIsValue(T t, String field, String value) throws DAOException {
        return this.updateByFieldIsValue(t, new String[]{field}, new String[]{value});
    }

    @Override
    public <T> Number updateBySQLWithArgs(String sql, Object ... args) throws DAOException {
        Number[] rs = this.updateBySQLWithArgs(new String[]{sql}, new Object[][]{args});
        return rs == null ? (Number)0 : (Number)rs[0];
    }

    @Override
    public <T> Number[] updateByFields(T[] ts, String ... fields) throws DAOException {
        Number[] ids = null;
        if (ts != null && ts.length > 0 && fields != null && fields.length > 0) {
            Connection con = null;
            ids = new Number[ts.length];
            try {
                Sql[] sqls = SqlFactory.getUpdateSql(ts).update(fields);
                int i = 0;
                while (i < ts.length) {
                    con = this.ds.getConnection();
                    ids[i] = JdbcUtil.updateWithArgs(con, sqls[i].sql, sqls[i].args.toArray());
                    ++i;
                }
            }
            catch (Exception e) {
                throw new DAOException("updateByFields exception ", e);
            }
        }
        return ids;
    }

    @Override
    public <T> Number[] updateByFieldIsValue(T[] ts, String[] fields, String[] values) throws DAOException {
        Number[] ids = null;
        if (ts != null && ts.length > 0 && fields != null && fields.length > 0) {
            Connection con = null;
            ids = new Number[ts.length];
            try {
                Sql[] sqls = SqlFactory.getUpdateSql(ts).update(fields, (Object[])values);
                int i = 0;
                while (i < ts.length) {
                    con = this.ds.getConnection();
                    ids[i] = JdbcUtil.updateWithArgs(con, sqls[i].sql, sqls[i].args.toArray());
                    ++i;
                }
            }
            catch (Exception e) {
                throw new DAOException("updateByFieldIsValue exception ", e);
            }
        }
        return ids;
    }

    @Override
    public <T> Number[] updateByFieldIsValue(Class<T>[] clazz, String field, String value) throws DAOException {
        return this.updateByFieldIsValue((T[])clazz, new String[]{field}, new String[]{value});
    }

    @Override
    public <T> Number[] updateBySQL(String ... sqls) throws DAOException {
        Number[] result = null;
        Connection con = null;
        try {
            con = this.ds.getConnection();
            result = JdbcUtil.update(con, sqls);
        }
        catch (Exception e) {
            throw new DAOException("updateBySQL exception ", e);
        }
        return result;
    }

    @Override
    public <T> Number[] updateBySQLWithArgs(String[] sqls, Object[][] args) throws DAOException {
        Number[] result = null;
        Connection con = null;
        try {
            con = this.ds.getConnection();
            result = JdbcUtil.updateWithArgs(con, sqls, args);
        }
        catch (Exception e) {
            throw new DAOException("updateBySQLWithArgs exception ", e);
        }
        return result;
    }

    public DataSource getDs() {
        return this.ds;
    }

    public void setDs(DataSource ds) {
        this.ds = ds;
    }
}

