/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.jdbc;

import com.mchange.v2.c3p0.DataSources;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eweb4j.cache.DBInfoConfigBeanCache;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.orm.jdbc.DataSourceCreator;
import org.eweb4j.orm.jdbc.DataSourceWrapCache;
import org.eweb4j.orm.jdbc.transaction.ConThreadLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSourceWrap
implements DataSource {
    private static Log log = LogFactory.getORMLogger(DataSourceWrap.class);
    private String dsName;
    private DataSource ds;

    private void init(String dsName, DataSource ds) {
        this.ds = ds;
        this.dsName = dsName == null ? "myDBInfo" : dsName;
    }

    public DataSourceWrap() {
    }

    public DataSourceWrap(String dsName, DataSource ds) {
        this.init(dsName, ds);
    }

    public DataSourceWrap(DataSource ds) {
        this.init(null, ds);
    }

    @Override
    public Connection getConnection() {
        try {
            Connection con = null;
            if (!ConThreadLocal.isTrans().booleanValue()) {
                return this.ds.getConnection();
            }
            con = ConThreadLocal.getCon(this.dsName);
            if (con == null) {
                con = this.ds.getConnection();
                con.setAutoCommit(false);
                ConThreadLocal.put(this.dsName, con);
            }
            return con;
        }
        catch (SQLException e) {
            log.error(e.toString(), e);
            return null;
        }
    }

    protected void finalize() throws Throwable {
        DataSourceWrapCache.remove(this.dsName);
        DataSources.destroy((DataSource)this.ds);
        log.debug("create datasource -> " + this.dsName);
        DataSource _ds = DataSourceCreator.create(DBInfoConfigBeanCache.get(this.dsName));
        DataSourceWrap dsw = new DataSourceWrap(this.dsName, _ds);
        log.debug("finalize...");
        DataSourceWrapCache.put(this.dsName, dsw);
        super.finalize();
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public DataSource getDs() {
        return this.ds;
    }

    public void setDs(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return null;
    }
}

