/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.orm.jdbc.JdbcUtilException;
import org.eweb4j.orm.jdbc.RowMapping;
import org.eweb4j.orm.jdbc.transaction.ConThreadLocal;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcUtil {
    private static Log log = LogFactory.getORMLogger(JdbcUtil.class);

    public static Number[] update(Connection con, String[] sqls) throws JdbcUtilException {
        return JdbcUtil.updateWithArgs(con, sqls, null);
    }

    public static Number update(Connection con, String sql) {
        return JdbcUtil.updateWithArgs(con, sql, null);
    }

    public static Number[] batchUpdateWithArgs(Connection con, String sql, Object[][] args) throws JdbcUtilException {
        Number[] result = null;
        if (con == null || sql == null || sql.trim().length() == 0 || args == null || args.length == 0) {
            return result;
        }
        PreparedStatement pstmt = null;
        try {
            try {
                result = new Number[args.length];
                pstmt = con.prepareStatement(sql, 1);
                int i = 0;
                while (i < args.length) {
                    int j = 0;
                    while (j < args[i].length) {
                        pstmt.setObject(j + 1, args[i][j]);
                        ++j;
                    }
                    pstmt.addBatch();
                    ++i;
                }
                int[] row = pstmt.executeBatch();
                if (row != null && row.length > 0) {
                    if (sql.contains("INSERT INTO")) {
                        ResultSet rs = pstmt.getGeneratedKeys();
                        int i2 = 0;
                        while (rs.next()) {
                            result[i2] = rs.getInt(1);
                            ++i2;
                        }
                    } else {
                        int i3 = 0;
                        while (i3 < row.length) {
                            result[i3] = row[i3];
                            ++i3;
                        }
                    }
                }
                pstmt.close();
                JdbcUtil.logToOrm(sql, args, result);
            }
            catch (SQLException e) {
                JdbcUtil.logException(new StringBuilder(sql), e);
                throw new JdbcUtilException(String.valueOf(sql) + ", args->" + CommonUtil.toJson(args) + " exception", e);
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(null, pstmt, null);
            if (!ConThreadLocal.isTrans().booleanValue()) {
                JdbcUtil.close(con);
            }
            throw throwable;
        }
        JdbcUtil.close(null, pstmt, null);
        if (!ConThreadLocal.isTrans().booleanValue()) {
            JdbcUtil.close(con);
        }
        return result;
    }

    public static Number[] updateWithArgs(Connection con, String[] sqls, Object[][] args) throws JdbcUtilException {
        Number[] result = null;
        if (con != null && sqls != null && sqls.length > 0) {
            StringBuilder sql = new StringBuilder();
            PreparedStatement pstmt = null;
            try {
                try {
                    if (args != null && args.length > 0 && args.length != sqls.length) {
                        throw new JdbcUtilException("args error ...", null);
                    }
                    result = new Number[sqls.length];
                    int i = 0;
                    while (i < sqls.length) {
                        ResultSet rs;
                        sqls[i] = sqls[i].replace(";", "");
                        sql.append(sqls[i]);
                        pstmt = con.prepareStatement(sqls[i], 1);
                        JdbcUtil.fillArgs(args, pstmt, i);
                        result[i] = pstmt.executeUpdate();
                        if (result[i].intValue() > 0 && sqls[i].contains("INSERT INTO") && (rs = pstmt.getGeneratedKeys()).next()) {
                            result[i] = rs.getInt(1);
                        }
                        pstmt.close();
                        JdbcUtil.logToOrm(sqls, args, result, i);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    JdbcUtil.logException(sql, e);
                    throw new JdbcUtilException(sql + ", args->" + CommonUtil.toJson(args) + " exception", e);
                }
            }
            finally {
                JdbcUtil.close(null, pstmt, null);
                if (!ConThreadLocal.isTrans().booleanValue()) {
                    JdbcUtil.close(con);
                }
            }
        }
        return result;
    }

    private static void fillArgs(Object[][] args, PreparedStatement pstmt, int i) throws SQLException {
        if (args == null || args.length == 0) {
            return;
        }
        if (args[i] != null && args[i].length > 0) {
            int j = 0;
            while (j < args[i].length) {
                pstmt.setObject(j + 1, args[i][j]);
                ++j;
            }
        }
    }

    public static <T> List<T> getList(Connection con, Class<T> clazz, String sql) throws JdbcUtilException {
        return JdbcUtil.getListWithArgs(con, clazz, sql, null);
    }

    public static <T> List<T> getListWithArgs(Connection con, Class<T> clazz, String sql, Object[] args) throws JdbcUtilException {
        return JdbcUtil.getListWithoutCache(con, clazz, sql, args);
    }

    public static <T> List<T> getListWithoutCache(Connection con, Class<T> clazz, String sql, Object[] args) throws JdbcUtilException {
        List<T> list = null;
        if (clazz == null || sql == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        if (con != null) {
            try {
                try {
                    sql = sql.replace(";", "");
                    pstmt = con.prepareStatement(sql);
                    if (args != null && args.length > 0) {
                        int i = 0;
                        while (i < args.length) {
                            pstmt.setObject(i + 1, args[i]);
                            ++i;
                        }
                    }
                    rs = pstmt.executeQuery();
                    list = RowMapping.mapRows(rs, clazz);
                    JdbcUtil.logOrm(sql, args, list);
                }
                catch (Exception e) {
                    JdbcUtil.logException(sql, args, e);
                    throw new JdbcUtilException(String.valueOf(sql) + ", args->" + CommonUtil.toJson(args) + " exception ", e);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs, pstmt, null);
                if (!ConThreadLocal.isTrans().booleanValue()) {
                    JdbcUtil.close(con);
                }
                throw throwable;
            }
            JdbcUtil.close(rs, pstmt, null);
            if (!ConThreadLocal.isTrans().booleanValue()) {
                JdbcUtil.close(con);
            }
        }
        return list;
    }

    public static Number updateWithArgs(Connection con, String sql, Object[] args) throws JdbcUtilException {
        Number[] res = JdbcUtil.updateWithArgs(con, new String[]{sql}, new Object[][]{args});
        return res == null ? (Number)0 : (Number)res[0];
    }

    public static Object getObject(Connection con, String sql) throws JdbcUtilException {
        return JdbcUtil.getObject(con, sql, null);
    }

    public static String getString(Connection con, String sql, Object[] args) throws JdbcUtilException {
        return String.valueOf(JdbcUtil.getObject(con, sql, args));
    }

    public static String getString(Connection con, String sql) throws JdbcUtilException {
        return JdbcUtil.getString(con, sql, null);
    }

    public static Integer getInteger(Connection con, String sql) {
        String temp = JdbcUtil.getString(con, sql);
        int result = temp == null ? 0 : Integer.parseInt(temp);
        return result;
    }

    public static Integer getInteger(Connection con, String sql, Object ... args) {
        String temp = JdbcUtil.getString(con, sql, args);
        int result = temp == null ? 0 : Integer.parseInt(temp);
        return result;
    }

    public static Map<String, Object> getResultSetAsMap(Connection con, String sql, Object[] args) throws JdbcUtilException {
        HashMap<String, Object> result = null;
        if (sql == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        if (con != null) {
            try {
                try {
                    sql = sql.replace(";", "");
                    pstmt = con.prepareStatement(sql);
                    if (args != null && args.length > 0) {
                        int i = 0;
                        while (i < args.length) {
                            pstmt.setObject(i + 1, args[i]);
                            ++i;
                        }
                    }
                    rs = pstmt.executeQuery();
                    rsmd = rs.getMetaData();
                    ArrayList<String> columns = new ArrayList<String>();
                    int i = 1;
                    while (i <= rsmd.getColumnCount()) {
                        columns.add(rsmd.getColumnName(i));
                        ++i;
                    }
                    while (rs.next()) {
                        result = new HashMap<String, Object>();
                        i = 1;
                        while (i <= columns.size()) {
                            String name = (String)columns.get(i - 1);
                            result.put(name, rs.getObject(name));
                            ++i;
                        }
                    }
                    JdbcUtil.logOrm(sql, args, result);
                }
                catch (Exception e) {
                    JdbcUtil.logException(sql, args, e);
                    throw new JdbcUtilException(String.valueOf(sql) + ", args->" + CommonUtil.toJson(args) + " exception ", e);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs, pstmt, null);
                if (!ConThreadLocal.isTrans().booleanValue()) {
                    JdbcUtil.close(con);
                }
                throw throwable;
            }
            JdbcUtil.close(rs, pstmt, null);
            if (!ConThreadLocal.isTrans().booleanValue()) {
                JdbcUtil.close(con);
            }
        }
        return result;
    }

    public static Object getObject(Connection con, String sql, Object[] args) throws JdbcUtilException {
        return JdbcUtil.getResultSetAsList(con, sql, args).get(0);
    }

    public static List<Object> getResultSetAsList(Connection con, String sql, Object[] args) throws JdbcUtilException {
        ArrayList<Object> result = null;
        Map<String, Object> map = JdbcUtil.getResultSetAsMap(con, sql, args);
        if (map != null) {
            result = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                result.add(entry.getValue());
            }
        }
        return result;
    }

    public static void close(ResultSet rs, PreparedStatement pstmt, Connection con) throws JdbcUtilException {
        try {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            throw new JdbcUtilException("jdbc connection close exception...", e);
        }
    }

    public static void close(Connection con) {
        JdbcUtil.close(null, null, con);
    }

    private static void logException(StringBuilder sql, SQLException e) {
        log.error(sql.append("execute sql fail!").toString(), e);
    }

    private static void logToOrm(String sql, Object[][] args, Number[] result) {
        StringBuilder sb = new StringBuilder();
        sb.append("execute sql->").append(sql);
        if (args != null) {
            sb.append(" args->");
            Object[][] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] arg = objectArray[n2];
                sb.append(Arrays.asList(arg)).append(",");
                ++n2;
            }
        }
        sb.append(" result->").append(Arrays.asList(result)).append(";");
        log.debug(sb.toString());
    }

    private static void logToOrm(String[] sqls, Object[][] args, Number[] result, int i) {
        StringBuilder sb = new StringBuilder();
        sb.append("execute sql->").append(sqls[i]);
        if (args != null && args[i] != null) {
            sb.append(" args->").append(Arrays.asList(args[i]));
        }
        sb.append(" result->").append(result[i]).append(";");
        log.debug(sb.toString());
    }

    private static void logException(String sql, Object[] args, Exception e) {
        StringBuilder sb = new StringBuilder(e.toString());
        sb.append(" ").append(sql);
        if (args != null) {
            sb.append(" args->").append(Arrays.asList(args));
        }
        sb.append(" execute sql fail!");
        log.error(sb.toString(), e);
    }

    private static <T> void logOrm(String sql, Object[] args, List<T> list) {
        StringBuilder sb = new StringBuilder();
        int count = list == null ? 0 : list.size();
        sb.append("execute sql->").append(sql);
        if (args != null) {
            sb.append(" args->").append(Arrays.asList(args));
        }
        sb.append(" affected rows->").append(count).append(";");
        log.debug(sb.toString());
    }

    private static void logOrm(String sql, Object[] args, Map<String, Object> result) {
        StringBuilder sb = new StringBuilder();
        sb.append("execute sql->").append(sql);
        if (args != null) {
            sb.append(" args->").append(Arrays.asList(args));
        }
        sb.append(" result rows->").append(result.size()).append(";");
        log.debug(sb.toString());
    }
}

