/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.jdbc.transaction;

import java.sql.SQLException;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.jdbc.transaction.Trans;
import org.eweb4j.util.CommonUtil;

public class Transaction {
    private static Log log = LogFactory.getORMLogger(Transaction.class);

    public static void execute(Trans trans, Object ... args) {
        Transaction.execute(1, trans, args);
    }

    public static void execute(int level, Trans trans, Object ... args) {
        try {
            try {
                trans.begin(level);
                trans.run(args);
                trans.commit();
            }
            catch (Exception e) {
                try {
                    trans.rollback();
                }
                catch (SQLException e1) {
                    throw new DAOException("roll back exception ", e);
                }
                String info = CommonUtil.getExceptionString(e);
                log.debug(info);
                try {
                    trans.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                trans.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

