/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.sql;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.eweb4j.cache.ORMConfigBeanCache;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.LogFactory;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.config.bean.ORMConfigBean;
import org.eweb4j.orm.config.bean.Property;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.ReflectUtil;

public class Model2Table {
    static final String create_table_script = "\nDROP TABLE IF EXISTS %s;\nCREATE TABLE %s(\n%s \n) ENGINE=InnoDB DEFAULT CHARSET=utf8;\n";

    public static String write(String dataBase) {
        StringBuilder sql = new StringBuilder();
        StringBuilder manyMany = new StringBuilder();
        for (Map.Entry<Object, ORMConfigBean> e : ORMConfigBeanCache.entrySet()) {
            ORMConfigBean ocb = e.getValue();
            String table = ocb.getTable();
            List<Property> properties = ocb.getProperty();
            StringBuilder sb = new StringBuilder();
            StringBuilder fkSb = new StringBuilder();
            String fk = ", \n\tKEY %s (%s), \n\tCONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)";
            StringBuilder pkSb = new StringBuilder();
            String pk = ", \n\tPRIMARY KEY (%s)";
            StringBuilder uniqueSb = new StringBuilder();
            String unique = ", \n\tUNIQUE KEY %s (%s)";
            String idCol = ORMConfigBeanUtil.getIdColumn(properties);
            for (Property p : properties) {
                if (sb.length() > 0) {
                    sb.append(", \n");
                }
                String col = p.getColumn();
                String type = p.getType();
                String size = null;
                if (p.getSize().trim().length() > 0 && CommonUtil.isNumeric(p.getSize().trim())) {
                    size = String.format(" (%s) ", p.getSize());
                }
                if ("1".equals(p.getUnique()) || "true".equalsIgnoreCase(p.getUnique())) {
                    uniqueSb.append(String.format(unique, col, col));
                }
                String notNull = "";
                if ("1".equals(p.getNotNull()) || "true".equalsIgnoreCase(p.getNotNull())) {
                    notNull = " NOT NULL ";
                }
                if ("1".equals(p.getPk()) || "true".equalsIgnoreCase(p.getPk())) {
                    if (pkSb.length() > 0) {
                        pkSb.append(",");
                    }
                    pkSb.append(col);
                }
                String auto = "";
                if ("1".equals(p.getAutoIncrement()) || "true".equalsIgnoreCase(p.getAutoIncrement())) {
                    auto = " AUTO_INCREMENT ";
                }
                if ("oneOne".equals(p.getType()) || "manyOne".equals(p.getType())) {
                    String relTable = ORMConfigBeanUtil.getTable(p.getRelClass(), false);
                    if (p.getRelProperty() == null || p.getRelProperty().trim().length() == 0) {
                        p.setRelProperty(ORMConfigBeanUtil.getIdField(p.getRelClass()));
                    }
                    String relColumn = ORMConfigBeanUtil.getColumn(p.getRelClass(), p.getRelProperty());
                    fkSb.append(String.format(", \n\tKEY %s (%s), \n\tCONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", col, col, String.valueOf(table) + "_" + col, col, relTable, relColumn));
                }
                sb.append("\t").append(col).append(" ").append(Model2Table.getType(type)).append(size == null ? "" : size).append(notNull).append(auto);
            }
            sb.append(uniqueSb.toString());
            if (pkSb.length() > 0) {
                sb.append(String.format(", \n\tPRIMARY KEY (%s)", pkSb.toString()));
            }
            sb.append(fkSb.toString());
            String _sql = String.format(create_table_script, table, table, sb.toString());
            sql.append(_sql);
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass((String)e.getKey());
                ReflectUtil ru = new ReflectUtil(clazz);
                Field[] fieldArray = ru.getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    Method getter;
                    Field f = fieldArray[n2];
                    if (ClassUtil.isListClass(f) && (getter = ru.getGetter(name = f.getName())) != null) {
                        JoinColumn[] tos;
                        JoinColumn[] froms;
                        JoinTable join;
                        ManyToMany mmAnn = getter.getAnnotation(ManyToMany.class);
                        if (mmAnn == null) {
                            mmAnn = f.getAnnotation(ManyToMany.class);
                        }
                        if (mmAnn != null && ((join = getter.getAnnotation(JoinTable.class)) != null || (join = f.getAnnotation(JoinTable.class)) != null) && (froms = join.joinColumns()) != null && froms.length != 0 && (tos = join.inverseJoinColumns()) != null && tos.length != 0) {
                            String relTable = join.name();
                            String relFrom = froms[0].name();
                            String relTo = tos[0].name();
                            Class<?> targetClass = ClassUtil.getGenericType(f);
                            StringBuilder manyManyField = new StringBuilder();
                            manyManyField.append("\tid ").append(Model2Table.getType("long")).append(" (20) NOT NULL AUTO_INCREMENT,");
                            manyManyField.append("\n\t").append(relFrom).append(" ").append(Model2Table.getType("long")).append(" (20) ,");
                            manyManyField.append("\n\t").append(relTo).append(" ").append(Model2Table.getType("long")).append(" (20) ,");
                            manyManyField.append("\n\t").append("PRIMARY KEY (id)");
                            String tarTable = ORMConfigBeanUtil.getTable(targetClass, false);
                            String tarIdCol = ORMConfigBeanUtil.getIdColumn(targetClass);
                            String fk1 = String.format(", \n\tKEY %s (%s), \n\tCONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", relFrom, relFrom, String.valueOf(relTable) + "_" + relFrom, relFrom, table, idCol);
                            manyManyField.append(fk1);
                            String fk2 = String.format(", \n\tKEY %s (%s), \n\tCONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", relTo, relTo, String.valueOf(relTable) + "_" + relTo, relTo, tarTable, tarIdCol);
                            manyManyField.append(fk2);
                            manyMany.append(String.format(create_table_script, relTable, relTable, manyManyField.toString()));
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sql.append(manyMany.toString());
        File file = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH()) + dataBase + "-create.sql");
        try {
            FileWriter writer = new FileWriter(file);
            String script = String.format("SET FOREIGN_KEY_CHECKS=0;\n%s", sql.toString());
            writer.write(script);
            writer.flush();
            writer.close();
            LogFactory.getORMLogger(Model2Table.class).debug("create models sql script file success -> " + file.getAbsoluteFile());
        }
        catch (IOException e1) {
            return CommonUtil.getExceptionString(e1);
        }
        return null;
    }

    private static String getType(String type) {
        if ("int".equalsIgnoreCase(type) || "java.lang.Integer".equalsIgnoreCase(type)) {
            return "int";
        }
        if ("long".equalsIgnoreCase(type) || "java.lang.Long".equalsIgnoreCase(type)) {
            return "bigint";
        }
        if ("float".equalsIgnoreCase(type) || "java.lang.Float".equalsIgnoreCase(type)) {
            return "float";
        }
        if ("double".equalsIgnoreCase(type) || "java.lang.Double".equalsIgnoreCase(type)) {
            return "double";
        }
        if ("string".equalsIgnoreCase(type) || "java.lang.String".equalsIgnoreCase(type)) {
            return "varchar";
        }
        if ("boolean".equalsIgnoreCase(type) || "java.lang.Boolean".equalsIgnoreCase(type)) {
            return "boolean";
        }
        if ("date".equalsIgnoreCase(type) || "java.sql.Date".equalsIgnoreCase(type) || "java.util.Date".equalsIgnoreCase(type)) {
            return "datetime";
        }
        if ("timestamp".equalsIgnoreCase(type) || "java.sql.Timestamp".equalsIgnoreCase(type)) {
            return "timestamp";
        }
        if ("manyOne".equals(type)) {
            return "bigint";
        }
        if ("oneOne".equals(type)) {
            return "bigint";
        }
        return type;
    }
}

